// -*- C++ -*-

/*
 * Test program for random number generators
 */

#include <string.h>

#include <CNCL/Moments.h>

#include <CNCL/FiboG.h>

#include <CNCL/RandomMix.h>
#include <CNCL/NegExp.h>
#include <CNCL/Uniform.h>


enum { NRANDOM = 20, NVAL = 100000 };


char buffer[128];



main()
{
    int j;
    CNRNG *gen = new CNFiboG;
    CNRandomMixEntry x[] =
    {
	{ 0.5,  new CNNegExp(1, gen)       },
	{ 0.75, new CNUniform(0, 10, gen)  },
	{ 1.0 , new CNUniform(10, 20, gen) }
    };
    CNRandomMix rng(x, sizeof(x)/sizeof(CNRandomMixEntry), gen);

    rng.dump();
	
    strcpy(buffer, rng.class_desc()->name());
    strcat(buffer, " ");
    strcat(buffer, rng.class_desc()->version());
	
    CNMoments stat(buffer);
	    
    for(j=0; j<NVAL; j++)
	stat.put(rng());
	    
    cout << stat;
}
