//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: InterTab.c,v 0.22 1994/07/22 09:20:28 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNInterTab --- CNRandom numbers from table
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "InterTab.h"



double CNInterTab::operator()()
{
    long index;
    
    index = pGenerator -> as_long() % (len-1);
    
    return adr[index] + (adr[index+1] - adr[index])*pGenerator->as_double(); 
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNInterTab::print(ostream &strm) const
{
    CNTab::print(strm);
}

// Debug output
void CNInterTab::dump(ostream &strm) const
{
    strm << "CNInterTab { "
	 << this
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNInterTab
static CNClass CNInterTab_desc("CNInterTab", "$Revision: 0.22 $",
			   CNInterTab::new_object);

// "Type" for type checking functions
CNClassDesc CN_INTERTAB = &CNInterTab_desc;






