//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DiscUniform.c,v 0.22 1994/07/22 09:20:28 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDiscUniform --- Discrete uniform distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/

#include "DiscUniform.h"



double CNDiscUniform::operator()()
{
    long tmp = long(floor(delta * pGenerator -> as_double()));
    return( double(pLow + tmp) );
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNDiscUniform::print(ostream &strm) const
{
    strm << "low=" << pLow << " high=" << pHigh << " delta=" << delta << endl;
}

// Debug output
void CNDiscUniform::dump(ostream &strm) const
{
    strm << "CNDiscUniform { "
	 << "low=" << pLow << " high=" << pHigh << " delta=" << delta
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNDiscUniform
static CNClass CNDiscUniform_desc("CNDiscUniform", "$Revision: 0.22 $",
			      CNDiscUniform::new_object);

// "Type" for type checking functions
CNClassDesc CN_DISCUNIFORM = &CNDiscUniform_desc;






