//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DiracTab.c,v 0.22 1994/07/22 09:20:28 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDiracTab --- Created from CNCL template
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "DiracTab.h"



double CNDiracTab::operator()()
{
    CNDiracTabEntry *beg, *mid, *end;
    long i;
    double tmp;
    
    tmp = pGenerator -> as_double();
    
    beg = adr;
    mid = &adr[len/2];
    end = &adr[len-1];
    
    // Binary search
    while(TRUE)
    {
	if (tmp >= mid->yval)
	    beg = mid;
	else
	    end = mid;
	
	i   = end - beg;
	mid = beg + i/2;
	
	if (i == 1)
	    if (tmp >= mid->yval)
		mid = end;
	    else
		mid = beg;
    
        if(i <= 1)
            break;
    } 
    
    return(mid->xval);
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNDiracTab::print(ostream &strm) const
{
    strm << "n=" << len << " val={ ";
    for(int i=0; i<len; i++)
    {
	strm << "{" << adr[i].xval << "," << adr[i].yval << "}";
	if(i < len-1)
	    strm << ", ";
    }
    strm << " }" << endl;
}

// Debug output
void CNDiracTab::dump(ostream &strm) const
{
    strm << "CNDiracTab { "
	 << "n=" << len << " val={ ";
    for(int i=0; i<len; i++)
    {
	strm << "{" << adr[i].xval << "," << adr[i].yval << "}";
	if(i < len-1)
	    strm << ", ";
    }
    strm << " } }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNDiracTab
static CNClass CNDiracTab_desc("CNDiracTab", "$Revision: 0.22 $",
			   CNDiracTab::new_object);

// "Type" for type checking functions
CNClassDesc CN_DIRACTAB = &CNDiracTab_desc;






