//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FormFloat.c,v 0.22 1994/07/22 09:20:58 cncl-adm Exp cncl-adm $
 *
 * Class: FormFloat --- Doubles as CNStrings
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 **EHEADER********************************************************************/

#include "FormFloat.h"

#include <strstream.h>



void CNFormFloat::initialize(double x, int w, char fill, int f, int pr)
 /*
  * Creates the String acording to the given parameters 
  */ 
{
    delete p;
    init(w);
    len = w;
    val = x;
    form = f;
    cfill = fill;
    wide = w;
    prec = pr;
        
    ostrstream o(p, w+1);
    o.width(w);
    o.precision(pr);

    if(f & left)
	o.setf(ios::left);
    if(f & scientific)
	o.setf(ios::scientific);
    if(f & showpoint)
	o.setf(ios::showpoint);

    o.fill(fill);
    o << x << ends;
}

 /*
  * Changes the String and the value-parameter to x  
  */
void CNFormFloat::set_value(double x)
{
    if ( val != x ) initialize( x, wide, cfill, form, prec);
} 
void CNFormFloat::value(double x)
{
    if ( val != x ) initialize( x, wide, cfill, form, prec);
} 


 /*
  * Changes the String and the fill parameter to filling f
  */
void CNFormFloat::set_fill(char f)
{
    if ( cfill != f ) initialize( val, wide, f, form, prec);
}
void CNFormFloat::fill(char f)
{
    if ( cfill != f ) initialize( val, wide, f, form, prec);
}


 /* 
  * Changes the String and the format parameter to format f  
  */ 
void CNFormFloat::set_format(int f)
{
    if ( form != f ) initialize( val, wide, cfill, f, prec);
}
void CNFormFloat::format(int f)
{
    if ( form != f ) initialize( val, wide, cfill, f, prec);
}


/*
 *  Changes the String and the width parameter to w
 */
void CNFormFloat::set_width(int w)
{
    if ( wide != w ) initialize( val, w, cfill, form, prec);
}
void CNFormFloat::width(int w)
{
    if ( wide != w ) initialize( val, w, cfill, form, prec);
}


/*
 *  Changes the String and the prcision parameter to p
 */

void CNFormFloat::set_precision(int pr)
{
    if ( prec != pr ) initialize( val, wide, cfill, form, pr);
}
void CNFormFloat::precision(int pr)
{
    if ( prec != pr ) initialize( val, wide, cfill, form, pr);
}


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNFormFloat::print(ostream &strm) const
{
    strm << p << endl;
}

// Debug output
void CNFormFloat::dump(ostream &strm) const
{
    strm << "FormFloat { $Revision: 0.22 $ " << p 
         << " width " << wide
	 << " }" << endl;
}


/***** CNCL stuff for type information ***************************************/

// Describing object for class CNFormFloat
static CNClass CNFormFloat_desc("CNFormFloat", "$Revision: 0.22 $",
			    CNFormFloat::new_object);

// "Type" for type checking functions
CNClassDesc CN_FORMFLOAT = &CNFormFloat_desc;
