// -*- C++ -*-

// GIST -- Graphical Interactive Simulation Result Tool

//   CNCL interface classes

//   1992,93 Martin Horneffer

#ifndef gist_ivimpl_h
#define gist_ivimpl_h

#include <ctype.h>
#include <String.h>
#include <strstream.h>
#include "gist_impl.hh"
#include "gist_fn.hh"
#include <CNCL/Pipe.h>
#include <CNCL/SocketStream.h>

// interface to InterViews-GIST

class CommIVImpl: public CommImpl {
    ostream *out_;
    istream *in_;
    String host_;
    unsigned short port_;
    long id;
    SocketStream *socket;
    CNPipe *pipe;
  public:
    CommIVImpl(const char *host, unsigned short port);
    CommIVImpl(const char *host, unsigned short port, long magic);
    virtual ~CommIVImpl();
    virtual int ok();
    virtual const char *gist_type();
    virtual int newid();
    inline ostream &out() { return *out_; };
    inline istream &in() { return *in_; };
};

class WorldIVImpl: public GISTWorldImpl {
    int mode;
    double lasttime;
    ostrstream *str;
  public:
    long id;
    CommIVImpl *comm_;
    WorldIVImpl(CommImpl *comm, const char *name, 
		float xmin, float xmax, float ymin, float ymax, 
		double st, int m);
    virtual ~WorldIVImpl();
    virtual void flush();
    virtual void flush(double time, int force);
    virtual void flush(double time);
    virtual const char *gist_type();
    inline ostream& out() { return *str; };
};

class ObjectIVImpl: public GISTObjectImpl {
  public:
    long id;
    WorldIVImpl *world_;
    
    ObjectIVImpl(GISTWorldImpl *world,const char *name);
    virtual ~ObjectIVImpl() ;
    virtual const char *gist_type();
};

class AttributeIVImpl {
  public:
    long id;
    WorldIVImpl *world_;
    ObjectIVImpl *obj_;
    AttributeIVImpl(GISTObject *object);
    virtual ~AttributeIVImpl();
};
class TextAttributeIVImpl: public GISTTextAttributeImpl, AttributeIVImpl {
  public:
    TextAttributeIVImpl(GISTObject *object, const char *name);
    virtual void put(double time, const char *data);
};

class ValueAttributeIVImpl: public GISTValueAttributeImpl, AttributeIVImpl {
  public:
    ValueAttributeIVImpl(GISTObject *object, const char *name);
    virtual void put(double time, float data);
};

class CoordAttributeIVImpl: public GISTCoordAttributeImpl, AttributeIVImpl {
  public:
    CoordAttributeIVImpl(GISTObject *object, const char *name);
    virtual void put(double time, float x, float y);
};

class ValueArrayAttributeIVImpl: public GISTValueArrayAttributeImpl, AttributeIVImpl {
    unsigned short dim;
  public:
    ValueArrayAttributeIVImpl(GISTObject *object, const char *name, unsigned short arraydim);
    virtual void put(double time, const float data[]);
};

class CoordArrayAttributeIVImpl: public GISTCoordArrayAttributeImpl, AttributeIVImpl {
  public:
    unsigned short dim;
    CoordArrayAttributeIVImpl(GISTObject *object, const char *name,unsigned short arraydim);
    virtual void put(double time, const float data[]);
};


class GraphicIVImpl {
    char colorbuf[80];
  public:
    long id;
    WorldIVImpl *world_;
    ObjectIVImpl *obj_;
    int byte(float);
    virtual const char *xcolor_name(float red, float green, float blue);

    GraphicIVImpl(GISTObject *object);
    virtual ~GraphicIVImpl();
};

class PictureIVImpl: public GISTPictureImpl, GraphicIVImpl {
  public:
    PictureIVImpl(GISTObject *parent,
		  const char *name,
		  int prio,
		  GISTTextAttributeImpl *vis,
		  GISTWorldImpl *world);
    virtual const char *color_name(float red, float green, float blue);
    virtual void set_color(const char *color);
    virtual void set_color(GISTTextAttributeImpl *attr);
    virtual void set_brush(float thickness, unsigned short pattern);
    virtual void pen_down();
    virtual void pen_up();
    virtual void pen_up_fill();
    virtual void set_pos(float x, float y);
    virtual void set_pos(GISTCoordAttributeImpl *attr);
    virtual void set_path(GISTCoordArrayAttributeImpl *attr);
    virtual void move_rel(float dx, float dy);
    virtual void move_rel(float dx, GISTValueAttributeImpl *dy);
    virtual void move_rel(GISTValueAttributeImpl *dx,float dy);
    virtual void move_rel(GISTValueAttributeImpl *dx,GISTValueAttributeImpl *dy);
    virtual void move_dir(float dx, GISTValueAttributeImpl *dy);
    virtual void move_dir(GISTValueAttributeImpl *dx,float dy);
    virtual void move_dir(GISTValueAttributeImpl *dx,GISTValueAttributeImpl *dy);
    virtual void text(const char *text,float size,const char *font,const char *style);
    virtual void text(GISTTextAttributeImpl *text,float size,const char *font,const char *style);
    virtual void draw_image(const char *name,float x_align,float y_align);
    virtual void draw_image(GISTTextAttributeImpl *name,float x_align, float y_align);
};

class ImageIVImpl: public GISTGraphicImpl, GraphicIVImpl {
  public:
    virtual const char *color_name(float red, float green, float blue);
    ImageIVImpl(GISTObject *parent,
		const char *name,
		const char *image, 
		float x, float y,
		float width, float height,
		float hcenter, float vcenter,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world);
    ImageIVImpl(GISTObject *parent,
		const char *name,
		const char *image, 
		GISTCoordAttributeImpl *position,
		float width, float height,
		float hcenter, float vcenter,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world);
    ImageIVImpl(GISTObject *parent,
		const char *name,
		GISTTextAttributeImpl *image, 
		float x, float y,
		float width, float height,
		float hcenter, float vcenter,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world);
    ImageIVImpl(GISTObject *parent,
		const char *name,
		GISTTextAttributeImpl *image, 
		GISTCoordAttributeImpl *position,
		float width, float height,
		float hcenter, float vcenter,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world);
};

class CurveIVImpl: public GISTGraphicImpl, GraphicIVImpl {
  public:
    virtual const char *color_name(float red, float green, float blue);
    CurveIVImpl(GISTObject *parent,
		const char *name,
		GISTValueAttributeImpl *value, 
		float x, float y, int type,
		float width, float height,
		float hcenter, float vcenter,
		const char *foreg, const char *backg,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world);
    virtual void hint(const char*text);
};

class DiagramIVImpl: public GISTGraphicImpl, GraphicIVImpl {
  public:
    virtual const char *color_name(float red, float green, float blue);
    DiagramIVImpl(GISTObject *parent,
		  const char *name,
		  GISTCoordArrayAttributeImpl *value, 
		  float x, float y, int type,
		  float width, float height,
		  float hcenter, float vcenter,
		  const char *foreg, const char *backg,
		  int prio,
		  GISTTextAttributeImpl *vis,
		  GISTWorldImpl *world);
    virtual void hint(const char*text);
};


#endif 
