//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ValueObject.c,v 0.22 1994/07/22 09:21:52 cncl-adm Exp cncl-adm $
 *
 * Class: ValueObject --- replacement for GIST1 ValueObject
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include "ValueObject.h"

ValueObject::ValueObject(World& w,
			 const char *objectname,
			 const char *color,
			 float x, float y, 
			 float width = 0.0, float height = 0.0,
			 double time = 0.0, 
			 Displaymode mode = text) :
  ColorfulObject(w, objectname)
{
    lasttime = time;
    if (mode == text) {
	txt = new GISTTextAttribute(this, "Value");
	pic = new GISTPicture(this, "Image");
	pic->set_pos(x,y);
	pic->text(txt, height, "courier");
    } else {
	val = new GISTValueAttribute(this, "Value");
	crv = new GISTCurve(this,objectname,val,x,y,GISTCurve::simple,width,height);
    };
};

void ValueObject::move(float x, float y, double time) {};

void ValueObject::change_look(const char *picname) {};

void ValueObject::change_color(const char *color) {};

void ValueObject::change_color(float red, float green, float blue) {};

void ValueObject::put_value(double time, float newvalue) {
    lasttime = time;
    if (val) {
	val->put(time, newvalue);
    } else {
	ostrstream buf;
	buf << newvalue << ends;
	txt->put(time, buf.str());
    };
};

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void ValueObject::print(ostream &strm) const
{
    GISTObject::print(strm);
    if (val) {
	val->print(strm);
	crv->print(strm);
    } else  {
	txt->print(strm);
	pic->print(strm);
    };
}

// Debug output
void ValueObject::dump(ostream &strm) const
{
    strm << "ValueObject { $Revision: 0.22 $" << endl;
    GISTObject::dump(strm);
    if (val) {
	val->dump(strm);
	crv->dump(strm);
    } else  {
	txt->dump(strm);
	pic->dump(strm);
    };
    strm << " }" << endl;
}

/***** CNCL stuff for type information ***************************************/

// Describing object for class ValueObject
static CNClass ValueObject_desc("ValueObject", "$Revision: 0.22 $",
				ValueObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_VALUEOBJECT = &ValueObject_desc;
