//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: MovingObject.c,v 0.22 1994/07/22 09:21:52 cncl-adm Exp cncl-adm $
 *
 * Class: MovingObject --- replacement for GIST1 MovingObject
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include "MovingObject.h"

MovingObject::MovingObject(World& w,
			   const char *picname,
			   float x, float y, float width = 0, float height = 0,
			   double time = 0):
  GISTObject(w.world(), "GIST1 unnamed MovingObject") 
{
    pos = new GISTCoordAttribute(this, "Position");
    look = new GISTTextAttribute(this, "Look");
    img = new GISTImage(this, "Image", look, pos, width, height);
    lasttime = time;
    look->put(time, picname);
    pos->put(time, x, y);
};

MovingObject::MovingObject(World& w,
			   const char *objectname,
			   const char *picname,
			   float x, float y, float width = 0, float height = 0,
			   double time = 0):
  GISTObject(w.world(), objectname)
{
    pos = new GISTCoordAttribute(this, "Position");
    look = new GISTTextAttribute(this, "Look");
    img = new GISTImage(this, "Image", look, pos, width, height);
    lasttime = time;
    pos->put(time, x, y);
    look->put(time, picname);
};

MovingObject::MovingObject(World &w,const char *objectname):
  GISTObject(w.world(), objectname) {};

void MovingObject::move(float x, float y, double time) {
    pos->put(time, x, y);
    lasttime = time;
};

void MovingObject::change_look(const char *picname) {
    look->put(lasttime, picname);
};


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void MovingObject::print(ostream &strm) const
{
    GISTObject::print(strm);
    pos->print(strm);
    look->print(strm);
    img->print(strm);
}

// Debug output
void MovingObject::dump(ostream &strm) const
{
    strm << "MovingObject { $Revision: 0.22 $" << endl;
    GISTObject::dump(strm);
    pos->dump(strm);
    look->dump(strm);
    img->dump(strm);
    strm  << " }" << endl;
}


/***** CNCL stuff for type information ***************************************/

// Describing object for class MovingObject
static CNClass MovingObject_desc("MovingObject", "$Revision: 0.22 $",
				 MovingObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_MOVINGOBJECT = &MovingObject_desc;
