// -*- C++ -*-

/*
 * Dies ist das Beispiel "Besuch einer Vorlesung" aus dem Buch "Fuzzy Logic -
 * Einfuehrung und Leitfaden zur praktischen Anwendung - Mit Fuzzy-Shell
 * in C++". Leider sind die Regeln nicht besonders brauchbar und mit anderen
 * Werten als denjenigen in der Beispielregelbasis kommt oft nichts
 * vernuenftiges raus.
 */

#include <CNCL/FVar.h>
#include <CNCL/FSetTrapez.h>
#include <CNCL/FSetTriangle.h>
#include <CNCL/FSetArray.h>
#include <CNCL/FRuleBase.h>

#include <iomanip.h>


const int NX = 75;


void plot(CNFSet *set, double min, double max)
{
    double p, x, dx;
    int i, l;
    
    dx = (max - min) / NX;

    for(l=0; l<=20; l++)
    {
	p = (20. - l)/20.;
	if((l % 2) == 0)
	    cout << setw(3) << p << "-";
	else
	    cout << "    ";
	for(i=0, x=min; i<=NX; i++, x+=dx)
	{
	    if(i==NX)
		x = max;
	    if(set->get_membership(x) >= p)
		cout << '#';
	    else
		cout << ' ';
	}
	cout << endl;
    }
}


void plot_arrow(double val, double min, double max)
{
    double x, dx;
    int i;
    
    dx = (max - min) / NX;

    cout << "    ";
    for(i=0, x=min; i<=NX; i++, x+=dx)
	if(x >= val)
	{
	    cout << "^";
	    break;
	}
	else
	    cout << " ";
    cout << endl;
    
    cout << "    ";
    for(i=0, x=min; i<=NX; i++, x+=dx)
	if(x >= val)
	{
	    cout << "|";
	    break;
	}
	else
	    cout << " ";
    cout << endl;
}



main()
{
    /*
     * Input-Variablen
     */

    /* Uhrzeit der Vorlesung: 7:00 -- 21:00 */
    CNFVar       uhrzeit      ("Uhrzeit", 7, 21);
    CNFSetTrapez zu_frueh     ("zu_frueh",  7,  9, 1, 1);
    CNFSetTrapez frueh        ("frueh",     9, 11, 2, 1);
    CNFSetTrapez angenehm     ("angenehm", 11, 15, 1, 1);
    CNFSetTrapez spaet        ("spaet",    15, 18, 1, 1);
    CNFSetTrapez zu_spaet     ("zu_spaet", 18, 21, 1, 1);
    uhrzeit.add_value_set(zu_frueh);
    uhrzeit.add_value_set(frueh);
    uhrzeit.add_value_set(angenehm);
    uhrzeit.add_value_set(spaet);
    uhrzeit.add_value_set(zu_spaet);
    
    /* Sitzplatz im Hoersaal: 0% - total voll, 100% - leer */
    CNFVar       sitzplatz    ("Sitzplatz", 0, 100);
    CNFSetTrapez ausreichend  ("ausreichend", 30, 100, 5,  1);
    CNFSetTrapez akzeptabel   ("akzeptabel",  15,  30, 5, 10);
    CNFSetTrapez voll         ("voll",         5,  15, 5,  5);
    CNFSetTrapez ueberfuellt  ("ueberfuellt",  0,   5, 1,  5);
    sitzplatz.add_value_set(ausreichend);
    sitzplatz.add_value_set(akzeptabel);
    sitzplatz.add_value_set(voll);
    sitzplatz.add_value_set(ueberfuellt);
    
    /* Abwesenheit des Dozenten */
    CNFVar       abwesenheit  ("Abwesenheit", 0, 20);
    CNFSetTrapez zu_wenig     ("zu_wenig",  0,  3, 1, 1);
    CNFSetTrapez richtig      ("richtig",   3,  7, 1, 1);
    CNFSetTrapez zu_oft       ("zu_oft",    7, 20, 1, 1);
    abwesenheit.add_value_set(zu_wenig);
    abwesenheit.add_value_set(richtig);
    abwesenheit.add_value_set(zu_oft);
    
    /* Teilnehmernzahl */
    CNFVar       teilnehmer   ("Teilnehmer", 0, 300);
    CNFSetTrapez zu_wenige    ("zu_wenige",      0,  20,  1, 5);
    CNFSetTrapez wenige       ("wenige",        20,  50,  5, 10);
    CNFSetTrapez genau_richtig("genau_richtig", 50, 100, 20, 20);
    CNFSetTrapez viele        ("viele",        100, 200, 20, 20);
    CNFSetTrapez zu_viele     ("zu_viele",     200, 300, 20, 1);
    teilnehmer.add_value_set(zu_wenige);
    teilnehmer.add_value_set(wenige);
    teilnehmer.add_value_set(genau_richtig);
    teilnehmer.add_value_set(viele);
    teilnehmer.add_value_set(zu_viele);
    
    /* Pruefungsrelevanz: 0 -- 100 % */
    CNFVar       pruefung     ("Pruefung", 0, 100);
    CNFSetTrapez unrelevant   ("unrelevant",    0,   5, 1, 5);
    CNFSetTrapez kaum_relevant("kaum_relevant", 5,  15, 5, 5);
    CNFSetTrapez wichtig      ("wichtig",      15,  35, 5, 5);
    CNFSetTrapez entscheidend ("entscheidend", 35, 100, 5, 1);
    pruefung.add_value_set(unrelevant); 
    pruefung.add_value_set(kaum_relevant);
    pruefung.add_value_set(wichtig);
    pruefung.add_value_set(entscheidend);
   
    /*
     * Output-Variablen
     */

    /* Entscheidung Besuch */
    CNFVar       besuch       ("Besuch", 0, 3);
    CNFSetTriangle ja         ("Ja",   1, 1, 1);
    CNFSetTriangle nein       ("Nein", 2, 1, 1);
    besuch.add_value_set(ja);
    besuch.add_value_set(nein);
    
    /*
     * Regeln
     */
    CNFRule r0;
    r0.add_lhs(new CNFClause(uhrzeit,     zu_spaet     ));
    r0.add_lhs(new CNFClause(sitzplatz,   ueberfuellt  ));
    r0.add_lhs(new CNFClause(abwesenheit, richtig      ));
    r0.add_lhs(new CNFClause(teilnehmer,  wenige       ));
    r0.add_lhs(new CNFClause(pruefung,    entscheidend ));
    r0.add_rhs(new CNFClause(besuch,      ja           ));
    r0.certainty(0.5);

    CNFRule r1;
    r1.add_lhs(new CNFClause(uhrzeit,     zu_spaet     ));
    r1.add_lhs(new CNFClause(sitzplatz,   akzeptabel   ));
    r1.add_lhs(new CNFClause(abwesenheit, richtig      ));
    r1.add_lhs(new CNFClause(teilnehmer,  viele        ));
    r1.add_lhs(new CNFClause(pruefung,    entscheidend ));
    r1.add_rhs(new CNFClause(besuch,      ja           ));
    r1.certainty(0.8);

    CNFRule r2;
    r2.add_lhs(new CNFClause(uhrzeit,     angenehm     ));
    r2.add_lhs(new CNFClause(sitzplatz,   ausreichend  ));
    r2.add_lhs(new CNFClause(abwesenheit, zu_oft       ));
    r2.add_lhs(new CNFClause(teilnehmer,  zu_viele     ));
    r2.add_lhs(new CNFClause(pruefung,    wichtig      ));
    r2.add_rhs(new CNFClause(besuch,      ja           ));
    r2.certainty(0.7);

    CNFRule r3;
    r3.add_lhs(new CNFClause(uhrzeit,     angenehm     ));
    r3.add_lhs(new CNFClause(sitzplatz,   akzeptabel   ));
    r3.add_lhs(new CNFClause(abwesenheit, zu_wenig     ));
    r3.add_lhs(new CNFClause(teilnehmer,  viele        ));
    r3.add_lhs(new CNFClause(pruefung,    wichtig      ));
    r3.add_rhs(new CNFClause(besuch,      ja           ));
    r3.certainty(0.9);

    CNFRule r4;
    r4.add_lhs(new CNFClause(uhrzeit,     angenehm     ));
    r4.add_lhs(new CNFClause(sitzplatz,   voll         ));
    r4.add_lhs(new CNFClause(abwesenheit, zu_oft       ));
    r4.add_lhs(new CNFClause(teilnehmer,  genau_richtig));
    r4.add_lhs(new CNFClause(pruefung,    wichtig      ));
    r4.add_rhs(new CNFClause(besuch,      ja           ));
    r4.certainty(0.7);

    CNFRule r5;
    r5.add_lhs(new CNFClause(uhrzeit,     zu_frueh     ));
    r5.add_lhs(new CNFClause(sitzplatz,   akzeptabel   ));
    r5.add_lhs(new CNFClause(abwesenheit, richtig      ));
    r5.add_lhs(new CNFClause(teilnehmer,  zu_wenige    ));
    r5.add_lhs(new CNFClause(pruefung,    kaum_relevant));
    r5.add_rhs(new CNFClause(besuch,      nein         ));
    r5.certainty(0.8);

    CNFRule r6;
    r6.add_lhs(new CNFClause(uhrzeit,     zu_frueh     ));
    r6.add_lhs(new CNFClause(sitzplatz,   voll         ));
    r6.add_lhs(new CNFClause(abwesenheit, richtig      ));
    r6.add_lhs(new CNFClause(teilnehmer,  zu_viele     ));
    r6.add_lhs(new CNFClause(pruefung,    kaum_relevant));
    r6.add_rhs(new CNFClause(besuch,      nein         ));
    r6.certainty(0.7);

    CNFRule r7;
    r7.add_lhs(new CNFClause(uhrzeit,     spaet        ));
    r7.add_lhs(new CNFClause(sitzplatz,   ueberfuellt  ));
    r7.add_lhs(new CNFClause(abwesenheit, richtig      ));
    r7.add_lhs(new CNFClause(teilnehmer,  viele        ));
    r7.add_lhs(new CNFClause(pruefung,    kaum_relevant));
    r7.add_rhs(new CNFClause(besuch,      nein         ));
    r7.certainty(0.7);

    CNFRule r8;
    r8.add_lhs(new CNFClause(uhrzeit,     frueh        ));
    r8.add_lhs(new CNFClause(sitzplatz,   ausreichend  ));
    r8.add_lhs(new CNFClause(abwesenheit, zu_oft       ));
    r8.add_lhs(new CNFClause(teilnehmer,  wenige       ));
    r8.add_lhs(new CNFClause(pruefung,    unrelevant   ));
    r8.add_rhs(new CNFClause(besuch,      nein         ));
    r8.certainty(0.9);

    CNFRule r9;
    r9.add_lhs(new CNFClause(uhrzeit,     frueh        ));
    r9.add_lhs(new CNFClause(sitzplatz,   voll         ));
    r9.add_lhs(new CNFClause(abwesenheit, zu_wenig     ));
    r9.add_lhs(new CNFClause(teilnehmer,  genau_richtig));
    r9.add_lhs(new CNFClause(pruefung,    unrelevant   ));
    r9.add_rhs(new CNFClause(besuch,      nein         ));
    r9.certainty(0.9);

    CNFRuleBase base("Vorlesung");
    base.add_rule(r0);
    base.add_rule(r1);
    base.add_rule(r2);
    base.add_rule(r3);
    base.add_rule(r4);
    base.add_rule(r5);
    base.add_rule(r6);
    base.add_rule(r7);
    base.add_rule(r8);
    base.add_rule(r9);

    base.add_in_var (uhrzeit);
    base.add_in_var (sitzplatz);
    base.add_in_var (abwesenheit);
    base.add_in_var (teilnehmer);
    base.add_in_var (pruefung);
    base.add_out_var(besuch);
    
    cout << base;

    /*
     * Set values
     */
    uhrzeit    .value(  12 );
    sitzplatz  .value(  25 );
    abwesenheit.value(   1 );
    teilnehmer .value( 150 );
    pruefung   .value(  25 );  

    base.evaluate_all();
    base.defuzzy_all();
    
//     plot      (besuch.fuzzy_value(), 0, 3);
//     plot_arrow(besuch.value(),       0, 3);
//     
//     cout << "Defuzzy=" << besuch.value() << endl;
}
