// -*- C++ -*-

#include <CNCL/FVar.h>
#include <CNCL/FSetTrapez.h>
#include <CNCL/FSetTriangle.h>
#include <CNCL/FRuleBase.h>
#include <iomanip.h>



void plot(CNFSet *set, double min, double max)
{
    double p, x, dx;
    int i, l;
    const int NX = 75, NY = 10;

    dx = (max - min) / NX;

    for(l=0; l<=NY; l++)
    {
	p = double(NY - l)/NY;
	if((l % 2) == 0)
	    cout << setw(3) << p << "-";
	else
	    cout << "    ";
	for(i=0, x=min; i<=NX; i++, x+=dx)
	{
	    if(i==NX)
		x = max;
	    if(set->get_membership(x) >= p)
		cout << '#';
	    else
		cout << ' ';
	}
	cout << endl;
    }
}





main()
{
    CNFRuleBase base;

    CNFVar temp;
    CNFVar heater;

    CNFSetTrapez cold;
    CNFSetTrapez medium;
    CNFSetTrapez hot;

    CNFSetTriangle off;
    CNFSetTriangle half;
    CNFSetTriangle full;

    CNFRule r1, r2, r3;
    
    /*
     * Setup fuzzy values and variables
     */
    temp  .init("Temperature", 0, 100);
    heater.init("Heater", 0, 1);

    cold  .init("cold"  ,  0, 10,  0,  5);
    medium.init("medium", 15, 20,  5,  5);
    hot   .init("hot"   , 25,100,  5,  0);

    off   .init("off" ,   0,   0, 0.1);
    half  .init("half", 0.5, 0.1, 0.1);
    full  .init("full",   1, 0.1,   0);

    temp.add_value_set(cold);
    temp.add_value_set(medium);
    temp.add_value_set(hot);
    
    heater.add_value_set(off);
    heater.add_value_set(half);
    heater.add_value_set(full);
    
    /*
     * Setup rules
     */
    r1.add_lhs(new CNFClause(temp, cold));
    r1.add_rhs(new CNFClause(heater, full));

    r2.add_lhs(new CNFClause(temp, medium));
    r2.add_rhs(new CNFClause(heater, half));

    r3.add_lhs(new CNFClause(temp, hot));
    r3.add_rhs(new CNFClause(heater, off));

    base.add_rule(r1);
    base.add_rule(r2);
    base.add_rule(r3);
    base.add_in_var(temp);
    base.add_out_var(heater);


    cout << "//----- Fuzzy rules -----" << endl << base << endl;

    while(TRUE)
    {

	double t;

	cout << "Temperature> ";
	cin  >> t;
	if(cin.eof() || !cin.good())
	    break;

	temp.value(t);

	temp.print_membership();

	base.evaluate_all();
	base.defuzzy_all();

	base.debug_rules();

	plot(heater.fuzzy_value(), 0, 1);
	
	cout << "Heater = " << heater.value() << endl;
    }
    
    exit(0);
}


