// -*- C++ -*-

#include <CNCL/FVar.h>
#include <CNCL/FSetTrapez.h>
#include <CNCL/FSetArray.h>
#include <CNCL/FRuleBase.h>

#include <iomanip.h>


const int NX = 75;


void plot(CNFSet *set, double min, double max)
{
    double p, x, dx;
    int i, l;
    
    dx = (max - min) / NX;

    for(l=0; l<=20; l++)
    {
	p = (20. - l)/20.;
	if((l % 2) == 0)
	    cout << setw(3) << p << "-";
	else
	    cout << "    ";
	for(i=0, x=min; i<=NX; i++, x+=dx)
	{
	    if(i==NX)
		x = max;
	    if(set->get_membership(x) >= p)
		cout << '#';
	    else
		cout << ' ';
	}
	cout << endl;
    }
}


void plot_arrow(double val, double min, double max)
{
    double x, dx;
    int i;
    
    dx = (max - min) / NX;

    cout << "    ";
    for(i=0, x=min; i<=NX; i++, x+=dx)
	if(x >= val)
	    cout << "^";
	else
	    cout << " ";
    cout << endl;
    
    cout << "    ";
    for(i=0, x=min; i<=NX; i++, x+=dx)
	if(x >= val)
	    cout << "|";
	else
	    cout << " ";
    cout << endl;
}



main()
{
    CNFVar temp("Temperatur", 0, 100);
    enum { KALT, MITTEL, WARM, HEISS };

    CNFSetTrapez kalt  ("kalt",    0, 10,  0, 10);
    CNFSetTrapez mittel("mittel", 20, 20, 10, 10);
    CNFSetTrapez warm  ("warm",   30, 40, 10,  5);
    CNFSetTrapez heiss ("heiss",  40,100, 10,  0);

    temp.add_value_set(KALT,   kalt  );
    temp.add_value_set(MITTEL, mittel);
    temp.add_value_set(WARM,   warm  );
    temp.add_value_set(HEISS,  heiss );

    CNFVar vorlauf("Vorlauf", 0, 100);
    
    enum { NIEDRIG, HOCH };
    
    CNFSetTrapez niedrig("niedrig", 30, 40, 10, 10);
    CNFSetTrapez hoch   ("hoch",    50, 60, 10, 10);
    
    vorlauf.add_value_set(NIEDRIG, niedrig);
    vorlauf.add_value_set(HOCH,    hoch);

    CNFVar brenner("Brenner", 0, 1);
    
    enum { AUS, HALB, VOLL };
    
    CNFSetTrapez aus ("aus",    0, 0.2,   0, 0.2);
    CNFSetTrapez halb("halb", 0.4, 0.6, 0.2, 0.2);
    CNFSetTrapez voll("voll", 0.8,   1, 0.2,   0);

    brenner.add_value_set(AUS,  aus);
    brenner.add_value_set(HALB, halb);
    brenner.add_value_set(VOLL, voll);
    

    temp.value(12);
    vorlauf.value(25);

    CNFRule r1;
    r1.add_lhs(new CNFClause(temp,    kalt   ));
    r1.add_lhs(new CNFClause(vorlauf, niedrig));
    r1.add_rhs(new CNFClause(brenner, voll   ));

    CNFRule r2;
    r2.add_lhs(new CNFClause(temp,    mittel ));
    r2.add_lhs(new CNFClause(vorlauf, niedrig));
    r2.add_rhs(new CNFClause(brenner, halb   ));
    
    CNFRuleBase base;
    base.add_rule(r1);
    base.add_rule(r2);
    base.add_in_var(temp);
    base.add_in_var(vorlauf);
    base.add_out_var(brenner);
    
    cout << base;

    base.evaluate_all();
    base.defuzzy_all();
    
    plot      (brenner.fuzzy_value(), 0, 1);
    plot_arrow(brenner.value(),       0, 1);
    
    cout << "Defuzzy=" << brenner.value() << endl;
}
