// -*- C++ -*-

#include <CNCL/FSetLR.h>
#include <CNCL/FSetTrapez.h>
#include <CNCL/FSetTriangle.h>
#include <CNCL/FSetArray.h>



void plot(CNFSet &set, double min, double max)
{
    double p, x, dx;
    const int NX = 70;
    int i, l;
    
    dx = (max - min) / (NX - 1);

    for(l=0; l<=20; l++)
    {
	p = (20. - l)/20.;
	for(i=0, x=min; i<=NX; i++, x+=dx)
	    // cout << x << "  " << set.get_membership(x) << endl;
	    if(set.get_membership(x) >= p)
		cout << '#';
	    else
		cout << ' ';
	cout << endl;
    }
}



int main()
{
//    CNFSetLR       set(0, 1,   2, 3, 1, 1, CNFuncExp, CNFuncLin);
//    CNFSetLR       set("Test", 2, 3, 1, 1, CNFuncExp, CNFuncLin);
//    CNFSetTrapez   set(0, 1,   2, 3, 1, 1);
//    CNFSetTrapez   set("Test", 2, 3, 1, 1);
//    CNFSetTriangle set(0, 1,   2,    1, 1);
    CNFSetTriangle set("Test", 2,    1, 1);
    
    set.dump();
    plot(set, 0, 5);

    CNFSetArray aset(10, 1, 4);
    aset[0] = 0;
    aset[1] = 0.5;
    aset[2] = 0.7;
    aset[3] = 0.8;
    aset[4] = 0.9;
    aset[5] = 0.95;
    aset[6] = 1;
    aset[7] = 0.95;
    aset[8] = 0.7;
    aset[9] = 0.2;

    aset.dump();
    plot(aset, 0, 5);
}
