//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDTextWin.c,v 0.22 1994/07/22 09:21:19 cncl-adm Exp cncl-adm $
 *
 * Class: EZDTextWin --- ezd window for easy text display
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "EZDTextWin.h"



/*
 * Destructor
 */
EZDTextWin::~EZDTextWin()
{
    if(win)  delete win;
    if(draw) delete draw;
}



/*
 * Initialize text window
 */
void EZDTextWin::initialize(CNStringR title, int x, int y)
{
    save_drawing();
    
    w_width   = w_cols * w_incx;
    w_height  = w_rows * w_incy;

    win     = new EZDWindow (name(), title, x, y, w_width, w_height);
    draw    = new EZDDrawing(name());
    win->overlay(draw);
    draw_clear();
    win->set_auto_resize(1, draw);
    
    restore_drawing();
}



/*
 * Set current drawing to text window drawing
 */
void EZDTextWin::set()
{
    draw->set();
}



/*
 * Clear text window
 */
void EZDTextWin::clear()
{
    save_drawing();
    set();

    draw_clear();
    win->set_auto_resize(1, draw);

    restore_drawing();
}



/*
 * Clear window area
 */
void EZDTextWin::clear_i(int r, int c, int l)
{
    int x, y, w, h;
    
    x = c*w_incx;
    y = r*w_incy;
    w = l*w_incx;
    h =   w_incy; 
    
    draw_fill_rectangle(x, y, w, h, "white");
}

void EZDTextWin::clear(int r, int c, int l)
{
    save_drawing();
    set();
    clear_i(r, c, l);
    restore_drawing();
}



/*
 * Draw text string in window
 */
void EZDTextWin::add(int r, int c, CNStringR s)
{
    save_drawing();
    set();

    clear_i(r, c, s.length());
    draw_text(c*w_incx, r*w_incy, s, w_color, w_font);

    restore_drawing();
}

void EZDTextWin::add(int r, int c, CNStringR s, CNStringR f)
{
    save_drawing();
    set();

    clear_i(r, c, s.length());
    draw_text(c*w_incx, r*w_incy, s, w_color, f);

    restore_drawing();
}



/*
 * Horizontal/vertical lines
 */
void EZDTextWin::hline(int r, int c, int l)
{
    int x, y, len;
    
    x   = c*w_incx;
    y   = r*w_incy + w_incy/2;
    len = l*w_incx;
    
    save_drawing();
    set();

    draw_line(x, y, x+len-1, y, w_color);

    restore_drawing();
}

void EZDTextWin::vline(int r, int c, int l)
{
    int x, y, len;
    
    x   = c*w_incx + w_incx/2;
    y   = r*w_incy;
    len = l*w_incy;
    
    save_drawing();
    set();

    draw_line(x, y, x, y+len-1, w_color);

    restore_drawing();
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDTextWin::print(ostream &strm) const
{
    strm << "..." << endl;
}

// Debug output
void EZDTextWin::dump(ostream &strm) const
{
    strm << "EZDTextWin { $Revision: 0.22 $ ..."
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDTextWin
static CNClass EZDTextWin_desc("EZDTextWin", "$Revision: 0.22 $",
			       EZDTextWin::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDTEXTWIN = &EZDTextWin_desc;
