//*BHEADER* :ts=8  -*- C++ -*-
/******************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDQueue.c,v 0.22 1994/07/22 09:21:19 cncl-adm Exp cncl-adm $
 *
 * Class: EZDQueue --- Graphical representation of queue
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "EZDQueue.h"



/*
 * Initialize coordinates
 */
void EZDQueue::initialize(int width, int height, int tail)
{
    x1 = 0;
    y1 = -height/2 - SEP;
    y2 =  height/2 + SEP;
    h  = height;
    yb = y1 + SEP;
    x2 = x1 + width;
    x3 = x2 + SEP;
    x4 = x3 + tail;

    bar = new EZDObject(name()+"-bar", x(), y());
    len = 0;
    col = "";
}



/*
 * Draw queue
 */
virtual void EZDQueue::redraw()
{
    /* Draw frame */
    start();
    line(x1, y1, x3, y1, "");
    line(x1, y2, x3, y2, "");
    line(x3, y1, x3, y2, "");
    line(x3,  0, x4,  0, "");
    end();
    /* Draw bar */
    redraw_bar();
}



/*
 * Draw bar - separate object
 */
void EZDQueue::redraw_bar()
{
    bar->start();
    bar->fill_rectangle(x2-len, yb, len, h, col);
    bar->end();
    EZD::pause(1);
}



/*
 * Set length and draw bar
 */
void EZDQueue::length(int l)
{
    len = l;
    redraw_bar();
}

void EZDQueue::set_length(int l)
{
    len = l;
    redraw_bar();
}

    

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDQueue::print(ostream &strm) const
{
    // ... insert your own stuff here ...
    strm << "..." << endl;
}

// Debug output
void EZDQueue::dump(ostream &strm) const
{
    // ... insert your own stuff here ...
    strm << "EZDQueue { $Revision: 0.22 $"
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDQueue
static CNClass EZDQueue_desc("EZDQueue", "$Revision: 0.22 $",
			     EZDQueue::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDQUEUE = &EZDQueue_desc;






