//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDPopUp.c,v 0.22 1994/07/22 09:21:19 cncl-adm Exp cncl-adm $
 *
 * Class: EZDPopUp ---  Interface to EZD popup menu
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include <CNCL/EZDPopUp.h>
#include <stdarg.h>


EZDPopUp::EZDPopUp(const int nmenu, const MENU *menu ...)
{
    va_list ap;
    int len=0, len_ges=0;
    int pixel = 8;
    const CNString font = "-*-*-bold-r-*-*-13-*-*-*-*-*-*-*";
    CNString PopUp_Name;
    const MENU *menu_ptr;
    
    va_start(ap, menu);
    menu_ptr = menu;
    for (int i=0; i < nmenu; i++)
    {
	start(menu_ptr->title);
	len_ges += menu_ptr->title.length();
	len = menu_ptr->title.length();
	text(menu_ptr->posx+len_ges*pixel, menu_ptr->posy, len*pixel, 
	     menu_ptr->height, "center center",
	     menu_ptr->title, menu_ptr->t_color, font);
	len_ges += 3;
	end();

	PopUp_Name = menu_ptr->title;
	PopUp_Name += "_PU";
	out() << "(define-popup " << PopUp_Name;
	for (int j=0; j<menu_ptr->anz; j++)
	    out() << " \"" << menu_ptr->inhalt[j] << "\" " << 
		menu_ptr->scheme_func[j];
	out() << " " << menu_ptr->f_color << " " << 
	    menu_ptr->b_color << ")" << endl;
	out().flush();
	out() << "(when " << menu_ptr->title << " button1down (" <<
	    PopUp_Name << "))" << endl;
	menu_ptr = va_arg(ap, const MENU *);
    }
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDPopUp::print(ostream &strm) const
{
    strm << "..." << endl;
}

// Debug output
void EZDPopUp::dump(ostream &strm) const
{
    strm << "EZDPopUp { $Revision: 0.22 $ ..."
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDPopUp
static CNClass EZDPopUp_desc("EZDPopUp", "$Revision: 0.22 $",
			    EZDPopUp::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDPOPUP = &EZDPopUp_desc;
