//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDDiagWin.c,v 0.22 1994/07/22 09:21:19 cncl-adm Exp cncl-adm $
 *
 * Class: EZDDiagWin --- Extra window with x-y diagram
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "EZDDiagWin.h"



/*
 * Destructor
 */
EZDDiagWin::~EZDDiagWin()
{
    if(win)  delete win;
    if(draw) delete draw;
    if(vals) delete vals;
}



/*
 * Initialize diagram window
 */
void EZDDiagWin::initialize(CNStringR title, int x, int y, int w, int h, int s)
{
    save_drawing();
    
    width   = w;
    height  = h;

    valx    = 0;
    valstep = s;
    valn    = width / s;
    
    vals    = new int [valn];
    for(int i=0; i<valn; vals[i++]=0 ) ;
    
    win     = new EZDWindow (name(), title, x, y, w, h);
    draw    = new EZDDrawing(name());
    win->overlay(draw);
    draw_clear();
    win->set_auto_resize(1, draw);
    
    restore_drawing();
}



/*
 * Set the diagram style
 */
void EZDDiagWin::style(EZDDiagWin::Style s)
{
    valstyle = s;
    clear();
}



/*
 * Add a new value to the diagram at the current x position
 */
void EZDDiagWin::draw_value(int x)
{
    if(vals[x] < 0)
    {
	if(x > 0)
	    draw_fill_rectangle((x-1)*valstep, 0,
				2*valstep, height, color_bar);
	else
	    draw_fill_rectangle(x*valstep, 0, valstep, height, color_bar);
    }
    else
	switch(valstyle)
	{
	case HISTO:
	    draw_fill_rectangle(x*valstep, vals[x],
				valstep, height-vals[x], color_draw);
	    break;
	case DOT:
	    draw_point(x*valstep, vals[x], color_draw);
	    break;
	case LINE:
	    if(x>0 && vals[x-1] >= 0)
		draw_line((x-1)*valstep, vals[x-1],
			  x*valstep, vals[x], color_draw);
	    else
		draw_point(x*valstep, vals[x], color_draw);
	    break;
	}
}


void EZDDiagWin::add(int v)
{
    save_drawing();
    set();

    if(v >= 0)
	v = height - v;			// Reverse y axis

    if(valx >= valn)			// Scroll diag to the left
    {
	int step = (int)SCROLL_STEP>valn ? valn : (int)SCROLL_STEP;
	int i;
	
	/* Shift */
	for(i=0; i<valn-step; i++)
	    vals[i] = vals[i+step];
	valx -= step;
	/* Redraw */
	for(i=0; i<valx; i++)
	{
	    draw_fill_rectangle(i*valstep, 0, valstep+1, height, "white");
	    draw_value(i);
	}
	for(; i<width; i++)
	    draw_fill_rectangle(i*valstep, 0, valstep+1, height, "white");
    }

    vals[valx] = v;
    draw_value(valx++);
    
    restore_drawing();
}



/*
 * Set current drawing to diagram window drawing
 */
void EZDDiagWin::set()
{
    draw->set();
}



/*
 * Clear diagram window
 */
void EZDDiagWin::clear()
{
    save_drawing();
    set();

    draw_clear();
    win->set_auto_resize(1, draw);

    valx = 0;
    
    restore_drawing();
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDDiagWin::print(ostream &strm) const
{
    strm << "..." << endl;
}

// Debug output
void EZDDiagWin::dump(ostream &strm) const
{
    strm << "EZDDiagWin { $Revision: 0.22 $ ..."
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDDiagWin
static CNClass EZDDiagWin_desc("EZDDiagWin", "$Revision: 0.22 $",
			       EZDDiagWin::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDDIAGWIN = &EZDDiagWin_desc;
