// -*- C++ -*-

#include <iostream.h>

#include <CNCL/EventScheduler.h>
#include <CNCL/FiboG.h>
#include <CNCL/Uniform.h>

enum { NRUN=1000 };
enum { NEH=100 };
enum { TIME, TEST, NOW, CH };		// CNEvent types

const double DT = 100;


class Test : public CNEventHandler
{
  private:
    int n;		// Count
    CNRandom &rnd;	// Random numbers

  public:
    virtual void event_handler(const CNEvent *ev);

    Test(CNRandom &r) : rnd(r), n(0) {}
};



class CH : public CNEventHandler
{
  private:
    CNRandom &rnd;	// Random

  public:
    virtual void event_handler(const CNEvent *ev);

    CH(CNRandom &r) : rnd(r) {}
};


Test *test[NEH];
CH   *ch;



void Test::event_handler(const CNEvent *ev)
{
//    cout << ev;
    
    switch(ev->type())
    {
    case TIME:
	n++;
	if(n < NRUN)
	    send_delay(new CNEvent(TIME), DT);
	break;
    }
}



void CH::event_handler(const CNEvent *ev)
{
}



main()
{
	CNEvent::set_max_events(200);
	
    CNRNG    *rng = new CNFiboG;
    CNUniform rndt (0,  DT, rng);
    CNUniform rndch(0,  10, rng);

    CNEventScheduler scheduler;

    ch = new CH(rndch);
    
    for(int i=0; i<NEH; i++)
    {
	test[i] = new Test(rndt);
	scheduler.send_event(new CNEvent(TIME, test[i], 0));
    }
    
    scheduler.start();
}
