// -*- C++ -*-

#include <iostream.h>

#include <CNCL/EventList.h>

#include <CNCL/FiboG.h>
#include <CNCL/RndInt.h>



main()
{
    CNEventList list;
    CNEvent *ev;

	CNEvent::set_max_events(250);
	
    // Add
    list.add_event( new CNEvent(0,  10) );
    list.add_event( new CNEvent(0,   5) );
    list.add_event( new CNEvent(0,  20) );
    list.add_event( new CNEvent(0,  15) );
    list.add_event( new CNEvent(0,   5) );

    cout << "-------------------------------------------------" << endl;
    cout << list;

    cout << "-------------------------------------------------" << endl;
    // Peek
    cout << list.peek_event();
    cout << list.peek_event(1);
    cout << list.peek_event(2);
    cout << list.peek_event(4);
    cout << list.peek_event(8);
    cout << endl;
    
    cout << "-------------------------------------------------" << endl;
    // Delete
    list.delete_event(CNEventID(1));
    list.delete_event(CNEventID(3));
    list.delete_event(CNEventID(5));
    
    cout << list;

    list.add_event( new CNEvent(0, 100, 0) );
    list.add_event( new CNEvent(0, 110, 0) );
    list.add_event( new CNEvent(0, 110, 0) );
    list.add_event( new CNEvent(0, 105, 0) );
    list.add_event( new CNEvent(0, 104, 0) );
    list.add_event( new CNEvent(0, 100, 0) );
    list.add_event( new CNEvent(0, 100, 5) );
    list.add_event( new CNEvent(0, 100, 4) );
    list.add_event( new CNEvent(0, 100, 9) );
    list.add_event( new CNEvent(0, 100, 1) );
    list.add_event( new CNEvent(0, 100, 0) );

    cout << "-------------------------------------------------" << endl;
    cout << list;
    
    cout << "-------------------------------------------------" << endl;
    while(ev = list.next_event())
	cout << ev;

    CNRndInt rnd(0, 0, new CNFiboG);
    enum { NEVENTS = 100 };

    for(int i=0; i<NEVENTS; i++)
	list.add_event( new CNEvent(i, rnd(0, 99), rnd(0, 9)) );

    cout << "-------------------------------------------------" << endl;
    while(ev = list.next_event())
	cout << ev;
}
