//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventList.c,v 0.22 1994/07/22 09:21:05 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNEventList --- CNEvent list for scheduler
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include <CNCL/DLIterator.h>

#include "EventList.h"



void CNEventList::add_event(CNEvent *ev)
{
    if(ev_list.empty())
    {
	// Append to list, if list is empty
	ev_list.append(ev);
    }
    else
    {
	// Put into list
	CNEvent *lev;

	// Check special case of appending to list first
	lev = (CNEvent *)( ev_list.last() );
	if(lev == NIL  ||		// Should not happen, but anyway ...
	   lev->ev_scheduled < ev->ev_scheduled  ||
	   (lev->ev_scheduled == ev->ev_scheduled  &&
	    lev->ev_prio      <= ev->ev_prio         ))
	{
	    // New event is the last one in the event list
	    ev_list.append(ev);
	    return;
	}

	CNDLObject *pos;
#if 1
	// Normal forward traversing
	for( pos=ev_list.first(); pos; pos=pos->next() )
	{
	    lev = (CNEvent *)pos;
	    if(lev->ev_scheduled > ev->ev_scheduled ||
	       (lev->ev_scheduled == ev->ev_scheduled &&
		lev->ev_prio      >  ev->ev_prio        ))
		break;
	}
	if(pos)
	    // Insert before current event in list
	    ev_list.insert_before(pos, ev);
	else
	    // Append to list
	    ev_list.append(ev);
#else
	// Traverse event list backwards, in most cases events are rather
	// inserted at the end of the list. Alas, a first test run with a
	// real simulation showed that this is NOT the case. So maybe the
	// best way is to control this from the user program.
	for( pos=ev_list.last(); pos; pos=pos->prev() )
	{
	    lev = (CNEvent *)pos;
	    if(lev->ev_scheduled < ev->ev_scheduled ||
	       (lev->ev_scheduled == ev->ev_scheduled &&
		lev->ev_prio      <=  ev->ev_prio        ))
		break;
	}
	if(pos)
	    // Insert before current event in list
	    ev_list.insert_after(pos, ev);
	else
	    // Append to list
	    ev_list.prepend(ev);
#endif
    }
}



/*
 * Delete event specified with ID
 */
void CNEventList::delete_event(CNEventID id)
{
    CNDLObject *pos;
    
    for( pos=ev_list.first(); pos; pos=pos->next() )
	if( id == ((CNEvent *)pos)->ev_id )
	{
	    ev_list.delete_object(pos);
	    return;
	}
}



/*
 * Delete all events destined to an event handler
 */
void CNEventList::delete_events(CNEventHandler *evh)
{
    CNDLObject *pos, *p;
    
    for( pos=ev_list.first(); pos;  )
    {
	p   = pos;
	pos = pos->next();
	if( evh == ((CNEvent *)p)->ev_to )
	    ev_list.delete_object(p);
    }
}



/*
 * Delete all events
 */
void CNEventList::delete_all()
{
    ev_list.delete_all_w_obj();
}



CNEvent *CNEventList::next_event()
{
    CNDLObject *pos;
    
    pos = ev_list.first();
    if(pos)
	ev_list.remove_object(pos);
    
    return (CNEvent *)pos;
}

	

CNEvent *CNEventList::peek_event()
{
    CNDLObject *pos;
    
    pos = ev_list.first();

    return (CNEvent *)pos;
}

	

CNEvent *CNEventList::peek_event(CNEventID id)
{
    CNDLObject *pos;
    
    for( pos=ev_list.first(); pos; pos=pos->next() )
	if( id == ((CNEvent *)pos)->ev_id )
	    return (CNEvent *)pos;
    
    return NIL;
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNEventList::print(ostream &strm) const
{
    ev_list.print(strm);
}

// Debug output
void CNEventList::dump(ostream &strm) const
{
    strm << "CNEventList { $Revision: 0.22 $" << endl;
    ev_list.dump(strm);
    strm << "}" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNEventList
static CNClass CNEventList_desc("CNEventList", "$Revision: 0.22 $",
			    CNEventList::new_object);

// "Type" for type checking functions
CNClassDesc CN_EVENTLIST = &CNEventList_desc;






