//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventHandler.c,v 0.22 1994/07/22 09:21:05 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNEventHandler --- Abstract base class for event handler
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "EventHandler.h"
#include "EventScheduler.h"



/*
 * Function called from scheduler
 */
void CNEventHandler::process_event(CNEventScheduler *sched,
				   const CNSimTime t, CNEvent *ev)
{
    ev_scheduler = sched;
    ev_now       = t;
    
    event_handler(ev);
}



/*
 * Send event to scheduler, setting event data fields
 */
CNEventID CNEventHandler::send_event(CNEvent *ev)
{
    // Set scheduled time to now, if 0
    // ``0.'' due to G++ bug B-[
    if(ev->scheduled() == 0.)
	ev->scheduled(now());
    // Set recipient to this, if NIL
    if(ev->to() == NIL)
	ev->to(this);
    // Set sender to this, if NIL
    if(ev->from() == NIL)
	ev->from(this);

    scheduler()->send_event(ev);
    
    return ev->id();
}


CNEventID CNEventHandler::send(CNEvent *ev)
{
    return send_event(ev);
}


CNEventID CNEventHandler::send_now(CNEvent *ev)
{
    ev->scheduled(now());
    return send_event(ev);
}


CNEventID CNEventHandler::send_delay(CNEvent *ev, double dt)
{
    ev->scheduled(now() + dt);
    return send_event(ev);
}



/*
 * Delete event by ID
 */
void CNEventHandler::delete_event(CNEventID id)
{
    scheduler()->delete_event(id);
}



/*
 * Delete events addressed to event handler
 */
void CNEventHandler::delete_events(CNEventHandler *evh)
{
    scheduler()->delete_events( evh ? evh : this );
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNEventHandler::print(ostream &strm) const
{
    strm << name() << ": state=" << ev_state << endl;
}

// Debug output
void CNEventHandler::dump(ostream &strm) const
{
    strm << "CNEventHandler { $Revision: 0.22 $  " << name()
         << ": state=" << ev_state
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNEventHandler
static CNClass CNEventHandler_desc("CNEventHandler", "$Revision: 0.22 $", NIL);

// "Type" for type checking functions
CNClassDesc CN_EVENTHANDLER = &CNEventHandler_desc;



