//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Event.c,v 0.22 1994/07/22 09:21:05 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNEvent --- Generic event
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "Event.h"
#include "EventHandler.h"



/*
 * Operator new and delete
 */
CNEvent *CNEvent::pool = NIL;
unsigned long CNEvent::next_free = 0;
unsigned long CNEvent::pool_size = CNEvent::default_max_events;


unsigned long CNEvent::get_max_events()
{
    return pool_size;
}


void CNEvent::set_max_events(unsigned long n)
{
    if(pool != NIL)
	error(NIL, "CNEvent: ", "can't set max. # of events now");
    else
	pool_size = n;
}


void *CNEvent::operator new(size_t s)
{
    /*
     * Initialize pool
     */
    if(pool == NIL)
    {
	pool = ::new CNEvent [pool_size];
	for(unsigned long i=0; i<pool_size; i++)
	    pool[i].ev_id = 0;		// Free
	next_free = 0;
	id_sequencer = 0;		// Reset id numbers
    }

    if(next_free == pool_size)
    {
	/*
	 * No more free events in event pool
	 */
	fatal(NIL, "CNEvent: ", "no more free events");
	/**NOT REACHED**/
	return NIL;
    }
    CNEvent *p = pool + next_free;
    p->ev_id = CNEventID(-1);			// Mark as used
    
    /*
     * Search for next free event and set next_free
     */
    /* Search towards end of pool */
    for(next_free++; next_free<pool_size; next_free++)
	if(pool[next_free].ev_id == 0)
	    break;
    if(next_free == pool_size)
    {
	/* Search from start of pool */
	for(next_free=0; next_free<pool_size; next_free++)
	    if(pool[next_free].ev_id == 0)
		break;
    }
    
    return p;
}


void CNEvent::operator delete(void *p)
{
    CNEvent *ev = (CNEvent *)p;
    
    ev->ev_id = 0;			// Mark as free
}



/*
 * Constructors
 */
CNEventID CNEvent::id_sequencer = 0;


CNEvent::CNEvent()
    : ev_prio(0), ev_type(0), ev_issued(0), ev_scheduled(0),
      ev_to(NIL), ev_from(NIL), ev_obj(NIL)
{
    ev_id = ++id_sequencer;
}


CNEvent::CNEvent(CNParam *param)
    : ev_prio(0), ev_type(0), ev_issued(0), ev_scheduled(0),
      ev_to(NIL), ev_from(NIL), ev_obj(NIL)
{
    ev_id = ++id_sequencer;
}


CNEvent::CNEvent(int new_type)
    : ev_prio(0), ev_type(new_type), ev_issued(0), ev_scheduled(0),
      ev_to(NIL), ev_from(NIL), ev_obj(NIL)
{
    ev_id = ++id_sequencer;
}


CNEvent::CNEvent(int new_type, const CNSimTime t, int new_prio)
    : ev_prio(new_prio), ev_type(new_type), ev_issued(0), ev_scheduled(t),
      ev_to(NIL), ev_from(NIL), ev_obj(NIL)
{
    ev_id = ++id_sequencer;
}


CNEvent::CNEvent(int new_type, CNEventHandler *new_to,
		 const CNSimTime t, CNObject *new_object, int new_prio)
    : ev_prio(new_prio), ev_type(new_type), ev_issued(0), ev_scheduled(t),
      ev_to(new_to), ev_from(NIL), ev_obj(new_object)
{
    ev_id = ++id_sequencer;
}


CNEvent::CNEvent(int new_type, 
		 CNEventHandler *new_from, CNEventHandler *new_to,
		 const CNSimTime t,
		 CNObject *new_object, int new_prio)
    : ev_prio(new_prio), ev_type(new_type), ev_issued(0), ev_scheduled(t),
      ev_to(new_to), ev_from(new_from), ev_obj(new_object)
{
    ev_id = ++id_sequencer;
}


CNEvent::CNEvent(int new_type, CNEventHandler *new_to,
		 CNObject *new_object, int new_prio)
    : ev_prio(new_prio), ev_type(new_type), ev_issued(0), ev_scheduled(0),
      ev_to(new_to), ev_from(NIL), ev_obj(new_object)
{
    ev_id = ++id_sequencer;
}


 
/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNEvent::print(ostream &strm) const
{
    strm << "id=" << ev_id << " prio=" << ev_prio << " type=" << ev_type
	 << " issued=" << double(ev_issued)
	 << " scheduled=" << double(ev_scheduled)
	 << " to=" << hex << (unsigned long)(ev_to) << dec
	 << " from=" << hex << (unsigned long)(ev_from) << dec
	 << " object=" << ev_obj << endl;
}

// Debug output
void CNEvent::dump(ostream &strm) const
{
    strm << "CNEvent { $Revision: 0.22 $" << endl
	 << "id=" << ev_id << " prio=" << ev_prio << " type=" << ev_type
	 << " issued=" << double(ev_issued)
	 << " scheduled=" << double(ev_scheduled) << endl
	 << " to=";
    if(ev_to)
    {
    	cout << endl;
	ev_to->dump(strm);
    }
    else
	strm << "(NIL)" << endl;

    strm << "from=";
    if(ev_from)
    {
    	cout << endl;
	ev_from->dump(strm);
    }
    else
	strm << "(NIL)" << endl;

    strm << "object=";
    if(ev_obj)
    {
    	cout << endl;
	ev_obj->dump(strm);
    }
    else
	strm << "(NIL)" << endl;
    strm << "}" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNEvent
static CNClass CNEvent_desc("CNEvent", "$Revision: 0.22 $",
			    CNEvent::new_object);

// "Type" for type checking functions
CNClassDesc CN_EVENT = &CNEvent_desc;






