//-*-c++-*-

#include <CNCL/ArrayInt.h>
#include <CNCL/ArrayChar.h>
#include <CNCL/ArrayFloat.h>
#include <CNCL/ArrayDouble.h>
#include <CNCL/ArrayLong.h>
#include <CNCL/ArrayObject.h>

#include <math.h>

void int_to_str(int, char*);
int str_to_int(char*);
void test_CNarray(char *);
void test_object();
int size = 5, next_size = 10, number_values = 0; 
int default_v = 0;

class Int2 : public CNObject
{
public:
    
    Int2() {i1 = i2 = 0;}
    void put(int value1, int value2);
    virtual void dump (ostream &strm = cout) const;
    virtual void print (ostream &strm = cout) const;

private:
     int i1, i2;
};

void Int2::put(int value1, int value2)
{
   i1 = value1; i2 = value2;
}

void Int2::print(ostream &strm) const
{
    strm << "(" << i1 << "," << i2 <<")";
}

void Int2::dump(ostream &strm) const
{
    strm << "Int2 { $Revision$ ";
    strm << "(" << i1 << "," << i2 <<")";
	strm << " }" << endl;
}


main(int argc, char *argv[])
{
   if (argc > 1)
   {
      for (int i = 2; i < argc-1; i++)
      {
         if (!strcmp(argv[i],"-s"))
            size = str_to_int(argv[i+1]);
         else if (!strcmp(argv[i],"-ns"))
            next_size = str_to_int(argv[i+1]);
         else if (!strcmp(argv[i],"-v"))
            number_values = str_to_int(argv[i+1]);
         else if (!strcmp(argv[i],"-d"))
            default_v = str_to_int(argv[i+1]);
         else
            CNCL::fatal(NIL,"Wrong option!\n");
         i++;
      }
      cout << "Size: " << size << endl;
      cout << "Next Size: " << next_size << endl;
      cout << "Number Values: " << number_values << endl;
      cout << "Default Value: " << default_v << "\n\n";
      test_CNarray(argv[1]);
   }
   else
      cerr << "Usage: tArray <type> [-s size] [-ns next_size] [-d default_value] [-v number_values]\n";
}

void test_CNarray(char *arg)
{
int i, j = 0;

    if (!strcmp(arg,"char"))   // Test CNArrayChar
    {
       CNArrayChar c(size, default_v);
       cout << "CNArray c : "<< c <<endl<< "Put values to array\n";
       for (i = 0; i < size; i++) c[i] = (char) i+49;
       cout << "CNArray c : "<< c <<endl<< "Set size to "<< next_size <<"\n";
       c.set_size(next_size);
       for (i = size; i < next_size; i++)
          if (j < number_values)
          {
             cout << "Type " << arg <<"!: \n";
             cin >> c[i] ; j++;
          }
          else
             c[i] = i+49;
       cout << "CNArray c : "<< c <<endl;
    }
    else if (!strcmp(arg,"int"))   // Test CNArrayInt
    {
       CNArrayInt k(size, default_v);
       cout << "CNArray k : "<< k <<endl<< "Put values to array\n";
       for (i = 0; i < size; i++) k[i] = i+2;
       cout << "CNArray k : "<< k <<endl<< "Set size to "<< next_size <<"\n";
       k.set_size(next_size);
       for (i = size; i < next_size; i++)
          if (j < number_values)
          {
             cout << "Type " << arg <<"!: \n";
             cin >> k[i] ; j++;
          }
          else
             k[i] = i+2;
       cout << "CNArray k :  "<< k <<endl;
    }
    else if (!strcmp(arg,"float"))   // Test CNArrayFloat
    {
       CNArrayFloat f(size, default_v);
       cout << "CNArray f :  "<< f <<endl<< "Put values to array\n";
       for (i = 0; i < size; i++) f[i] = i*0.534;
       cout << "CNArray f : "<< f <<endl<< "Set size to "<< next_size <<"\n";
       f.set_size(next_size);
       for (i = size; i < next_size; i++)
          if (j < number_values)
          {
             cout << "Type " << arg <<"!: \n";
             cin >> f[i] ; j++;
          }
          else
             f[i] = i*0.534;
       cout << "CNArray f :  "<< f <<endl;
    }
    else if (!strcmp(arg,"long"))   // Test CNArrayLong
    {
       CNArrayLong l(size, default_v);
       cout << "CNArray l :  "<< l <<endl<< "Put values to array\n";
       for (i = 0; i < size; i++) l[i] = i+1234567;
       cout << "CNArray l : "<< l <<endl<< "Set size to "<< next_size <<"\n";
       l.set_size(next_size);
       for (i = size; i < next_size; i++)
          if (j < number_values)
          {
             cout << "Type " << arg <<"!: \n";
             cin >> l[i] ; j++;
          }
          else
             l[i] = i+1234567;
       cout << "CNArray l :  "<< l <<endl;
    }
    else if (!strcmp(arg,"double"))   // Test CNArrayDouble
    {
       CNArrayDouble d(size, default_v);
       cout << "CNArray d :  "<< d <<endl<< "Put values to array\n";
       for (i = 0; i < size; i++) d[i] = (pow(3.4E3,-i))*2;
       cout << "CNArray d : "<< d <<endl<< "Set size to "<< next_size <<"\n";
       d.set_size(next_size);
       for (i = size; i < next_size; i++)
          if (j < number_values)
          {
             cout << "Type " << arg <<"!: \n";
             cin >> d[i] ; j++;
          }
          else
             d[i] = d[i]*2;
       cout << "CNArray d :  "<< d <<endl;
    }
    else if (!strcmp(arg,"CNObject"))   // Test CNArrayCNObject
       test_object();
    else if (!strcmp(arg,"all"))      // Test all CNArray
    {
       test_CNarray("char");
       test_CNarray("int");
       test_CNarray("long");
       test_CNarray("float");
       test_CNarray("double");
       test_CNarray("CNObject");
    }
    else
       CNCL::fatal(NIL,"Wrong paramter type!\n");
           
}


void test_object()
{
    CNArrayObject o(size);
    int i;
    Int2 ii[size];
    
    for (i = 0; i < size; i++)
    {
       ii[i].put(i, i+1);
       o[i] = &ii[i];
    }
         
    cout << "CNArray CNobject :  "<< o <<endl;
    cout << "Set size to "<< next_size <<"\n";
    o.set_size(next_size);
    Int2 ii_neu;
    if (next_size > size)
    {
       ii_neu.put(4711, 4711+1);
       o[next_size-1] = &ii_neu;
    }
    cout << "CNArray CNobject :  "<< o <<endl;
    
}

int str_to_int(char* string)
{
   int sign = 1, wert = 0;
   if ((*string == '+') || (*string == '-'))
   {
      if (*string == '-') sign = -1;
      string++;
   }
   while ((*string >= '0') && (*string <= '9'))
   {
      wert *= 10;
      wert+=(*string - '0');
      string++;
   }
   return (sign * wert);
}

void int_to_str(int wert, char* string)
{
   int ziffer;
   char hilf[100], *p, *anfang;
   p = &hilf[0];
   anfang = p;
   if (wert < 0)
   { 
      wert = -wert;
      *string++ = '-';
   }
   if (!wert)
   {
      *string++ = '0';
      *string = 0;
      return;
   }
   while (wert)
   {
      ziffer = wert % 10;
      wert /= 10;
      *p++ = ziffer + '0';
   }
   while (p != anfang) *string++ = *--p;   // reverse
   *string = 0;
   return;
}
