//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * Class: CNArrayObject  --- CNObjPtr array class
 *
 * Created from
 * $Id: T_array.cP,v 0.22 1994/07/22 09:21:11 cncl-adm Exp cncl-adm $
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "ArrayObject.h"



/***** Private functions *****************************************************/

void CNArrayObject::init(int sz)
{
    asize = sz;
    array = new CNObjPtr[sz];
    for (int i = 0; i < sz; i++)
	array[i] = def_val;
}



void CNArrayObject::delete_array()
{
    asize = 0;
    if(array)
	delete [] array;
    array = NIL;
}



/***** Constructors **********************************************************/

CNArrayObject::CNArrayObject(int sz, CNObjPtr def)
{
    if (sz<0)
	fatal(NIL, "CNArrayObject: ", "invalid size < 0");
    
    def_val = def;
    init(sz);
}



CNArrayObject::CNArrayObject(const CNArrayObject &a)
{
    init(a.asize);
    for (int i = 0; i < asize; i++)
	array[i] = a.array[i];
}


CNArrayObject::~CNArrayObject()
{
    CNArrayObject::delete_array();
}



CNArrayObject &CNArrayObject::operator = (const CNArrayObject &a)
{
    delete_array();
    init(a.asize);
    for (int i = 0; i < asize; i++)
	array[i] = a.array[i];
    return *this;
}
    


/***** public functions ******************************************************/

void CNArrayObject::size(int sz)  // Set size of array
{
    if (sz<0)
	fatal(NIL, "CNArrayObject: ", "invalid size < 0");

    if (array == NIL)
	init(sz);
    else if (sz != asize)
    {
	CNObjPtr *temp = array;
	array = new CNObjPtr[sz];
	for (int i = 0; i < sz; i++)
	    if (i < asize)
		array[i] = temp[i];
	    else
		array[i] = def_val;
	delete[] temp;
	asize = sz;
    }
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNArrayObject::print(ostream &strm) const
{
    strm << "[ ";
    for(int i=0; i<asize; i++)
    {
	strm << array[i];
	if(i != asize-1)
	    strm << ", ";
    }
    strm << " ]";
}

// Debug output
void CNArrayObject::dump(ostream &strm) const
{
    strm << "CNArrayObject { $Revision: 0.22 $" << endl;
    strm << "size=" << asize
	 << " array=" << hex << (unsigned long)(array) << dec << endl;
    strm << "values=" << this << endl;
    strm << "}" << endl;
}



/***** CNCL stuff for type ***************************************************/

// Describing object for class CNArrayObject
static CNClass CNArrayObject_desc("CNArrayObject", "$Revision: 0.22 $",
			    CNArrayObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_ARRAYOBJECT = &CNArrayObject_desc;
