//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLEnvironment.h,v 0.22 1994/07/22 09:21:42 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLEnvironment --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNSDLEnvironment_h
#define __CNSDLEnvironment_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/SDLManager.h>		// Base class
#include <CNCL/SDLProcess.h>


extern CNClassDesc CN_SDLENVIRONMENT;	// Class CNSDLEnvironment description


/*
 * The class CNSDLEnvironment
 */

class CNSDLEnvironment : public CNSDLManager
{
  public:       /***** Constructors ******************************************/
    CNSDLEnvironment() {};                      // Default constructor
    CNSDLEnvironment(CNParam *param) {}         // CNParam constructor
    CNSDLEnvironment(int, CNSDLProcess*, CNEventScheduler*);

  public:       /***** Public interface **************************************/
    
    static CNSDLProcessData *pointer_to_environment_data;
                                                // to use in SDL systems

    // send signals in block (explicit, implicit, via signalroute)
    void output_x(SignalType, PId, CNObject* = NIL);          
    void output(SignalType, CNObject* = NIL);                 
    void output(SignalType, ProcessType, CNObject* = NIL);
    
    // channel output (modified!)
    void output_x(SignalType, PId, CNSDLChannel*, 
                                   CNObject* = NIL, int target_system = 0);
    void output(SignalType, ProcessType, CNSDLChannel*, 
                                   CNObject* = NIL, int target_system = 0);

    // connect  SDLSystems with Environment
    void install(int, CNSDLManager*);
    
    CNSDLManager *S(int);    // allows use of SDLSystem memberfunction
    
  private:      /***** Internal private members ******************************/
    
    CNSDLManager **SDLSystem;  // array of SDL systems
    int sys_no;                // number of SDL systems
    
    CNSDLProcessData *processes[2]; // contains environment process
    
  public:       /***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_SDLENVIRONMENT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_SDLENVIRONMENT ? TRUE : CNSDLManager::is_a(desc); }
        
    static CNSDLEnvironment *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNSDLEnvironment *)obj;
#   else
	return (CNSDLEnvironment *)( !obj || obj->is_a(CN_SDLENVIRONMENT)
	       ? obj : fatal_type(obj->class_desc(), CN_SDLENVIRONMENT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNSDLEnvironment(param) : new CNSDLEnvironment; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


// inline functions

// this makes memberfunctions of other Systems (like channel) accessible
// for the SDLProcess_Environment
inline CNSDLManager *CNSDLEnvironment::S(int sys_no)
{
    return SDLSystem[sys_no];
}

#endif /**__CNSDLEnvironment_h**/
