//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ICoord.h,v 0.22 1994/07/22 09:20:58 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNICoord --- 2-dim integer coordinates
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __ICoord_h
#define __ICoord_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_ICOORD;	// CNClass CNICoord description



class CNCoord;



/*
 * The class CNICoord
 */

class CNICoord : public CNObject
{
public:
    int x, y;

    CNICoord &operator += (const CNICoord &v);
    CNICoord &operator -= (const CNICoord &v);

    static double set_scale(double new_scale);
    static double get_scale();

    /***** Constructors ******************************************************/
public:
    CNICoord();
    CNICoord(CNParam *param);
    CNICoord(int vx, int vy);
    CNICoord(const CNICoord &v);
    CNICoord(const CNCoord &v);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_ICOORD;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_ICOORD ? TRUE : CNObject::is_a(desc);
    };
        
    static CNICoord *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNICoord *)obj;
#   else
	return (CNICoord *)( !obj || obj->is_a(CN_ICOORD)
	       ? obj : fatal_type(obj->class_desc(), CN_ICOORD) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNICoord(param) : new CNICoord; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



CNICoord operator + (const CNICoord &a, const CNICoord &b);
CNICoord operator - (const CNICoord &a, const CNICoord &b);


#endif /**__ICoord_h**/
