//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ColorfulObject.h,v 0.22 1994/07/22 09:21:52 cncl-adm Exp cncl-adm $
 *
 * Class: ColorfulObject --- replacement for GIST1 ColorfulObject
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __ColorfulObject_h
#define __ColorfulObject_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/MovingObject.h>		// Base class

extern CNClassDesc CN_COLORFULOBJECT;	// Class ColorfulObject description


/*
 * The class ColorfulObject
 */

class ColorfulObject : public MovingObject
{
  public:	/***** Constructors ******************************************/
    ColorfulObject(World& w,
		   const char *picname, 
		   const char *color,
		   float x, float y, 
		   float width = 0.0, float height = 0.0,
		   double time = 0.0);
    ColorfulObject(World& w,
		   const char *picname, 
		   float red, float green, float blue,
		   float x, float y, 
		   float width = 0.0, float height = 0.0,
		   double time = 0.0);
    ColorfulObject(World& w,
		   const char *objectname,
		   const char *picname, 
		   const char *color,
		   float x, float y, 
		   float width = 0.0, float height = 0.0,
		   double time = 0.0);
    ColorfulObject(World& w,
		   const char *objectname,
		   const char *picname, 
		   float red, float green, float blue,
		   float x, float y, 
		   float width = 0.0, float height = 0.0,
		   double time = 0.0);
    
  public:	/***** Public interface **************************************/
    virtual void move(float x, float y, double time);
    virtual void change_look(const char *picname);
    virtual void change_color(const char *color);
    virtual void change_color(float red, float green, float blue);
    
  private:	/***** Internal private members ******************************/
    friend class TextObject;
    friend class ValueObject;
    friend class DiagObject;
    ColorfulObject(World&,const char*);

    double lasttime;
    GISTPicture *pic;
    GISTCoordAttribute *pos;
    GISTTextAttribute *img;
    GISTTextAttribute *col;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_COLORFULOBJECT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_COLORFULOBJECT ? TRUE : MovingObject::is_a(desc); }
        
    static ColorfulObject *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (ColorfulObject *)obj;
#   else
	return (ColorfulObject *)( !obj || obj->is_a(CN_COLORFULOBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_COLORFULOBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return NIL; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__ColorfulObject_h**/
