//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Class.h,v 0.22 1994/07/22 09:22:03 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNClass --- CNClass description class
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Class_h
#define __Class_h


#include <CNCL/Object.h>


class CNClass;
class CNParam;


/*
 * Type description for class CNClass
 */

extern CNClassDesc CN_CLASS;



/*
 * CNClass CNClass:
 *   Description of classes and creating of new objects via exemplar objects
 */

class CNClass : public CNObject
{
private:
    const char *c_name;			// CNClass name
    const char *c_version;		// CNClass version
    CNObject *(*c_func)(CNParam *param);	// CLASS::new_object() function
    
public:
    // Constructor
    CNClass(char *new_name, char *new_version,
	  CNObject *(*new_func)(CNParam *param))
	: c_name(new_name), c_version(new_version), c_func(new_func) {}
    
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_CLASS; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_CLASS ? TRUE : CNObject::is_a(desc); }
        
    static CNClass *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNClass *)obj;
#   else
	return (CNClass *)( !obj || obj->is_a(CN_CLASS)
	       ? obj : fatal_type(obj->class_desc(), CN_CLASS) );
#   endif
    }


    // Get name and version
    const char *name() const
    {
	return c_name;
    }
    const char *version() const
    {
	return c_version;
    }
    const char *get_name() const
    {
	return c_name;
    }
    const char *get_version() const
    {
	return c_version;
    }
    
    // Create object via CLASS::new_object() function
    CNObject *new_object(CNParam *param = NIL) const;
    CNObject *new_object(CNParam &param) const;

    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__Class_h**/
