%{
   /* Lexikalische Analyse SDL/PR */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "ParserSDL88.tab.h"
int linenumber = 0;


%}

begrenzer            [ \t]+
buchst_              [A-Za-z_]
ziffer               [0-9]
name                 {buchst_}({buchst_}|{ziffer})*
zahl                 {ziffer}+(\.{ziffer}+)((E|e)[+-]?{ziffer}+)?

 
%%
\n                                   {++linenumber;printf("   [%d] \r",linenumber);}   
"/*#include".*"*/"                   {yylval.text_val = "CHLbyte.h";
                                      return(COMMENTINC);}
"/*".*"*/"                           ;                                     
"'".*"'"                             {yylval.text_val = strdup(yytext);
                                      return(CHRISSY);}
{begrenzer}                          ;

[aA][cC][tT][iI][vV][eE]                                      return(ACTIVE);
[aA][dD][dD][iI][nN][gG]                                      return(ADDING);
[aA][lL][lL]                                                  return(ALL);
[aA][lL][tT][eE][rR][nN][aA][tT][iI][vV][eE]                  return(ALTERNATIVE);
[aA][xX][iI][oO][mM][sS]                                      return(AXIOMS);
[eE][nN][vV]                                                  return(ENV);
[cC][aA][lL][lL]                                              return(CALL);
[cC][oO][mM][mM][eE][nN][tT]                                  return(COMMENT);
[cC][oO][nN][sS][tT][aA][nN][tT]                              return(CONSTANT);
[cC][oO][nN][sS][tT][aA][nN][tT][sS]                          return(CONSTANTS);
[cC][rR][eE][aA][tT][eE]                                      return(CREATE);
[dD][cC][lL]                                                  return(DCL);
[dD][eE][cC][iI][sS][iI][oO][nN]                              return(DECISION);
[dD][eE][fF][aA][uU][lL][tT]                                  return(DEFAULT);
[eE][lL][sS][eE]                                              return(ELSE);
[eE][nN][dD][aA][lL][tT][eE][rR][nN][aA][tT][iI][vV][eE]      return(ENDALTERNATIVE);
[eE][nN][dD][dD][eE][cC][iI][sS][iI][oO][nN]                  return(ENDDECISION);
[eE][nN][dD][gG][eE][nN][eE][rR][aA][tT][oO][rR]              return(ENDGENERATOR);
[eE][nN][dD][nN][eE][wW][tT][yY][pP][eE]                      return(ENDNEWTYPE);
[aA][nN][dD]                                                  return(AND);
[bB][lL][oO][cC][kK]                                          return(BLOCK);
[cC][hH][aA][nN][nN][eE][lL]                                  return(CHANNEL);
[cC][oO][nN][nN][eE][cC][tT]                                  return(CONNECT);
[eE][nN][dD][bB][lL][oO][cC][kK]                              return(ENDBLOCK);
[eE][nN][dD][cC][hH][aA][nN][nN][eE][lL]                      return(ENDCHANNEL);
[eE][nN][dD][pP][rR][oO][cC][eE][sS][sS]                      return(ENDPROCESS);
[eE][nN][dD][sS][yY][sS][tT][eE][mM]                          return(ENDSYSTEM);
[fF][rR][oO][mM]                                              return(FROM);
[iI][nN][pP][uU][tT]                                          return(INPUT);
[nN][eE][xX][tT][sS][tT][aA][tT][eE]                          return(NEXTSTATE);
[oO][uU][tT][pP][uU][tT]                                      return(OUTPUT);
[pP][rR][oO][cC][eE][sS][sS]                                  return(PROCESS);
[rR][eE][fF][eE][rR][eE][nN][cC][eE][dD]                      return(REFERENCED);
[sS][iI][gG][nN][aA][lL]                                      return(SIGNAL);
[sS][iI][gG][nN][aA][lL][rR][oO][uU][tT][eE]                  return(SIGNALROUTE);
[sS][tT][aA][rR][tT]                                          return(START);
[sS][tT][oO][pP]                                              return(STOP);
[sS][yY][sS][tT][eE][mM]                                      return(SYSTEM);
[tT][oO]                                                      return(TO);      
[vV][iI][aA]                                                  return(VIA);
[wW][iI][tT][hH]                                              return(WITH);
[pP][rR][oO][cC][eE][dD][uU][rR][eE]                          return(PROCEDURE);
[eE][nN][dD][pP][rR][oO][cC][eE][dD][uU][rR][eE]              return(ENDPROCEDURE);
[rR][eE][tT][uU][rR][nN]                                      return(RETURN);
[sS][tT][aA][tT][eE]                                          return(STATE);
[eE][nN][dD][rR][eE][fF][iI][nN][eE][mM][eE][nN][tT]          return(ENDREFINEMENT);
[eE][nN][dD][sS][eE][lL][eE][cC][tT]                          return(ENDSELECT);
[eE][nN][dD][sS][eE][rR][vV][iI][cC][eE]                      return(ENDSERVICE);
[eE][nN][dD][sS][tT][aA][tT][eE]                              return(ENDSTATE);
[eE][nN][dD][sS][uU][bB][sS][tT][rR][uU][cC][tT][uU][rR][eE]  return(ENDSUBSTRUCTURE);
[eE][nN][dD][sS][yY][nN][tT][yY][pP][eE]                      return(ENDSYNTYPE);
[eE][rR][rR][oO][rR]                                          return(ERROR);
[eE][xX][pP][oO][rR][tT]                                      return(EXPORT);
[eE][xX][tT][eE][rR][nN][aA][lL]                              return(EXTERNAL);
[fF][iI]                                                      return(FI);
[fF][oO][rR]                                                  return(FOR);
[fF][pP][aA][rR]                                              return(FPAR);
[gG][eE][nN][eE][rR][aA][tT][oO][rR]                          return(GENERATOR);
[iI][fF]                                                      return(IF);
[iI][mM][pP][oO][rR][tT]                                      return(IMPORT);
[iI][nN]                                                      return(IN);
[iI][nN][hH][eE][rR][iI][tT][sS]                              return(INHERITS);
[jJ][oO][iI][nN]                                              return(JOIN);
[lL][iI][tT][eE][rR][aA][lL]                                  return(LITERAL);
[lL][iI][tT][eE][rR][aA][lL][sS]                              return(LITERALS);
[mM][aA][pP]                                                  return(MAP);
[mM][oO][dD]                                                  return(MOD);
[nN][aA][mM][eE][cC][lL][aA][sS][sS]                          return(NAMECLASS);
[nN][eE][wW][tT][yY][pP][eE]                                  return(NEWTYPE);
[nN][oO][tT]                                                  return(NOT);
[nN][oO][wW]                                                  return(NOW);
[oO][fF][fF][sS][pP][rR][iI][nN][gG]                          return(OFFSPRING);
[oO][pP][eE][rR][aA][tT][oO][rR]                              return(OPERATOR);
[oO][pP][eE][rR][aA][tT][oO][rR][sS]                          return(OPERATORS);
[oO][rR]                                                      return(OR);
[oO][rR][dD][eE][rR][iI][nN][gG]                              return(ORDERING);
[oO][uU][tT]                                                  return(OUT);
[pP][aA][rR][eE][nN][tT]                                      return(PARENT);
[pP][rR][iI][oO][rR][iI][tT][yY]                              return(PRIORITY);
[pP][rR][oO][vV][iI][dD][eE][dD]                              return(PROVIDED);
[rR][eE][fF][iI][nN][eE][mM][eE][nN][tT]                      return(REFINEMENT);
[rR][eE][mM]                                                  return(REM);
[rR][eE][sS][eE][tT]                                          return(RESET);
[rR][eE][vV][eE][aA][lL][eE][dD]                              return(REVEALED);
[rR][eE][vV][eE][rR][sS][eE]                                  return(REVERSE);
[sS][aA][vV][eE]                                              return(SAVE);
[sS][eE][lL][eE][cC][tT]                                      return(SELECT);
[sS][eE][lL][fF]                                              return(SELF);
[sS][eE][nN][dD][eE][rR]                                      return(SENDER);
[sS][eE][rR][vV][iI][cC][eE]                                  return(SERVICE);
[sS][eE][tT]                                                  return(SET);
[sS][iI][gG][nN][aA][lL][lL][iI][sS][tT]                      return(SIGNALLIST);
[sS][iI][gG][nN][aA][lL][sS][eE][tT]                          return(SIGNALSET);
[sS][pP][eE][lL][lL][iI][nN][gG]                              return(SPELLING);
[sS][tT][rR][uU][cC][tT]                                      return(STRUCT);
[sS][uU][bB][sS][tT][rR][uU][cC][tT][uU][rR][eE]              return(SUBSTRUCTURE);
[sS][yY][nN][oO][nN][yY][mM]                                  return(SYNONYM);
[sS][yY][nN][tT][yY][pP][eE]                                  return(SYNTYPE);
[tT][aA][sS][kK]                                              return(TASK);
[tT][hH][eE][nN]                                              return(THEN);
[tT][yY][pP][eE]                                              return(TYPE);
[tT][iI][mM][eE][rR]                                          return(TIMER);
[vV][iI][eE][dD]                                              return(VIEW);
[vV][iI][eE][dD][eE][dD]                                      return(VIEWED);
[xX][oO][rR]                                                  return(XOR);


[iI][nN][tT][eE][gG][eE][rR]              {yylval.text_val = "int"; return(TYPEDEFI);}
[bB][oO][oO][lL][eE][aA][nN]              {yylval.text_val = "bool"; return(TYPEDEFI);} 
[cC][hH][aA][rR][aA][cC][tT][eE][rR]      {yylval.text_val = "char"; return(TYPEDEFI);} 
[cC][hH][aA][rR][sS][tT][rR][iI][nN][gG]  {yylval.text_val = "char[]"; return(TYPEDEFI);} 
[nN][aA][tT][uU][rR][aA][lL]              {yylval.text_val = "unsigned int"; return(TYPEDEFI);} 
[rR][eE][aA][lL]                          {yylval.text_val = "double"; return(TYPEDEFI);} 
[pP][iI][dD]                              {yylval.text_val = "PId"; return(TYPEDEFI);} 
[dD][uU][rR][aA][tT][iI][oO][nN]          {yylval.text_val = "double"; return(TYPEDEFI);} 
[tT][iI][mM][eE]                          {yylval.text_val = "CNSimTime"; return(TYPEDEFI);} 


[bB][yY][tT][eE]                          {yylval.text_val = "unsigned char";return(TYPEDEFI);}

"BAND"          {yylval.text_val = "BITWISE_AND_BYTES";return(ABSTRDATATYPE);}
"BHEX"          {yylval.text_val = "BHEX";return(ABSTRDATATYPE);}


[nN][uU][lL][lL]    {yylval.text_val = "NIL"; return(NAME);}
{name}              {yylval.text_val = strdup(yytext); return(NAME);}

{ziffer}+         {yylval.num_val = strdup(yytext);return(NUMBER);}

","            return(COMMA);
";"            return(SEMICOLON);
"("            return(LEFTPAR);
")"            return(RIGHTPAR);
"/="           return(NE);
">"            return(GT);
"<"            return(LT);
">="           return(GE);
"<="           return(LE);
"+"            return(PLUS);
"-"            return(MINUS);
"//"           return(CONC);
"==>"          return(AXIOMIMPLY);
"=="           return(AXIOMEQUAL);
"=>"           return(IMPLY);
":="           return(ASSIGN);
"*"            return(ASTERISK);
":"            return(COLON);
"/"            return(SLASH);
"="            return(EQUAL);
"!"            return(EXCLAMATION);
"(."           return(LEFTPARPOINT);
".)"           return(RIGHTPARPOINT);
"->"           return(ARROW);



%%
                                                                  
