%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define TRUE 1
#define FALSE 0

/*---------------- Variablen-Deklarationen ------------------------------*/

FILE *Timerpointer,*Connectpointer,*Typedefipointer,*Chanpointer,
     *Signalpointer,*Processpointer,*Systempointer,*SystemCpointer,
     *ProcessCpointer,*StateCpointer,*TypedefiPpointer,*ProcessTypepointer,
     *Makefilepointer;

int firsttimer,           /* Flag fuer ersten Eintrag in Timerliste      */
    includeflag,          /* Flag fuer Existenz einer ADT-Datei          */
    notfound,             /* Flag fuer bereits eingtragenes Signal       */
    systemflag,           /* Flag fuer Systemebene                       */
    Firstblock,           /* Flag fuer ersten Eintrag in Blockliste      */
    Firstsignroute,       /*              --- " ---                      */
    Firstprocess,
    Firstchannel,
    Firstglobalsignal,
    Firstabstract,
    Firstlocalsignroute,
    Firstprocess2,
    chan,                 /* Flag; Differenzierung Channel - Signalroute */
    signroute,            /* Flag; Differenzierung Signalroute - Channel */
    blockfound,           /* Flag fuer bereits eingtragenen Block        */
    bidirect,             /* Flag fuer bidirekten Kananal                */
    envflagfirst,         /* Flag fuer Signal vom environment            */
    envflagsecond,        /* Flag fuer Signal zum environment            */
    envflag,              /* Flag fuer Signal vom/zum environment        */
    signallst,            /* Flag fuer Signallist                        */
    connect,              /* Flag fuer Channel-Signalroute-Verknuepfung  */
    varflag,              /* Flag fuer Variablendeklaration              */
    taskflag,             /* Flag fuer Task-Symbol                       */
    stateflag,            /* Flag fuer augenblicklichen Zustand          */
    number_of_channels,   /* Anzahl der Kanaele                          */
    number_of_processes,  /*                    --- " ---                */
    number_of_signals,
    everystate,           /* Flag fuer *-Zustand                         */
    everyexist,           /* Flag fuer Existenz eines *-Zustandes        */
    initflag,             /* Flag fuer Start-Symbol                      */
    indexnumber,          /* Prozesstypenummer                           */
    prcsmaxhelp,          /* Zwischenspeicher fuer max. Prozesstypanzahl */
    systemnumber,         /* Systemnummer                                */
    processall,           /* max. Processanzahl (Identifikationsnummer)  */
    processflag,          /* Flag fuer Prozessebene                      */
    descflag,             /* Flag fuer Decision-Symbol                   */
    rangeflag,
    contindex,            /* Nummer fuer Helpcontainer                   */
    atbegin;              /* Anzahl der zu Beginn exsistierenden Prozes. */

char *chanhelp,*structname,*testvar,*chanhelpname,*routehelpname,
     *starthelproute,*endhelproute,*starthelpblock,*endhelpblock,
     *starthelpprocess,*endhelpprocess,*systemname,*aktstatename,
     chanhelpnamebi[80],chh,
     helpcontainer[10][100], /* Array fuer Decision-Ausdruecke */
     *headerdatei,*dummy;

/*------------------------- Typendeklarationen --------------------------*/

typedef struct abstract
  {
      char *name;
      struct abstract *next;
  }abstractlist;

typedef struct block
  {
      char *name;
      int Firstprocess;
      int Firstlocalsignal;
      struct process *prsslstbegin;
      struct localsignal *loclstbegin;
      struct signalroute *pointer;
      struct block *next;
  }blocklist;


typedef struct signalroute
  { 
      char *name;
      struct process *processpoint;
      struct channel *connectpoint;
      struct signalroute *next;
  }signroutelist,localsignroutelist;

typedef struct channel
  {
      char *name;
      char biname[40];
      struct block *startblock;
      struct block *endblock;     
      struct signalroute *startroute;
      struct signalroute *endroute;
      int Firstsignroute;  
      struct channel *next;
   }channellist;

typedef struct process
  {
      char *name;
      int processtype;
      int processPId;
      int processmaxnumber;
      int atbeginnumber;
      int Firstvariable;
      int Firsttimer;
      int Firstprocedure;
      int Firststate;
      int Firstcreate;
      int EveryStateExist;
      char *saveexist;
      char *timerexist;
      struct createname *createlistbegin;
      struct state *statelistbegin;
      struct process *next;
      struct procedure *prcdlstbegin;
      struct variable *varlstbegin;
      struct timer *timerlstbegin;
  }processlist2,processlist;

typedef struct createname
  {
      char *name;
      struct createname *next;
  }createlist;
    
typedef struct procedure
  {
      char *name;
      int Firstvariable;
      struct procedure *next;
      struct variable *varlstbegin;
  }procedurelist;

typedef struct localsignal
  {
      char *name;
      struct process *startprocess;
      struct process *endprocess;
      struct signalroute *routepoint;
      struct localsignal *next;
  }localsignallist;


typedef struct variable
  {
      char *name;
      char *vartype;
      struct variable *next;
  }variablelist;

typedef struct state
  {
      char *name;
      struct state *next;
  }statelist; 

typedef struct timer
  {
      char *name;
      struct timer *next;
   }timerlist;

typedef struct globalsignal
  {
      char *name;
      struct block *startblock;
      struct block *endblock;
      struct channel *chanpoint;
      struct signalroute *startroute;
      struct signalroute *endroute;
      struct globalsignal *next;
  }globalsignallist;

/*---------------------------Pointerdeklarationen ------------------- ---*/

globalsignallist *globalsignallistbegin,*globalsignalAKT,
                 *globalsignaljustnew,*searchpointer;
blocklist *blocklistbegin,*blockAKT;
channellist *channellistbegin,*channelAKT,*channeljustnew;
processlist *processlistbegin,*processAKT,*prsshelp;
signroutelist *signroutelistbegin,*signrouteAKT;
localsignroutelist *localsignroutelistbegin,*localsignrouteAKT;
localsignallist *locAKT;
processlist2 *processlistbegin2,*process2AKT;
timerlist *timerAKT,*timerhelp;
statelist *stateAKT;
abstractlist *abstractlistbegin;
variablelist *varhelp;
procedurelist *prcdhelp;

/*----------------------Prozedurdeklarationen ---------------------------*/

void AbstractEntry();      /* Listeneintrag: ADT                         */
void FileMake();           /* Erstellen der Datei Makefile               */
void FilePType();          /* Erstellen der Datei SDLProcess_..._Types.h */
void FileProcessType();    /* Erstellen der Datei ..._ProcessTypes.h     */
void FilePTypeEnd();       /* Erstellen des Dateiendes SDLPro...Types.h  */
void FileTimer();          /* Erstellen der Datei SDLSystem...Timer.h    */
void FileRemove();         /* Loeschen der temporaeren Dateien           */
void TempState();          /* Erstellen der temporaeren Zustandsdateien  */
void TempInit();           /* Erstellen der temporaeren Startdatei       */
void FileType();           /* Erstellen der Datei SDLSyst...Types.h      */
void FileTypeEnd();        /* Erstellen des Dateiendes --- " ---         */
void FileSignal();         /* Erstellen der Datei SDLSyst...Signals.h    */
void FileChannel();        /* Erstellen der Datei SDLSyst...Channels.h   */
void TimerEntry();         /* Listeneintrag: Timer                       */
void StateEntry();         /* Listeneintrag: Zustand                     */
int TimerExist();          /* Nachweis eines Timer-Eintrags              */
void FileProcessH();       /* Erstellen der Datei SDLProc..h             */
void BlockEntry();         /* Listeneintrag: Block                       */
void SignalrouteEntry();   /* Listeneintrag: Signalroute                 */
void GlobalsignalEntry();  /* Listeneintrag: globales Signal             */
void ChannelEntry();       /* Listeneintrag: Kanal                       */
void ProcessEntry();       /* Listeneintrag: Prozess                     */
void SignalTest();         /* Erstellen der Hilfsdatei CHL...            */
void SearchSignal();       /* Suchen Signal-Eintrag                      */
void SearchBlock();        /* Suchen Block-Eintrag                       */
void BlockProcessTest();   /* Testprozedure Hierarchiestruktur           */
void SearchProcess();      /* Suchen Process-Eintrag                     */
void SearchLocal();        /* Suchen lokalen Signal-Eintrag              */
void VariableEntry();      /* Listeneintrag: Variable                    */
void LocalsignalEntry();   /* Listeneintrag: lokales Signal              */
void SearchLocalRoute();   /* Suchen Signalrouten-Eintrag                */
void SignalCheck();        /* Syntaxkontrolle der Signalnamen            */
void ProcedureEntry();     /* Listeneintrag: Prozedur                    */
void SearchChannel();      /* Suchen Kanal-Eintrag                       */
int BlockExist();          /* Nachweis eines Kanal-Eintrags              */
int RouteExist();          /* Nachweis eines Signalrouten-Eintrags       */
void SearchRoute();        /* Suchen Signalrouten-Eintrag                */
void CreateEntry();        /* Listeneintrag: dynamische Prozesserzeugung */
void ProcessEntry2();      /* Listeneintrag: Prozess                     */
int ProcessExist();        /* Nachweis eines Signalrouten-Eintrags       */
void SearchProcess2();     /* Suchen Prozess-Eintrag                     */
void LocalRouteEntry();    /* Listeneintrag: Signalroute                 */
void FileSystemH();        /* Erstellen der Datei SDLSystem...h          */
void FileSystemCStart();   /* Erstellen der Datei SDLSystem...c          */
void FileProcessCStart();  /* Erstellen des Dateianfangs SDLProcess...c  */
void FileProcessCEnd();    /* Erstellen des Dateiendes SDLProcess....c   */
%}

/*------------------- Attributtypdeklaration ----------------------------*/

%union {
        char *text_val;
        char *num_val;
       }

/*-------------------- Tokendeklarationen -------------------------------*/

%token <text_val> NAME CHRISSY
%token <text_val> TYPEDEFI ABSTRDATATYPE
%token <num_val> NUMBER 
%token ACTIVE ADDING ALL ALTERNATIVE AXIOMS BLOCK
       CALL CHANNEL COMMENT CONNECT CONSTANT CONSTANTS
       CREATE DCL DECISION DEFAULT ELSE ENDALTERNATIVE ENDBLOCK
       ENDCHANNEL ENDDECISION ENDGENERATOR ENDNEWTYPE
       ENDPROCEDURE ENDPROCESS ENDREFINEMENT
       ENDSELECT ENDSERVICE ENDSTATE ENDSUBSTRUCTURE ENDSYNTYPE ENDSYSTEM
       ENV ERROR EXPORT EXPORTED EXTERNAL FI FOR FPAR FROM
       GENERATOR IF IMPORT IMPORTED IN INHERITS INPUT JOIN
       LITERAL LITERALS MAP NAMECLASS NEWTYPE NEXTSTATE
       NOW OFFSPRING OPERATOR OPERATORS ORDERING OUT OUTPUT
       PARENT PRIORITY PROCEDURE PROCESS PROVIDED REFERENCED
       REFINEMENT REMOTE RESET RETURN REVEALED REVERSE SAVE SELECT
       SELF SENDER SERVICE SET SIGNAL SIGNALLIST SIGNALROUTE SIGNALSET
       SPELLING START STATE STOP STRUCT SUBSTRUCTURE SYNONYM SYNTYPE SYSTEM
       TASK THEN  TIMER TO TYPE VIA VIEW VIEWED
       WITH IMPLY 
%token <text_val> COMMENTINC 
%token OR
%token XOR
%token AND
%token NE
%token GT
%token GE
%token LT
%token LE
%token PLUS
%token MINUS
%token CONC
%token MOD
%token REM
%token NOT
%token AXIOMIMPLY
%token AXIOMEQUAL
%token ARROW
%token ASSIGN
%token SEMICOLON
%token COMMA
%token LEFTPAR
%token RIGHTPAR
%token ASTERISK
%token COLON
%token SLASH
%token EQUAL
%token EXCLAMATION
%token LEFTPARPOINT
%token RIGHTPARPOINT LTLT GTGT QUOTE STRING 

%%

/*------------------------ Startregel -----------------------------------*/

sdlspecific     :zerotextsysdefi 
                {
                FileChannel(systemname);
                FileSignal(systemname);
                printf(" ");     
                FileTimer(systemname);
                FileTypeEnd(systemname);
                FileSystemH(systemname);
                FileSystemCStart(systemname);
                FileProcessType(systemname);
                FileMake(systemname);
                printf("\n Compilation complete \n\n"); 
                }     
                ;

zerotextsysdefi :/* Optional leer */
                |sysdefi 
                |sysinstance 
                ;                    

/*------------------ System-Definition ----------------------------------*/

sysdefi         :SYSTEM NAME dummysys end includefile zerosysbodylst 
                 ENDSYSTEM dummysystwo zeronm end dummysystwo zeroreferdlst
                {
                SignalTest(globalsignallistbegin,blocklistbegin,
                           systemname);
                /*BlockProcessTest(blocklistbegin);*/
                }
                ;        

/*--------------------- Einbinden ADT-Datei -----------------------------*/

includefile     :/* Optional leer */
                |COMMENTINC
                {
                AbstractEntry($<text_val>1);
                includeflag = TRUE;
                }
                ;
                 
sysinstance     :SYSTEM NAME COLON typeexpr end 
                ;

dummysys        :/* Optional leer */
                {
                includeflag = FALSE;
                Firstabstract = TRUE;
                systemname = $<text_val>0;
                systemnumber = 1;
                processall=0;
                FileType(systemname);
                contindex = 0;
                indexnumber = 2;
                systemflag = TRUE;
                Firstglobalsignal = TRUE;
                Firstchannel = TRUE;
                Firstblock = TRUE;
                Firstsignroute = TRUE;
                Firstprocess = TRUE;
                channellistbegin = NULL;
                blocklistbegin = NULL;
                Firstlocalsignroute = TRUE;
                Firstprocess2 = TRUE;
                number_of_processes = 0;
                notfound = FALSE;
                firsttimer = TRUE;
                rangeflag = FALSE;
                }
                ;

dummysystwo     :/* Optional leer */
                {systemflag = FALSE;}
                ;

zerosysbodylst  :/* Optional leer */
                |zerosysbodylst sysbody 
                ;
                
sysbody         :entinsys 
                |sysbodyselect 
                ;
                
sysbodyselect   :SELECT IF LEFTPAR expres RIGHTPAR end zerosysbodylst 
                 ENDSELECT end 
                ;
                
entinsys        :blockdefi
                |blockref 
                |blockinstset 
                |chandefi 
                |signdefi 
                |signlistdefi 
                |datadefi 
                |prcddefi 
                |prcdref
                ;
                                                                       
zeroreferdlst   :/* Optional leer */
                |zeroreferdlst referddef 
                ;
                
referddef       :blockdefi 
                |prcsdefi 
                |servdefi 
                |prcddefi 
                |subdefi 
                ;

/*----------------------- Block-Definition ------------------------------*/
  
blockdefi       :BLOCK NAME dummyblk end zeroblockbodylst zerosub ENDBLOCK
                 zeroid end 
                {blockAKT = NULL;}
                ;

dummyblk        :/* Optional leer */
                {
                SearchBlock($<text_val>0);
                blockAKT->Firstprocess = TRUE;
                blockAKT->Firstlocalsignal = TRUE;
                }
                ;

blockref        :BLOCK NAME REFERENCED end
                {if (!BlockExist($<text_val>2) || Firstblock)
                   {BlockEntry($<text_val>2);}
                }
                ;
                
blockinstset    :BLOCK NAME zeroblockinstno COLON typeexpr end 
                ;
                
zeroblockinstno :/* Optional leer */
                |LEFTPAR expres RIGHTPAR 
                ;
                
zeroblockbodylst:/* Optional leer */
                |zeroblockbodylst blockbody 
                ;
                
blockbody       :entinblock 
                |connect 
                |blockbodyselect
                ;
                
blockbodyselect :SELECT IF LEFTPAR expres RIGHTPAR end zeroblockbodylst 
                 ENDSELECT end 
                ;
              
entinblock      :prcsdefi 
                |prcsref 
                |prcsinstset 
                |signroutedefi 
                |signdefi 
                |signlistdefi      
                |datadefi 
                |prcddefi 
                |prcdref 
                ;

/*---------------------- Kanal-Definition -------------------------------*/
         
chandefi        :CHANNEL NAME dummychan path zeropath zerosub ENDCHANNEL 
                 zeronm end
                {chan = FALSE;}      
                ;                

dummychan       :/* Optional leer */
                {
                chan = TRUE;
                chanhelpname = $<text_val>0;
                ChannelEntry($<text_val>0);
                }
                ;

zerosub         :/* Optional leer */
                |sub 
                ;
                
sub             :subdefi 
                |subref 
                ;

/*------------------ Unterstruktur-Definitionen -------------------------*/
                
subdefi         :SUBSTRUCTURE zeroid end zerosubbodylst ENDSUBSTRUCTURE
                 zeroid end 
                ;
                
subref          :SUBSTRUCTURE NAME REFERENCED end 
                ;
               
zerosubbodylst  :/* Optional leer */
                |zerosubbodylst subbody 
                ;
                
subbody         :entinsys 
                |connect 
                |subbodyselect 
                ;
                
subbodyselect   :SELECT IF LEFTPAR expres RIGHTPAR end zerosubbodylst 
                 ENDSELECT end 
                ;
                
/*---------------------- Prozess-Definition -----------------------------*/

prcsdefi        :PROCESS id1 zeroinstnotwo end zeroprcsfmlprms zeroinpset 
                 zeroprcsdcllst zerobody ENDPROCESS zeroid end 
                {
                fclose(StateCpointer);
                TempInit();
                stateAKT = processAKT->statelistbegin;
                while(stateAKT)
                {
                TempState(stateAKT->name);
                if (everyexist)
                  {TempState("EveryState");}
                stateAKT = stateAKT->next;
                }
                fclose(ProcessCpointer);
                FileProcessCEnd(processAKT->name);
                everyexist = FALSE;
                processflag = FALSE;
                FileProcessH(processAKT->name,systemname);
                FilePTypeEnd(processAKT->name);
                SearchProcess($<text_val>2);
                FileRemove();
                }
                ;

prcsref         :PROCESS id1 zeroinstno REFERENCED end
                {
                ProcessEntry($<text_val>2);
                if (!ProcessExist($<text_val>2) || Firstprocess2)
                {
                    ProcessEntry2($<text_val>2,indexnumber);
                    indexnumber = indexnumber+1;
                }
                number_of_processes = number_of_processes+1;
                SearchProcess2($<text_val>2);
                process2AKT->processmaxnumber = prcsmaxhelp;
                process2AKT->atbeginnumber = atbegin;
                }
                ;

prcsinstset     :PROCESS id1 zeroinstno COLON typeexpr end 
                ;
                
zeroinstno      :/* Optional leer */
                |LEFTPAR zeroexpres RIGHTPAR 
                |LEFTPAR zeroexpres COMMA zeroexpres RIGHTPAR
                { 
                atbegin = atoi($<num_val>2);
                prcsmaxhelp = atoi($<num_val>4);
                processall = processall + prcsmaxhelp;
                }
                ;
                
zeroinstnotwo   :/* Optional leer */
                {
                SearchProcess($<text_val>0);
                FilePType(processAKT->name);
                FileProcessCStart($<text_val>0);
                processAKT->Firsttimer = TRUE;
                processAKT->Firststate = TRUE;
                processAKT->Firstvariable = TRUE;
                processAKT->Firstprocedure = TRUE;
                processAKT->Firstcreate = TRUE;
                processflag = TRUE;
                }
                |LEFTPAR zeroexpres RIGHTPAR
                |LEFTPAR zeroexpres COMMA zeroexpres RIGHTPAR
                ;

zeroprcsfmlprms :/* Optional leer */
                |prcsfmlprms 
                ;
                        
prcsfmlprms     :prcsfmlprms1 end 
                ;
                
prcsfmlprms1    :FPAR prcsfmlprmlst 
                ;
                
prcsfmlprmlst   :prcsfmlprm 
                |prcsfmlprmlst COMMA prcsfmlprm 
                ;
                
prcsfmlprm      :nmwordlst id 
                ;
                
zeroinpset      :/* Optional leer */
                |SIGNALSET zerosignlst end
                ;
                
zerosignlst     :/* Optional leer */
                |signlst 
                ;
                
zeroprcsdcllst  :/* Optional leer */
                |zeroprcsdcllst prcsdcl 
                ;
                
prcsdcl         :entinprcs 
                |connect
                |prcsdclselect 
                ;
                
prcsdclselect   :SELECT IF LEFTPAR expres RIGHTPAR end zeroprcsdcllst 
                 ENDSELECT end 
                ;
                
entinprcs       :signdefi 
                |signlistdefi 
                |prcddefi
                |prcdref
                |datadefi 
                |vardefi 
                |viewdefi 
                |impvarspec 
                |timerdefi 
                |servdefi 
                |servref 
                |servinst 
                |signroutedefi 
                ;

/*------------------------- Service-Definitionen ------------------------*/
                    
servdefi         :SERVICE id1 end zeroinpset zeroservdcllst body ENDSERVICE 
                  zeroid end 
                 ;
                 
servref          :SERVICE NAME REFERENCED end 
                 ;
                  
servinst         :SERVICE NAME COLON typeexpr end 
                 ;
                 
zeroservdcllst   :/* Optional leer */
                 |zeroservdcllst servdcl 
                 ;
                 
servdcl          :entinserv 
                 |servdclselect 
                 ;
                 
servdclselect    :SELECT IF LEFTPAR expres RIGHTPAR end zeroservdcllst 
                  ENDSELECT end 
                 ;
                 
entinserv        :vardefi 
                 |prcddefi 
                 |prcdref 
                 |viewdefi 
                 |impvarspec 
                 |timerdefi 
                 |datadefi 
                 ;
                    
prcddefi         :zeroexport PROCEDURE id head end zeroprcdfmlprms 
                  zeroprcddcllst typebody endprcd 
                 ;
                    
endprcd          :ENDPROCEDURE zeroid end 
                 ;
                    
prcdref          :zeroexport PROCEDURE NAME REFERENCED end 
                 {ProcedureEntry($<text_val>3);}
                 ;

/*---------------------- Export-Definitionen ----------------------------*/

zeroexport       :/* Optional leer */
                 |EXPORTED 
                 ;
                    
zeroprcdfmlprms  :/* Optional leer */
                 |FPAR prcdfmlprmlst end 
                 ;
                    
prcdfmlprmlst    :prcdfmlprm 
                 |prcdfmlprmlst COMMA prcdfmlprm 
                 ;
                    
prcdfmlprm       :zeroprcdparmkind nmwordlst id 
                 ;
                    
zeroprcdparmkind :/* Optional leer */
                 |IN 
                 |IN SLASH OUT 
                 ;
                    
zeroprcddcllst   :/* Optional leer */
                 |zeroprcddcllst prcddcl 
                 ;
                    
prcddcl          :entinprcd 
                 |prcddclselect 
                 ;
                    
prcddclselect    :SELECT IF LEFTPAR expres RIGHTPAR end zeroprcddcllst 
                  ENDSELECT end 
                 ;
                    
entinprcd        :prcddefi 
                 |prcdref 
                 |datadefi 
                 |vardefi 
                 ;              
                    
zeroopdefis      :/* Optional leer */
                 |zeroopdefis opdefiorref 
                 ;
                    
opdefiorref      :opref 
                 ;

opref            :OPERATOR opnm REFERENCED end
                 ;

/*------------------ Signallisten-Definitionen --------------------------*/

signlistdefi     :SIGNALLIST NAME dummysiglist EQUAL signlst end 
                 {signallst = FALSE;}
                 ;

dummysiglist     :/* Optional leer */
                 {signallst = TRUE;}
                 ;
                  
signlst          :signlstitem 
                 |signlst COMMA signlstitem 
                 ;
                  
signlstitem      :NAME
                 {
                 if (chan)
                 {
                     SignalCheck(2,$<text_val>1,NULL,globalsignallistbegin);
                     SearchSignal($<text_val>1,globalsignallistbegin);
                     if (globalsignalAKT->chanpoint != NULL)
                     {
                         GlobalsignalEntry(globalsignalAKT->name);
                         globalsignaljustnew->chanpoint = channeljustnew;
                         SearchBlock(starthelpblock);    
                         globalsignaljustnew->startblock = blockAKT;
                         SearchBlock(endhelpblock);
                         globalsignaljustnew->endblock = blockAKT;
                     }
                     else
                     {
                         globalsignalAKT->chanpoint = channeljustnew;
                         SearchBlock(starthelpblock);
                         globalsignalAKT->startblock = blockAKT;
                         if (!strcmp(starthelpblock,"environment"))
                         {
                             SearchRoute("environment");
                             globalsignalAKT->startroute = signrouteAKT;
                         }
                         SearchBlock(endhelpblock);
                         globalsignalAKT->endblock = blockAKT;
                         if (!strcmp(endhelpblock,"environment"))
                         {
                             SearchRoute("environment");
                             globalsignalAKT->endroute = signrouteAKT;
                         }
                     }
                     }
                     if (signroute && !envflag)
                     {
                         SearchLocal($<text_val>1);
                         SearchProcess2(starthelpprocess);
                         locAKT->startprocess = process2AKT;
                         SearchProcess2(endhelpprocess);
                         locAKT->endprocess = process2AKT;
                         SearchLocalRoute(routehelpname);
                         locAKT->routepoint = localsignrouteAKT;
                         envflag = FALSE;
                     }
                     if (signroute && envflag && !envflagfirst)
                     {
                         SearchRoute(starthelproute);
                         SearchSignal($<text_val>1,globalsignallistbegin);
                         SearchProcess2(starthelpprocess);
                         signrouteAKT->processpoint = process2AKT;
                         while(!(!strcmp(globalsignalAKT->chanpoint->name,
                         signrouteAKT->connectpoint->name)&& !strcmp
                         (globalsignalAKT->startblock->name,blockAKT->name)))
                         {globalsignalAKT = globalsignalAKT->next;}
                         globalsignalAKT->startroute = signrouteAKT;
                     }
                     if (signroute && envflag && !envflagsecond)
                     {
                         SearchRoute(endhelproute);
                         SearchSignal($<text_val>1,globalsignallistbegin);
                         SearchProcess2(endhelpprocess);
                         signrouteAKT->processpoint = process2AKT;
                         while(!(!strcmp(globalsignalAKT->chanpoint->name,
                           signrouteAKT->connectpoint->name)&& !strcmp
                           (globalsignalAKT->endblock->name,blockAKT->name)))
                         {globalsignalAKT = globalsignalAKT->next;}
                         globalsignalAKT->endroute = signrouteAKT;
                     }
                 }
                 |qual NAME
                 |LEFTPAR id RIGHTPAR
                 ;

/*----------------------- Signal-Definitionen ---------------------------*/

signdefi          :SIGNAL signdefitemlst end
                  ;

signdefitemlst    :signdefitem 
                  |signdefitemlst COMMA signdefitem 
                  ;
                  
signdefitem       :NAME simphead zerosortlist zerosignrefin 
                  {
                  if (systemflag == TRUE)
                    {GlobalsignalEntry($<text_val>1);}
                  else
                    {LocalsignalEntry($<text_val>1);}   
                  }
                  ;
                  
zerosignrefin     :/* Optional leer */
                  |REFINEMENT subsigndeflst ENDREFINEMENT 
                  ;

subsigndeflst     :subsigndef 
                  |subsigndeflst subsigndef 
                  ;

subsigndef        :zeroreverse signdefi 
                  ;
                  
zeroreverse       :/* Optional leer */
                  |REVERSE 
                  ;

/*-------------------------Signalrouten-Definitionen --------------------*/
                  
signroutedefi     :SIGNALROUTE NAME dummysignroute path zeropath
                  {
                  signroute = FALSE;
                  envflag = FALSE;
                  envflagfirst = FALSE;
                  envflagsecond = FALSE;
                  }
                  ;

dummysignroute    :/* Optional leer */
                  {
                  signroute = TRUE;
                  envflag = FALSE;
                  envflagfirst = FALSE;
                  envflagsecond = FALSE;
                  routehelpname = $<text_val>0;
                  if (!RouteExist(routehelpname))
                    {LocalRouteEntry(routehelpname);}
                  }
                  ;

/*-------------------- Pfad-Definitionen --------------------------------*/
 
zeropath          :/* Optional leer */
                  |dummyzeropath path 
                  {bidirect = FALSE;}
                  ;

dummyzeropath     :/* Optional leer */
                  {
                  bidirect = TRUE;
                  if (chan)
                  {
                      ChannelEntry(chanhelpname);
                      strcpy(channeljustnew->biname,chanhelpname);
                      strcat(channeljustnew->biname,"_BI");
                  }
                  envflagfirst = FALSE;
                  envflagsecond = FALSE;
                  }
                  ;
                  
path              :FROM endpunitfirst zerogate TO endpunitsecond
                   zerogate WITH signlst end 
                  ;


endpunitfirst     :ENV   
                  {
                  if(signroute)
                  {endhelproute = routehelpname;}
                  envflag = TRUE;
                  envflagfirst = TRUE;
                  if (chan)
                  {
                      starthelpblock = "environment";
                      if (!BlockExist(starthelpblock) || Firstblock)
                      {
                          BlockEntry(starthelpblock);
                          channeljustnew->startblock = blockAKT; 
                          SignalrouteEntry("environment");
                          SearchRoute("environment");
                          channeljustnew->endroute = signrouteAKT;
                          if (!ProcessExist("environment"))
                            {ProcessEntry2("environment",1);}
                          SearchProcess2("environment");
                          signrouteAKT->processpoint = process2AKT;
                      }
                  }
                  }
                  |NAME
                  {
                  if (chan)
                  {
                      if (!BlockExist($<text_val>1) || Firstblock)
                        {BlockEntry($<text_val>1);}
                      SearchBlock($<text_val>1);
                      starthelpblock = $<text_val>1;
                      channeljustnew->startblock = blockAKT;
                  }
                  if(signroute)
                  {
                      if (!ProcessExist($<text_val>1) || Firstprocess2)
                      {
                          ProcessEntry2($<text_val>1,indexnumber);
                          /*SearchProcess2($<text_val>1);*/
                          indexnumber = indexnumber+1;
                      }
                      starthelpprocess = $<text_val>1;
                  }
                  }
                  |qual NAME
                  ;

endpunitsecond    :ENV
                  {
                  if (signroute)
                    {starthelproute = routehelpname;}          
                  envflag = TRUE;
                  envflagsecond = TRUE;
                  if (chan)
                  {
                      endhelpblock = "environment";
                      if (!BlockExist(endhelpblock) || Firstblock)
                      {
                          BlockEntry(endhelpblock);
                          SearchBlock(endhelpblock);
                          channeljustnew->endblock = blockAKT;
                          SignalrouteEntry("environment");
                          SearchRoute("environment");
                          channeljustnew->startroute = signrouteAKT;
                          if (!ProcessExist("environment"))
                            {ProcessEntry2("environment",1);}
                          SearchProcess2("environment");
                          signrouteAKT->processpoint = process2AKT;
                      }
                  }
                  }
                  |NAME
                  {
                  if (chan)
                  {
                      if (!BlockExist($<text_val>1) || Firstblock)
                        {BlockEntry($<text_val>1);}
                      SearchBlock($<text_val>1);
                      endhelpblock = $<text_val>1;
                      channeljustnew->endblock = blockAKT;
                  }
                  if (signroute)
                  {
                      if (!ProcessExist($<text_val>1) || Firstprocess2)
                      {
                          ProcessEntry2($<text_val>1,indexnumber);
                          indexnumber = indexnumber+1;
                      }
                      endhelpprocess = $<text_val>1;
                  }                    
                  }
                  |qual NAME
                  ; 
                                    
zerogate          :/* Optional leer */
                  |VIA id 
                  ;
                  
/*-------------- Kanal-Signalrouten-Verknuepfung ------------------------*/

connect           :CONNECT connectpoint AND idlst end 
                  {
                  signroute = FALSE;
                  connect = FALSE;
                  }
                  ;

connectpoint      :ENV 
                  |idlst
                  {
                  SearchChannel($<text_val>1);
                  connect = TRUE;
                  signroute = TRUE;
                  } 
                  ;

/*------------------- Variablen-Definitionen ----------------------------*/
                  
vardefi          :DCL zerorevealexport dummyvar varsofsortlst end 
                 {varflag = FALSE;}
                 ;

dummyvar         :/* Optional leer */
                 {varflag = TRUE;}
                 ;
                 
zerorevealexport :/* Optional leer */
                 |REVEALED 
                 |EXPORTED 
                 |REVEALED EXPORTED 
                 |EXPORTED REVEALED 
                 ;
                 
varsofsortlst    :varsofsort
                 |varsofsortlst COMMA varsofsort 
                 ;
                 
varsofsort       :varexpaslst id zeroinitial 
                 {processAKT->varlstbegin->vartype = $<text_val>2;}
                 ;
                 
varexpaslst      :varexpas 
                 |varexpaslst COMMA varexpas 
                 ;
                 
varexpas         :nmword
                 {VariableEntry($<text_val>1);} 
                 ;
                 
zeroinitial      :/* Optional leer */
                 |ASSIGN expres 
                 ;

/*--------------------- Import-Definitionen -----------------------------*/
  
impvarspec       :IMPORTED impvarspecitemlst end 
                 ;
                 
impvarspecitemlst:impvarspecitem 
                 |impvarspecitemlst COMMA impvarspecitem 
                 ;
                   
impvarspecitem   :idwordlst1 id
                 ;
                 
viewdefi         :VIEWED viewdefitemlst end 
                 ;
                 
viewdefitemlst   :viewdefitem 
                 |viewdefitemlst COMMA viewdefitem 
                 ;
                 
viewdefitem      :idwordlst id 
                 ;

/*---------------------- Timer-Definitionen -----------------------------*/

timerdefi        :TIMER timerdefitemlst end 
                 ;
                 
timerdefitemlst  :timerdefitem 
                 |timerdefitemlst COMMA timerdefitem 
                 ;
                 
timerdefitem     :NAME zerosortlist zeroinitial 
                 {
                 TimerEntry($<text_val>1);
                 SearchProcess2(processAKT->name);
                 process2AKT->timerexist = "TRUE";
                 }
                 ;
                 
zerosortlist     :/* Optional leer */
                 |LEFTPAR idlst RIGHTPAR 
                 ;
                 
zerobody         :/* Optional leer */
                 |body 
                 ;
                 
body             :start zerostatebodylst 
                 ;

/*-------------------------- Start-Zustand ------------------------------*/
                 
start            :START dummystart end transition 
                 ;

dummystart       :/* Optional leer */
                 {
                 initflag = TRUE;
                 StateCpointer = fopen("INIT","w");
                 fprintf(StateCpointer,
                         "\n\n\tswitch(state()){\n\n\tcase INIT:\n");
                 } 
                 ;

typebody         :zerotypestart zerostatebodylst 
                 ;
                 
zerotypestart    :/* Optional leer */
                 |START end transition 
                 ;

/*-------------------------- Zustaende ----------------------------------*/
                 
zerostatebodylst :/* Optional leer */
                 |zerostatebodylst statebody 
                 ;
                 
statebody        :state 
                 ;
                 
state            :STATE statelst end zeroinpcontsavelst zeroendstate 
                 ;
                 
statelst         :nmlst
                 {
                 StateEntry($<text_val>1);
                 aktstatename = $<text_val>1;
                 stateflag = TRUE;
                 everystate = FALSE;
                 fclose(StateCpointer);
                 StateCpointer = fopen(aktstatename,"w");
                 if (!initflag)
                   {fprintf(StateCpointer,
                            "\n\n\t\t\t\tdefault: return 0;\n\t\t\t}");}
                 initflag = FALSE;
                 fprintf(StateCpointer,"\n\n\tcase %s:",aktstatename); 
                 } 
                 |ASTERISK  
                 {
                 processAKT->EveryStateExist = TRUE;
                 aktstatename = "EveryState";
                 everyexist = TRUE;
                 everystate = TRUE;
                 stateflag = TRUE;
                 fclose(StateCpointer);
                 StateCpointer = fopen(aktstatename,"w");
                 } 
                 |ASTERISK LEFTPAR nmlst RIGHTPAR
                 ;
                 
zeroendstate     :/* Optional leer */
                 |ENDSTATE zeronm end 
                 ;
         
zeroinpcontsavelst  :/* Optional leer */
                    |zeroinpcontsavelst inpcontsave 
                    ;
                 
inpcontsave      :inputpart 
                 |remoteprcdinp 
                 |contsignal 
                 |savepart 
                 |remoteprcdsave 
                 ;
                 
inputpart        :INPUT inplst end zeroenabcond transition 
                 ;
                 
inplst           :stimuluslst 
                 |ASTERISK 
                 ;
                 
stimuluslst      :stimulus 
                 |stimuluslst COMMA stimulus 
                 ;
                 
stimulus         :id1 zeroinpvarlst 
                 {
                 if (!TimerExist($<text_val>1))
                   {SignalCheck(1,$<text_val>1,blockAKT->loclstbegin,
                                globalsignallistbegin);}
                 if (stateflag && !everystate)
                 {
                     fprintf(StateCpointer,
                             " switch(signal) {\n\n\t\t\t\tcase %s:\n",
                             $<text_val>1);
                     stateflag = FALSE;
                 }
                 else
                 {
                     fprintf(StateCpointer,"\n\t\t\t\tcase %s:\n",
                             $<text_val>1);
                 }
                 }
                 ;
                 
zeroenabcond     :/* Optional leer */
                 |PROVIDED expres end 
                 ;

remoteprcdinp    :INPUT PROCEDURE idlst end zeroenabcond transition 
                 ;

contsignal       :PROVIDED expres end zeropriority transition 
                 ;
                 
zeropriority     :/* Optional leer */
                 |PRIORITY NAME end 
                 ;
                 
savepart         :SAVE savelst end
                 {processAKT->saveexist = "TRUE";}
                 ;
                 
savelst          :signlst 
                 |ASTERISK 
                 ;
                 
remoteprcdsave   :SAVE PROCEDURE idlst end 
                 ;
                 
transition       :terminstmt 
                 |actionstmtlst zeroterminstmt 
                 ;
                 
/*------------------------------ Aktionen ------------------------------ */

actionstmtlst    :actionstmt 
                 |actionstmtlst actionstmt 
                 ;
                 
actionstmt       :action end 
                 |NAME COLON action end 
                 {dummy = $<text_val>1;}
                 ;
                 
action           :task 
                 |output 
                 |create 
                 |decision 
                 |option 
                 |set 
                 |reset 
                 |export 
                 |call 
                 ;
                 
task             :TASK dummytask taskbody
                 {taskflag = FALSE;}
                 ;

dummytask        :/* Optional leer */
                 {taskflag = TRUE;}
                 ;
                
taskbody         :assignstmtlst
                 |informaltxtlst
                 ;
                 
assignstmtlst    :assignstmt 
                 |assignstmtlst COMMA assignstmt 
                 ;

assignstmt       :variable ASSIGN dummyassign expres
                 {
                 if (taskflag)
                   {fprintf(StateCpointer,";\n");}
                 }
                 ;

dummyassign      :/* Optional leer */
                 {fprintf(StateCpointer," = ");}
                 ;
                 
informaltxtlst   :STRING 
                 |informaltxtlst COMMA STRING 
                 ;
                 
create           :CREATE id zeroactualprmers
                 {
                 SearchProcess2($<text_val>2);
                 fprintf(StateCpointer,
                   "\t\t\t\tSystem->create(new SDLProcess_%s(\"%s\", System, %d));\n",
                   $<text_val>2,$<text_val>2,process2AKT->processtype);
                 CreateEntry($<text_val>2);      
                 } 
                 ;
                 

call             :CALL id zeroactualprmers zerooutputtarget 
                 ;

/*---------------------- Decision-Deklarationen -------------------------*/
                 
decision         :DECISION dummydesc question end answpartlst 
                  zeroelsepart ENDDECISION
                 {
                 strcpy(helpcontainer[contindex],"");
                 contindex = contindex-1;
                 }                
                 ;

dummydesc        :/* Optional leer */
                 {
                 contindex = contindex+1;
                 descflag = TRUE;
                 }
                 ;

question         :expres
                 {descflag = FALSE;}
                 ;
                 
answpartlst      :answpart 
                 |answpartlst answpart 
                 ;
                 
answpart         :answ COLON
                 |answ COLON transition
                 {fprintf(StateCpointer,"\t\t\t\t}\n");} 
                 ;
                 
answ             :LEFTPAR dummyrange rangecond RIGHTPAR
                 {rangeflag = FALSE;} 
                 |LEFTPAR RIGHTPAR 
                 ;

dummyrange       :/* Optional leer */
                 {rangeflag = TRUE;}
                 
zeroelsepart     :/* Optional leer */
                 |ELSE COLON 
                 |ELSE COLON transition 
                 ;
                 
option           :ALTERNATIVE expres end answpartlst zeroelsepart 
                  ENDALTERNATIVE 
                 ;
                 
set              :SET dummyset setstmtlst 
                 {taskflag = FALSE;} 
                 ;

dummyset         :/* Optional leer */
                 {
                 fprintf(StateCpointer,"\t\t\t\tSystem->set(");
                 taskflag = TRUE;
                 }
                 ;
                 
setstmtlst       :setstmt 
                 |setstmtlst COMMA setstmt 
                 ;
                 
setstmt          :LEFTPAR id RIGHTPAR 
                 |LEFTPAR primary LEFTPAR expreslst RIGHTPAR RIGHTPAR 
                 |LEFTPAR expres COMMA id zeroexpreslst RIGHTPAR
                 {fprintf(StateCpointer,",%s);\n",$<text_val>4);}           
                 ;
  
reset            :RESET LEFTPAR resetstmtlst RIGHTPAR 
                 ;
                
resetstmtlst     :resetstmt 
                 |resetstmtlst COMMA resetstmt 
                 ;
                
resetstmt        :id zeroexpreslst
                 {
                 fprintf(StateCpointer,
                         "\t\t\t\tSystem->reset(%s);\n",$<text_val>1);
                 } 
                 ;

/*----------------------- Output-Deklarationen --------------------------*/
                
output           :OUTPUT outputsignlst zerooutputtarget zerodirectvia 
                 ;
                
outputsignlst   :outputsign 
                |outputsignlst COMMA outputsign 
                ;
                
outputsign      :id zeroactualprmers 
                {
                SignalCheck(1,$<text_val>1,blockAKT->loclstbegin,
                            globalsignallistbegin);
                SearchSignal($<text_val>1,globalsignallistbegin);
                if (notfound)
                {
                    SearchLocal($<text_val>1);
                    fprintf(StateCpointer,"\t\t\t\tSystem->output(%s,%d);\n",
                            $<text_val>1,locAKT->endprocess->processtype);
                    notfound = FALSE;
                }
                else
                {
                    fprintf(StateCpointer,
                        "\t\t\t\tSystem->output(%s,%d,System->channel(%s));\n",
                        $<text_val>1,
                        globalsignalAKT->endroute->processpoint->processtype,
                        globalsignalAKT->chanpoint->name);
                }
                }
                ;
                
zerooutputtarget:/* Optional leer */
                |outputtarget 

outputtarget    :TO expres 
                ;
                
zerodirectvia   :/* Optional leer */
                |VIA idlst 
                |VIA ALL idlst 
                ;
                
export          :EXPORT LEFTPAR idlst RIGHTPAR 
                ;
                
zeroterminstmt  :/* Optional leer */
                |terminstmt 
                ;                
                
terminstmt      :termin end 
                |NAME COLON termin end 
                {dummy = $<text_val>1;}
                ;
                
termin          :JOIN NAME 
                {dummy = $<text_val>2;}
                |NEXTSTATE nmorminus 
                |RETURN zeroexpres 
                |STOP 
                {
                fprintf(StateCpointer,
                        "\t\t\t\tSystem->stop();\n\t\t\t\treturn 0;\n");
                }
                ;
                
nmorminus       :MINUS 
                {
                if (everystate)
                {
                    fprintf(StateCpointer,
                            "\t\t\t\tstate(state());\n\t\t\t\treturn 0;\n");
                }
                else
                {
                    fprintf(StateCpointer,
                            "\t\t\t\tstate(%s);\n\t\t\t\treturn 0;\n",
                            aktstatename);
                }
                }
                |NAME 
                {
                    fprintf(StateCpointer,
                            "\t\t\t\tstate(%s);\n\t\t\t\treturn 0;\n",
                            $<text_val>1);
                }
                ;
                
zeroinpvarlst   :/* Optional leer */
                |LEFTPAR zerovariablelst RIGHTPAR 
                ;
                
zerovariablelst :zerovariable 
                |zerovariablelst COMMA zerovariable 
                ;
                
zeroactualprmers:/* Optional leer */
                |LEFTPAR actparl RIGHTPAR 
                ;
                
actparl         :zeroexpres 
                |actparl COMMA zeroexpres 
                ;
                
datadefi       :parttypedefi end 
               |syntypedefi end 
               |synonymdefi end
               |gendefi end 
               ;
               

/*----------------------- Typen-Deklarationen ---------------------------*/

parttypedefi   :NEWTYPE nmword dummynewstruct zerofmlcontprms properties
                 zeroconstsdef ENDNEWTYPE zeronm 
               |NEWTYPE nmword dummynewstruct zerofmlcontprms structdefi 
                properties zeroconstsdef ENDNEWTYPE zeronm 
               {
               if(systemflag)
                 {fprintf(Typedefipointer,"};/* %s */\n\n",structname);}
               if(processflag)
                 {fprintf(TypedefiPpointer,"};/* %s */\n\n",structname);}
               }
               |NEWTYPE nmword dummynewstruct zerofmlcontprms geninsts 
                properties zeroconstsdef ENDNEWTYPE zeronm 
               |NEWTYPE nmword dummynewstruct zerofmlcontprms inheritandprop
                zeroconstsdef ENDNEWTYPE zeronm 
               ;

dummynewstruct :/* Optional leer */
               {structname = $<text_val>0}
               ;
               
syntypedefi    :SYNTYPE NAME EQUAL id zerodefaultinit zeroconstsdef 
                ENDSYNTYPE zeronm 
               {
               if (systemflag)
               {fprintf(Typedefipointer,"typedef %s %s;\n\n",
                        $<text_val>4,$<text_val>2);
               }
               if (processflag)
               {fprintf(TypedefiPpointer,"typedef %s %s;\n\n",
                        $<text_val>4,$<text_val>2);
               }
               }
               ;
              
synonymdefi    :SYNONYM synodefitemlst 
               ;
               
synodefitemlst :synodefitem 
               |synodefitemlst COMMA synodefitem 
               ;
               
synodefitem    :nmword id EQUAL NUMBER
               {
               if (systemflag)
               {fprintf(Typedefipointer,"const %s %s = %s; \n",
                        $<text_val>2,$<text_val>1,$<num_val>4 );
               }
               if (processflag)
               {fprintf(TypedefiPpointer,"const %s %s = %s; \n",
                        $<text_val>2,$<text_val>1,$<num_val>4 );
               }
               } 
               |nmword EQUAL expres 
               |nmword id EQUAL EXTERNAL 
               |nmword id EQUAL CHRISSY
               {
               if (systemflag)
               {fprintf(Typedefipointer,"const %s %s = \"%s\"; \n",
                        $<text_val>2,$<text_val>1,$<text_val>4 );
               }
               if (processflag)
               {fprintf(TypedefiPpointer,"const %s %s = \"%s\";\n",
                        $<text_val>2,$<text_val>1,$<text_val>4 );
               }
               } 
               ;
               
gendefi        :GENERATOR NAME LEFTPAR genparlst RIGHTPAR zerogeninsts
                 properties ENDGENERATOR zeronm 
               ;
               
genparlst      :TYPE nmlst endgenplst 
               |LITERAL nmlst endgenplst 
               |OPERATOR nmlst endgenplst 
               |CONSTANT nmlst endgenplst 
               ;
               
endgenplst     :/* Optional leer */
               |COMMA genparlst
               ;
               
zerogeninsts   :/* Optional leer */
               |geninsts 
               ;
               
geninsts       :geninst 
               |geninsts geninst 
               ;
               
geninst        :id2 LEFTPAR genactparmlst RIGHTPAR zeroend 
               |id2 LEFTPAR genactparmlst RIGHTPAR zeroend ADDING 
               ;
               
genactparmlst  :genactparm 
               |genactparmlst COMMA genactparm 
               ;
               
genactparm     :term 
               |nameclass 
               |qualquotop 
               |id EXCLAMATION 
               ;
               
structdefi     :STRUCT dummystruct fieldlst zeroend 
               |STRUCT dummystruct fieldlst zeroend ADDING 
               ;

dummystruct    :/* Optional leer */
               {
               if (systemflag)
                 {fprintf(Typedefipointer,"typedef struct %s\n{",structname);}
               if (processflag)
                 {fprintf(TypedefiPpointer,"typedef struct %s\n{",structname);}
               }
               ;

fieldlst       :fields 
               |fieldlst end fields 
               ;
               
fields         :nmwordlst id 
               {
               if (systemflag)
               {fprintf(Typedefipointer,"  %s   %s;\n",$<text_val>1,
                        $<text_val>2);
               }
               if (processflag)
               {fprintf(Typedefipointer,"  %s   %s;\n",$<text_val>1,
                        $<text_val>2);
               }             
               }
               ;

inheritandprop :INHERITS typeexpr inhandlitop zerointextprop zerodefaultinit 
               ;
               
inhandlitop    :inhandlitop1 
               |litren inhandlitop1 
               ;
               
inhandlitop1   :inhandlitop2 
               ;
               
inhandlitop2   :inhandlitop3 
               |ADDING inhandlitop3 
               ;
               
inhandlitop3   :inhandlitop4 
               |litlist inhandlitop4 
               ;
               
inhandlitop4   :zerooplist 
               ;
               
litren         :LITERALS litrenlst end 
               ;
               
litrenlst      :litrenpair 
               |litrenlst COMMA litrenpair 
               ;
               
litrenpair     :litrensig EQUAL litrensig 
               ;
               
litrensig      :NAME 
               {dummy = $<text_val>1;}
               |STRING 
               ;
              
properties     :zerolitlist zerooplist zerointextprop zerodefaultinit 
               ;
               
zerolitlist   :/* Optional leer */
              |litlist 
              ;
              
litlist       :LITERALS litsiglst zeroend 
              ;
              
litsiglst     :litsig 
              |litsiglst COMMA litsig 
              ;
              
litsig        :NAME 
              {dummy = $<text_val>1;}
              |STRING 
              |nameclass 
              ;
              
nameclass     :NAMECLASS regularexp 
              ;
              
regularexp    :orregexp 
              |regularexp orregexp 
              ;
              
orregexp      :partregexp 
              |orregexp OR partregexp 
              ;
              
partregexp    :regelem 
              |regelem regexpexp 
              ;
              
regelem       :STRING 
              |STRING COLON STRING 
              |LEFTPAR regularexp RIGHTPAR 
              ;
              
regexpexp     :ASTERISK 
              |PLUS 
              |nmword 
              ;
              
zerooplist    :/* Optional leer */
              |oplist
              ;
              
oplist        :OPERATORS opsiglst zeroend 
              ;
              
opsiglst      :opsig 
              |opsiglst end opsig 
              ;
              
opsig         :opnm COLON idlst ARROW id 
              |ORDERING 
              ;
              
zerointextprop:zeroopdefis zeroaxioms zeroliteralmap 
              ;
              
zeroaxioms    :/* Optional leer */
              |AXIOMS axiomlst zeroend 
              ;
              
axiomlst      :axiom 
              |axiomlst end axiom 
              ;
              
axiom         :unquanteq 
              |unquanteqlst AXIOMIMPLY unquanteq 
              |FOR ALL nmlst IN id LEFTPAR axiomlst zeroend RIGHTPAR 
              ;
              
unquanteqlst  :unquanteq 
              |unquanteqlst COMMA unquanteq 
              ;
              
unquanteq     :term 
              |term AXIOMEQUAL term 
              ;
              
zeroliteralmap:/* Optional leer */
              |MAP literaleqlst zeroend 
              ;
              
literaleqlst  :literaleq 
              |literaleqlst end literaleq 
              ;
              
literaleq     :FOR ALL nmlst IN id LITERALS LEFTPAR litaxiomlst zeroend 
               RIGHTPAR 
              ;
              
litaxiomlst   :litaxiom 
              |litaxiomlst end litaxiom 
              ;
              
litaxiom      :axiom 
              |literaleq 
              ;
              
zerodefaultinit :/* Optional leer */
                |DEFAULT expres zeroend 
                ;
      
zeroconstsdef   :/* Optional leer */
                |CONSTANTS rangecond 
                ;
             
simphead        :zerofmlcontprms zerospec 
                ;
             
head            :zerofmlcontprms zerospec 
                ;
             
zerofmlcontprms :/* Optional leer */
                |fmlcontprms 
                ;
                
fmlcontprms     :LT fmlcontprmlst GT 
                ;
                
fmlcontprmlst   :fmlcontprm endfmlcontprmlst 
                |PROCESS nmword prcsconstrandendlst 
                |zeroremote PROCEDURE NAME prcdconstrandendlst 
                ;
                
prcsconstrandendlst   :id endfmlcontprmlst 
                      |endfmlcontprmlst  
                      |zeroend FPAR idlst endfmlcontprmlst 
                      ;
prcdconstrandendlst   :endfmlcontprmlst  
                      |zeroend prcdsigfmlprms1 endfmlcontprmlst 
                      ;
                      
endfmlcontprmlst   :/* Optional leer */
                   |end fmlcontprmlst 
                   ;
                   
fmlcontprm         :signfmlcontprm 
                   |timerfmlcontprm 
                   |varfmlcontprm 
                   |sortfmlcontprm 
                   |synonymfmlcontprm 
                   ;

zeroremote         :/* Optional leer */
                   |REMOTE 
                   ;
                   
prcdsigfmlprms1    :FPAR prcdparmconstrlst 
                   ;
                   
prcdparmconstrlst  :prcdparmconstr 
                   |prcdparmconstrlst COMMA prcdparmconstr 
                   ;
                   
prcdparmconstr     :zeroprcdparmkind id 
                   ;
                                                     
signfmlcontprm     :SIGNAL signconstritemlst 
                   ;
                   
signconstritemlst  :signconstritem 
                   |signconstritemlst COMMA signconstritem 
                   ;
                   
signconstritem     :NAME signconstr
                   {dummy = $<text_val>1;}
                   ;
                   
signconstr         :signsig 
                   ;
                   
signsig            :zerosortlist zerosignrefin 
                   ;
                   
timerfmlcontprm    :TIMER timerconstritemlst 
                   ;
                   
timerconstritemlst :timerconstritem 
                   |timerconstritemlst COMMA timerconstritem 
                   ;
                   
timerconstritem    :NAME timerconstr 
                   {dummy = $<text_val>1;}
                   ;
                   
timerconstr        :zerosortlist 
                   ;
                   
varfmlcontprm      :DCL varconstritemlst 
                   ;
                   
varconstritemlst   :varconstritem 
                   |varconstritemlst COMMA varconstritem 
                   ;
                   
varconstritem      :nmwordlst id 
                   ;
                   
sortfmlcontprm     :NEWTYPE NAME zerosortconstr 
                   ;
                   
zerosortconstr     :/* Optional leer */    
                   |sortconstr 
                   ;
                   
sortconstr         :sortsig 
                   ;
                   
sortsig            :zerolitlist zerooplist ENDNEWTYPE zeronm 
                   ;
                   
synonymfmlcontprm  :SYNONYM synoconstritemlst 
                   ;
                   
synoconstritemlst  :synoconstritem 
                   |synoconstritemlst COMMA synoconstritem 
                   ;
                   
synoconstritem     :nmword synoconstr 
                   ;
                   
synoconstr         :id 
                   ;
                  
zerospec           :/* Optional leer */
                   |INHERITS typeexpr 
                   |INHERITS typeexpr ADDING 
                   ;
                   
typeexpr           :id zeroactcontprms 
                   ;
                   
zeroactcontprms    :/* Optional leer */
                   |LT zeroidlst GT 
                   ;
                 
rangecond          :range 
                   |rangecond COMMA range 
                   ;
                   
range              :expres
                   |relop expres 
                   |expres COLON expres 
                   ;
                  
zerovariable       :/* Optional leer */  
                   |variable 
                   ;
                   
variable           :id
                   {
                   if (taskflag)
                     {fprintf(StateCpointer,"\t\t\t\t%s",$<text_val>1);}
                   } 
                   |ABSTRDATATYPE
                   {
                   if (taskflag)
                     {fprintf(StateCpointer,"\t\t\t\t%s",$<text_val>1);}
                   }
                   |variable LEFTPAR dummyvar2 expreslst RIGHTPAR 
                   {fprintf(StateCpointer,")");}  
                   |variable EXCLAMATION NAME 
                   ;

dummyvar2          :/* Optional leer */
                   {fprintf(StateCpointer,"(");}
                   ; 

/*---------------------------- Ausdruecke -------------------------------*/

zeroexpres         :/* Optional leer */
                   |expres 
                   ;
                   
expres             :subexpres 
                   |call
                   ;
                   
subexpres          :opand0 
                   |subexpres IMPLY opand0 
                   ;
                   
opand0             :opand1 
                   |opand0 OR dummyor opand1 
                   |opand0 XOR opand1 
                   ;

dummyor            :/* Optional leer */
                   {
                   if (taskflag && ! descflag)
                     fprintf(StateCpointer," || ");
                   if(descflag && !rangeflag)
                     strcat(helpcontainer[contindex]," || ");
                   }
                   
opand1             :opand2 
                   |opand1 AND dummyand opand2
                   ;

dummyand           :/* Optional leer */
                   {
                   if (taskflag && !descflag)
                     fprintf(StateCpointer," && ");
                   if (descflag && !rangeflag)
                     strcat(helpcontainer[contindex]," && ");
                   } 
                   ;
                   
opand2             :opand3 
                   |opand2 relop opand3 
                   |opand2 IN opand3 
                   ;
                   
opand3             :opand4 
                   |opand3 PLUS dummyplus opand4 
                   |opand3 MINUS dummyminus opand4 
                   |opand3 CONC opand4 
                   ;

dummyminus         :/* Optional leer */
                   {
                   if (taskflag && !descflag)
                     fprintf(StateCpointer,"-");
                   if (descflag && !rangeflag)
                     strcat(helpcontainer[contindex]," - ");
                   }
                   ;

dummyplus          :/* Optional leer */ 
                   {
                   if (taskflag && !descflag)
                     fprintf(StateCpointer,"+");
                   if (descflag && !rangeflag)
                     strcat(helpcontainer[contindex]," + ");
                   }
                   ;
                   
opand4             :opand5 
                   |opand4 ASTERISK dummyaster opand5 
                   |opand4 SLASH dummyslash opand5 
                   |opand4 MOD opand5 
                   |opand4 REM opand5 
                   ;

dummyaster         :/* Optional leer */
                   {
                   if (taskflag)
                     {fprintf(StateCpointer,"*");}
                   }
                   ;

dummyslash         :/* Optional leer */
                   {
                   if (taskflag)
                     {fprintf(StateCpointer,"/");}
                   }
                   ;
                   
opand5             :primary 
                   |MINUS primary 
                   |NOT dummynot primary 
                   ;

dummynot           :/* Optional leer */
                   {fprintf(StateCpointer," ! ");}
                   ;
                   

/*------------------- Primaries-------------*/

primary            :id
                   {
                   if (taskflag && !descflag)
                     fprintf(StateCpointer,"%s",$<text_val>1);
                   if (descflag && !rangeflag)
                     {strcat(helpcontainer[contindex],$<text_val>1);}
                   if (rangeflag && !strcmp($<text_val>1,"true"))
                   {fprintf(StateCpointer,"\t\t\t\tif (%s)\n\t\t\t\t{\n",
                            helpcontainer[contindex]);
                   }
                   if (rangeflag && !strcmp($<text_val>1,"false"))
                   {fprintf(StateCpointer,"\t\t\t\tif (!(%s))\n\t\t\t\t{\n",
                            helpcontainer[contindex]);}
                   }
                   |ABSTRDATATYPE
                   {
                   if (taskflag && !descflag)
                     fprintf(StateCpointer,"%s",$<text_val>1);
                   if (descflag && !rangeflag)
                     strcat(helpcontainer[contindex],$<text_val>1);
                   }
                   |qualstring 
                   |opapporcompprim 
                   |NUMBER  
                   {
                   if (taskflag)
                     {fprintf(StateCpointer,"%s",$<num_val>1);}
                   }
                   |specopapp 
                   |fieldprim 
                   |structprim 
                   |activeexpres 
                   |viewexpres 
                   |importexpres 
                   |NOW
                   {fprintf(StateCpointer,"now()");}
                   |SELF
                   {fprintf(StateCpointer,"System->self()");} 
                   |PARENT 
                   {fprintf(StateCpointer,"System->parent()");}
                   |OFFSPRING 
                   {fprintf(StateCpointer,"System->offspring()");}
                   |SENDER
                   {fprintf(StateCpointer,"System->sender()");} 
                   |ERROR 
                   |condexpres 
                   |LEFTPAR dummypar expres RIGHTPAR 
                   {if (taskflag)
                     {fprintf(StateCpointer,")");}
                   }
                   ;

dummypar           :/* Optional leer */
                   {
                   if (taskflag)
                     {fprintf(StateCpointer,"(");}
                   }

opapporcompprim    :primary dummyopapp LEFTPAR expreslst RIGHTPAR 
                   {
                   if(taskflag && !descflag)
                     fprintf(StateCpointer,")");
                   if (descflag && !rangeflag)
                     strcat(helpcontainer[contindex],")");
                   }
                   ;

dummyopapp         :/* Optional leer */
                   {
                   if (taskflag && !descflag)
                     fprintf(StateCpointer,"(");
                   if (descflag && !rangeflag)
                     strcat(helpcontainer[contindex],"(");
                   }
                   ;

specopapp       :primary EXCLAMATION LEFTPAR expreslst RIGHTPAR 
                ;
                

specopapp       :qualquotop LEFTPAR expreslst RIGHTPAR 
                ;
                
fieldprim       :primary EXCLAMATION NAME 
                ;
                
structprim      :LEFTPARPOINT expreslst RIGHTPARPOINT 
                |qual LEFTPARPOINT expreslst RIGHTPARPOINT 
                ;
                
activeexpres    :ACTIVE LEFTPAR id zeroexpreslst RIGHTPAR 
                ;
                
viewexpres      :VIEW LEFTPAR id RIGHTPAR 
                |VIEW LEFTPAR id COMMA expres RIGHTPAR 
                ;
                
importexpres    :IMPORT LEFTPAR id RIGHTPAR 
                |IMPORT LEFTPAR id COMMA expres RIGHTPAR 
                ;
                
condexpres      :IF expres THEN expres ELSE expres FI 
                ;
                
  
zeroexpreslst   :/* Optional leer */
                |LEFTPAR expreslst RIGHTPAR 
                ;
                
expreslst       :expres 
                |expreslst COMMA dummyexpreslst expres 
                ;
                
dummyexpreslst  :/* Optional leer */
                {
                if(descflag && !rangeflag)
                  strcat(helpcontainer[contindex],",");
                if (taskflag && !descflag)
                  fprintf(StateCpointer,",");
                }
                ;
 
term            :term0 
                |term IMPLY term0 
                ;
                
term0           :term1 
                |term0 OR dummyor term1 
                |term0 XOR term1 
                ;
                
term1           :term2 
                |term1 AND dummyand term2 
                ;
                
term2           :term3 
                |term2 relop term3 
                |term2 IN term3 
                ;
                
term3           :term4 
                |term3 PLUS term4 
                |term3 MINUS term4 
                |term3 CONC term4 
                ;
                
term4           :term5 
                |term4 ASTERISK term5 
                |term4 SLASH term5 
                |term4 MOD term5 
                |term4 REM term5 
                ;
                
term5           :primterm 
                |MINUS primterm 
                |NOT dummynot primterm 
                ;
                
primterm        :id 
                |qualstring 
                |id LEFTPAR termlst RIGHTPAR 
                |id EXCLAMATION LEFTPAR termlst RIGHTPAR 
                |qualquotop LEFTPAR termlst RIGHTPAR 
                |IF term THEN term ELSE term FI 
                |ERROR EXCLAMATION 
                |SPELLING LEFTPAR id RIGHTPAR 
                |LEFTPAR term RIGHTPAR 
                ;
     
termlst         :term 
                |termlst COMMA term 
                ;

/*-------------------------- Identifikatoren ----------------------------*/
                
zeroidlst       :zeroid 
                |zeroidlst COMMA zeroid 
                ;
                
idlst           :id 
                |idlst COMMA id 
                ;
                
idwordlst       :idword 
                |idwordlst COMMA idword 
                ;
                
idwordlst1      :idword1 
                |idwordlst1 COMMA idword1 
                ;
                
zeroid          :/* Optional leer */
                |id 
                ;
                
id              :NAME 
                {
                if (connect && signroute)
                {
                    if (!RouteExist($<text_val>1) || Firstsignroute)
                      {SignalrouteEntry($<text_val>1);}
                    SearchRoute($<text_val>1);
                    signrouteAKT->connectpoint = channelAKT;
                    /* connect = FALSE;*/
                }
                }
                |qual NAME 
                |TYPEDEFI
                {
                if (varflag)
                  {processAKT->varlstbegin->vartype = $<text_val>1;}
                }
                ;
                
idword          :nmword 
                |qual nmword 
                ;

id1             :NAME 
                {dummy = $<text_val>1;}
                /*|qual1 NAME */
                ;
                
idword1         :nmword 
                |qual1 nmword 
                ;

id2             :NAME 
                {dummy = $<text_val>1;}
                |qual2 NAME 
                ;
                
qualstring      :STRING 
                |qual STRING 
                ;
                
qualquotop      :quotopnm 
                |qual quotopnm 
                ;
                
qual            :qualitemlst 
                |LTLT qualitemlst GTGT 
                ;
                
qual1           :qualitemlst1 
                |LTLT qualitemlst GTGT 
                ;
                
qual2           :qualitemlst2 
                |LTLT qualitemlst GTGT 
                ;
               
qualitemlst     :qualitem 
                |qualitemlst SLASH qualitem 
                ;
                
qualitemlst1    :qualitem1 
                |qualitemlst1 SLASH qualitem1 
                ;
                
qualitemlst2    :qualitem2 
                |qualitemlst2 SLASH qualitem2 
                ;
                
qualitem        :normqualitem 
                |prtyqualitem 
                |operqualitem 
                ;
                
qualitem1       :normqualitem 
                |operqualitem 
                ;
                
qualitem2       :normqualitem 
                |prtyqualitem 
                ;
                
normqualitem    :normscukind nmword 
                ;
                
prtyqualitem    :prtyscukind nmword 
                ;
                
operqualitem    :operscukind nmword 
                |operscukind nmword EXCLAMATION 
                |operscukind quotopnm 
                ;
                
normscukind     :SYSTEM 
                |BLOCK 
                |BLOCK TYPE 
                |PROCESS 
                |PROCESS TYPE 
                |SERVICE 
                |SERVICE TYPE 
                |SUBSTRUCTURE 
                |SIGNAL 
                ;
                
prtyscukind     :PROCEDURE 
                |TYPE 
                ;
                
operscukind     :OPERATOR 
                ;
                
nmlst           :NAME 
                {dummy = $<text_val>1;}
                |nmlst COMMA NAME 
                ;
                
nmwordlst       :nmword 
                |nmwordlst COMMA nmword 
                ;
                
zeronm          :/* Optional leer */
                |NAME 
                {dummy = $<text_val>1;}
                ;

nmword          :NAME          
                {dummy = $<text_val>1;}
                ;

opnm            :NAME 
                {dummy = $<text_val>1;}
                |NAME EXCLAMATION 
                {dummy = $<text_val>1;}
                |quotopnm 
                ;
                
quotopnm        :QUOTE opnm1 QUOTE 
                ;
                
opnm1           :IMPLY 
                |OR 
                |XOR
                |AND
                |IN 
                |relop
                |PLUS 
                |MINUS
                |CONC 
                |ASTERISK 
                |SLASH 
                |MOD 
                |REM 
                |NOT dummynot
                ;

/*---------------------------- Operatoren -------------------------------*/
                
relop           :EQUAL
                {
                if (descflag && !rangeflag)
                  strcat(helpcontainer[contindex]," == ");
                }
                |GT
                {
                if (descflag && !rangeflag)
                  strcat(helpcontainer[contindex]," > ");
                }
                |GE
                {
                if (descflag && !rangeflag)
                  strcat(helpcontainer[contindex]," >= ");
                }
                |LT  
                {
                if (descflag && !rangeflag)
                  strcat(helpcontainer[contindex]," < ");
                } 
                |LE 
                {
                if (descflag && !rangeflag)
                  strcat(helpcontainer[contindex]," <= ");
                }
                |NE 
                {
                if (descflag && !rangeflag)
                  strcat(helpcontainer[contindex]," != ");
                }
                ;
                
zeroend         :/* Optional leer */
                |end 
                ;
                
end             :SEMICOLON 
                |COMMENT STRING SEMICOLON 
                ;
                
%%                                      

/*---------------------------- Routinen ---------------------------------*/

void SignalrouteEntry(signroutenm)
char *signroutenm;
{
    signroutelist *srhelp;
    if (Firstsignroute == TRUE)
    {
        signroutelistbegin = (signroutelist *)malloc(sizeof(signroutelist));
        if(!signroutelistbegin)
        { 
            printf("Out of memory"); exit(1);
        }
        signroutelistbegin->name = signroutenm;
        signroutelistbegin->processpoint = NULL;
        signroutelistbegin->next = NULL;
        Firstsignroute = FALSE;
    }   
    else
    {
        srhelp = (signroutelist *)malloc(sizeof(signroutelist));
        srhelp->name = signroutenm;
        srhelp->processpoint = NULL;
        srhelp->next = signroutelistbegin->next;
        signroutelistbegin->next = srhelp;
    }
}/*End SignalrouteEntry*/


void LocalRouteEntry(signroutenm)
char *signroutenm;
{
    localsignroutelist *srhelp;
    if (Firstlocalsignroute == TRUE)
    {
        localsignroutelistbegin = 
            (localsignroutelist *)malloc(sizeof(localsignroutelist));
        localsignroutelistbegin->name = signroutenm;
        localsignroutelistbegin->processpoint = NULL;
        localsignroutelistbegin->next = NULL;
        localsignroutelistbegin->connectpoint = NULL;
        Firstlocalsignroute = FALSE;
    }   
    else
    {
        srhelp = (localsignroutelist *)malloc(sizeof(localsignroutelist));
        srhelp->name = signroutenm;
        srhelp->processpoint = NULL;
        srhelp->next = localsignroutelistbegin->next;
        localsignroutelistbegin->connectpoint = NULL;
        localsignroutelistbegin->next = srhelp;
    }
}/*End LocalRouteEntry*/


void GlobalsignalEntry(glsignnm)
char *glsignnm;
{
    globalsignallist *gshelp;
    if (Firstglobalsignal == TRUE)
    {
        globalsignallistbegin = 
            (globalsignallist *)malloc(sizeof(globalsignallist));
        globalsignallistbegin->name = glsignnm;
        globalsignallistbegin->chanpoint = NULL;
        globalsignallistbegin->startblock = NULL;
        globalsignallistbegin->endblock = NULL;
        globalsignallistbegin->startroute = NULL;
        globalsignallistbegin->endroute = NULL;
        globalsignallistbegin->next = NULL;
        globalsignaljustnew = globalsignallistbegin;
        Firstglobalsignal = FALSE;
    }   
    else
    {
        gshelp = (globalsignallist *)malloc(sizeof(globalsignallist));
        gshelp->name = glsignnm;
        gshelp->chanpoint = NULL;
        gshelp->startblock = NULL;
        gshelp->endblock = NULL;  
        gshelp->startroute = NULL;
        gshelp->endroute = NULL;
        globalsignaljustnew = gshelp;
        gshelp->next = globalsignallistbegin->next;
        globalsignallistbegin->next = gshelp;
    }
}/*End GlobalsignalEntry*/


void ChannelEntry(channm)
char *channm;
{
    channellist *chhelp; 
    if (Firstchannel == TRUE)
    {
        channellistbegin = (channellist *)malloc(sizeof(channellist));
        channellistbegin->name = channm;
        strcpy(channellistbegin->biname,"default");
        channellistbegin->startroute = NULL;
        channellistbegin->endroute = NULL;
        channellistbegin->next = NULL;
        channeljustnew = channellistbegin;
        Firstchannel = FALSE;
    }   
    else
    {
        chhelp = (channellist *)malloc(sizeof(channellist));
        chhelp->name = channm;
        strcpy(chhelp->biname,"default");
        chhelp->startroute = NULL;
        chhelp->endroute = NULL;
        chhelp->next = channellistbegin->next;
        channeljustnew = chhelp;
        channellistbegin->next = chhelp;
   }
}/*End ChannelEntry*/


void ProcessEntry2(prcssnm,index)
char *prcssnm;
int index;
{
    processlist2 *prcsshelp; 
    if (Firstprocess2 == TRUE)
    {
        processlistbegin2 = (processlist2 *)malloc(sizeof(processlist2));
        processlistbegin2->name = prcssnm;
        processlistbegin2->timerexist = "FALSE";
        processlistbegin2->saveexist = "FALSE";
        processlistbegin2->processtype = index;
        processlistbegin2->next = NULL;
        Firstprocess2 = FALSE;
    }   
    else
    {
        prcsshelp = (processlist2 *)malloc(sizeof(processlist2));
        prcsshelp->name = prcssnm;
        prcsshelp->processtype = index;
        prcsshelp->timerexist = "FALSE";
        prcsshelp->saveexist = "FALSE";
        prcsshelp->next = processlistbegin2->next;
        processlistbegin2->next = prcsshelp;
    }
}/*End ProcessEntry2*/


void ProcessEntry(prssnm)
char *prssnm;
{
    processlist *processlistbegin;
    blockAKT->prsslstbegin = (processlist *)malloc(sizeof(processlist));
    if (blockAKT->Firstprocess == TRUE)
    { 
        blockAKT->prsslstbegin->name = prssnm;
        blockAKT->prsslstbegin->createlistbegin = NULL;
        blockAKT->prsslstbegin->EveryStateExist = FALSE;
        blockAKT->prsslstbegin->next = NULL;
        blockAKT->prsslstbegin->varlstbegin = NULL;
        blockAKT->Firstprocess = FALSE;
        prsshelp = blockAKT->prsslstbegin;
    }   
    else
    {
        blockAKT->prsslstbegin->name = prssnm;
        blockAKT->prsslstbegin->createlistbegin = NULL;
        blockAKT->prsslstbegin->EveryStateExist = FALSE;
        blockAKT->prsslstbegin->next = prsshelp;
        blockAKT->prsslstbegin->varlstbegin = NULL;
        prsshelp = blockAKT->prsslstbegin;
    }
}/*End ProcessEntry*/


void LocalsignalEntry(locsignm)
char *locsignm;
{
    localsignallist *localsignallistbegin,*locsighelp;
    if (blockAKT->Firstlocalsignal == TRUE)
    {
        blockAKT->loclstbegin = 
            (localsignallist *)malloc(sizeof(localsignallist));
        blockAKT->loclstbegin->name = locsignm;
        blockAKT->loclstbegin->next = NULL;
        blockAKT->Firstlocalsignal = FALSE;
    }   
    else
    {
        locsighelp = (localsignallist *)malloc(sizeof(localsignallist));
        locsighelp->name = locsignm;
        locsighelp->next = blockAKT->loclstbegin->next;
        blockAKT->loclstbegin->next = locsighelp;
    }
}/*End LocalsignalEntry*/


void VariableEntry(varnm)
char *varnm;
{
    variablelist *variablelistbegin;
    processAKT->varlstbegin = (variablelist *)malloc(sizeof(variablelist));
    if (processAKT->Firstvariable == TRUE)
    {
        processAKT->varlstbegin->name = varnm;
        processAKT->varlstbegin->next = NULL;
        processAKT->Firstvariable = FALSE;
        varhelp = processAKT->varlstbegin;
    }   
    else
    {
        processAKT->varlstbegin->name = varnm;
        processAKT->varlstbegin->next = varhelp;
        varhelp = processAKT->varlstbegin;
    }
}/*End VariableEntry*/


void StateEntry(statenm)
char *statenm;
{
    statelist *statehelp;
    if (processAKT->Firststate == TRUE)
    {
        processAKT->statelistbegin = (statelist *)malloc(sizeof(statelist));
        processAKT->statelistbegin->name = statenm;
        processAKT->statelistbegin->next = NULL;
        processAKT->Firststate = FALSE;
    }
    else
    {
        statehelp = (statelist *)malloc(sizeof(statelist));
        statehelp->name = statenm;
        statehelp->next = processAKT->statelistbegin->next;
        processAKT->statelistbegin->next = statehelp;
    }
}/* End StateEntry */


void CreateEntry(createnm)
char *createnm;
{
    createlist *createhelp,*createlistbegin;
    if (processAKT->Firstcreate == TRUE)
    {
        processAKT->createlistbegin = (createlist *)malloc(sizeof(createlist));
        processAKT->createlistbegin->name = createnm;
        processAKT->createlistbegin->next = NULL;
        processAKT->Firstcreate = FALSE;
    }
    else
    {
        createhelp = (createlist *)malloc(sizeof(createlist));
        createhelp->name = createnm;
        createhelp->next = processAKT->createlistbegin->next;
        processAKT->createlistbegin->next = createhelp;
    }
}/* End CreateEntry */


void TimerEntry(timenm)
char *timenm;
{
    timerlist *timerlstbegin;
    processAKT->timerlstbegin = (timerlist *)malloc(sizeof(timerlist));
    if (processAKT->Firsttimer == TRUE)
    {
        processAKT->timerlstbegin->name = timenm;
        processAKT->timerlstbegin->next = NULL;
        processAKT->Firsttimer = FALSE;
        timerhelp = processAKT->timerlstbegin;
    }   
    else
    {
        processAKT->timerlstbegin->name = timenm;
        processAKT->timerlstbegin->next = timerhelp;
        timerhelp = processAKT->timerlstbegin;
    }
}/*End TimerEntry*/


void ProcedureEntry(prcdnm)
char *prcdnm;
{
    procedurelist *procedurelistbegin;
    processAKT->prcdlstbegin = (procedurelist *)malloc(sizeof(procedurelist));
    if (processAKT->Firstprocedure == TRUE)
    {
        processAKT->prcdlstbegin->name = prcdnm;
        processAKT->prcdlstbegin->next = NULL;
        processAKT->Firstprocedure = FALSE;
        prcdhelp = processAKT->prcdlstbegin;
    }   
    else
    {
        processAKT->prcdlstbegin->name = prcdnm;
        processAKT->prcdlstbegin->next = prcdhelp;
        prcdhelp = processAKT->prcdlstbegin;
    }
}/*End ProcedureEntry*/


void BlockEntry(blocknm)
char *blocknm;
{
    blocklist *bhelp;
    if (Firstblock == TRUE)
    {
        blocklistbegin = (blocklist *)malloc(sizeof(blocklist));
        blocklistbegin->name = blocknm;
        blocklistbegin->pointer = NULL;
        blocklistbegin->prsslstbegin = NULL;
        blocklistbegin->loclstbegin = NULL;
        Firstblock = FALSE;
    }   
    else
    {
        bhelp = (blocklist *)malloc(sizeof(blocklist));
        bhelp->name = blocknm;
        bhelp->pointer = NULL;
        bhelp->prsslstbegin = NULL;
        bhelp->loclstbegin = NULL;
        bhelp->next = blocklistbegin->next;
        blocklistbegin->next = bhelp;
    }
}/*End BlockEntry*/


void AbstractEntry(absnm)
char *absnm;
{
    abstractlist *abshelp;
    if (Firstabstract == TRUE)
    {
        abstractlistbegin = (abstractlist *)malloc(sizeof(abstractlist));
        abstractlistbegin->name = absnm;
        abstractlistbegin->next = NULL;
        Firstabstract = FALSE;
    }   
    else
    {
        abshelp = (abstractlist *)malloc(sizeof(abstractlist));
        abshelp->name = absnm;
        abshelp->next = abstractlistbegin->next;
        abstractlistbegin->next = abshelp;
    }
}/*End AbstractEntry*/


void SearchLocal(searchnm)
char *searchnm;
{
    locAKT = blockAKT->loclstbegin;
    while(locAKT)
    {
        if (!strcmp(locAKT->name,searchnm))
        {
            return;
        }
        locAKT = blockAKT->loclstbegin->next;
    }
    printf("Local signal %s in block %s not found\n",searchnm,blockAKT->name);
    exit(1);
}/* End SearchLocal */


void SearchSignal(searchnm,searchpointer)
char *searchnm;
globalsignallist *searchpointer;
{
    globalsignalAKT = searchpointer;
    while(globalsignalAKT)
    {
        if (!strcmp(globalsignalAKT->name,searchnm))
        {
            return;
        }
        globalsignalAKT = globalsignalAKT->next;
    }
    notfound = TRUE;
    return;
}/* End SearchSignal */


void SearchRoute(searchnm)
char *searchnm;
{
    signrouteAKT = signroutelistbegin;
    while(signrouteAKT)
    {
        if (!strcmp(signrouteAKT->name,searchnm))
        {
           return;
        }
        signrouteAKT = signrouteAKT->next;
    }
}/* End SearchRoute */


void SearchLocalRoute(searchnm)
char *searchnm;
{
    localsignrouteAKT = localsignroutelistbegin;
    while(localsignrouteAKT)
    {
        if (!strcmp(localsignrouteAKT->name,searchnm))
        {
           return;
        }
        localsignrouteAKT = localsignrouteAKT->next;
    }
    printf("Local signalroute %s not found.\n",searchnm);
    exit(1);
}/* End SearchLocalRoute */


void SearchChannel(searchnm)
char *searchnm;
{
    channelAKT = channellistbegin;
    while(channelAKT)
    {
        if (!strcmp(channelAKT->name,searchnm))
        {
            return;
        }
        channelAKT = channelAKT->next;
    }
    return;
}/* End SearchChannel */


int BlockExist(existnm)
char *existnm;
{
    blockAKT = blocklistbegin;
    while(blockAKT)
    {
        if (!strcmp(blockAKT->name,existnm))
        {
            return(TRUE);
        }
        blockAKT = blockAKT->next;
    }
    return(FALSE);
}/* End BlockExist */


int TimerExist(existnm)
char *existnm;
{
    timerAKT = processAKT->timerlstbegin;
    while(timerAKT)
    {
        if (!strcmp(timerAKT->name,existnm))
        {
            return(TRUE);
        }
        timerAKT = timerAKT->next;
    }
    return(FALSE);
}/* End TimerExist */


int ProcessExist(existnm)
char *existnm;
{
    processlist2 *processfind;
    processfind = processlistbegin2;
    while(processfind)
    {
        if(!strcmp(processfind->name,existnm))
        {
            processAKT = processfind;
            return(TRUE);
        }
        processfind = processfind->next;
    }
    return(FALSE);
}/* End ProcessExist */


int RouteExist(existnm)
char *existnm;
{
    signrouteAKT = signroutelistbegin;
    while(signrouteAKT)
    {
        if (!strcmp(signrouteAKT->name,existnm))
        {
            return(TRUE);
        }
        signrouteAKT = signrouteAKT->next;
    }
    return(FALSE);
}/* End RouteExist */


void SearchBlock(searchnm)
char *searchnm;
{
    blockAKT = blocklistbegin;
    while(blockAKT)
    {
        if (!strcmp(blockAKT->name,searchnm))
        {
           return;
        }
        blockAKT = blockAKT->next;
    }
    return;
}/* End SearchBlock */


void SearchProcess2(searchnm)
char *searchnm;
{
    process2AKT = processlistbegin2;
    while(process2AKT)
    {
        if (!strcmp(process2AKT->name,searchnm))
        {
            return;
        }
        process2AKT = process2AKT->next;
    }
    printf("Process: %s not found. \n",searchnm);
    exit(1);
}/* End SearchProcess2 */


void SearchProcess(searchnm)
char *searchnm;
{
    blockAKT = blocklistbegin;
    while(blockAKT)
    {
        processAKT = blockAKT->prsslstbegin;
        while(processAKT)
        {
            if (!strcmp(processAKT->name,searchnm))
            {
                return;
            }
            processAKT = processAKT->next;
        }
        blockAKT = blockAKT->next;
    }
    return;
}/*End SearchProcess */


void SignalCheck(ch,checkname,loccheck,globcheck)
int ch;
char *checkname;
localsignallist *loccheck;
globalsignallist *globcheck;
{
    switch(ch) {
    case 1:{  
               while(globcheck)
               {
                   if(!strcmp(globcheck->name,checkname))
                     {return;}
                   globcheck = globcheck->next;
               }
               while(loccheck)
               {
                   if(!strcmp(loccheck->name,checkname))
                     {return;}
                   loccheck = loccheck->next;
               }
               printf("\n---syntax error---\n");
               printf("Block:  %s %s %s %s %s %s",blockAKT->name,
                      "\nProcess:",processAKT->name,"\nSignalname:"
                      ,checkname,"\n\n");
               exit(1);
           }
    case 2:{ 
               while(globcheck)
               {
                   if(!strcmp(globcheck->name,checkname))
                     {return;}
                   globcheck = globcheck->next;
               } 
               printf("\n---syntax error---\n");
               printf("Systemdeclaration   %s  %s %s %s %s","\nChannel:",
                      channellistbegin->name,"\nSignalname:",checkname,"\n\n");
               exit(1);
           }
    }
}/* End SignalCheck */


void FileChannel(sysnm)
char *sysnm;
{ 
    channellist *chanfilepointer;
    char chanfilename[80];
    chanfilepointer = channellistbegin;
    strcpy(chanfilename,"SDLSystem_");
    strcat(chanfilename,sysnm);
    strcat(chanfilename,"_Channels.h");
    Chanpointer = fopen(chanfilename,"w");
    fprintf(Chanpointer,"/*--- channel declaration for SDL system %s---*/\n\n",
            sysnm);
    fprintf(Chanpointer,"#ifndef __SDLSystem_%s_Channel_h \n", sysnm);
    fprintf(Chanpointer,"#define __SDLSystem_%s_Channel_h \n\n", sysnm);
    fprintf(Chanpointer,"enum System_Channel \n{ \n");
    number_of_channels = 0;
    if(chanfilepointer)
    {
        fprintf(Chanpointer,"   %s = 1, \n",chanfilepointer->name);
        chanfilepointer = chanfilepointer->next;
    }
    while(chanfilepointer)
    {
        number_of_channels = number_of_channels+1;
        if (!strcmp(chanfilepointer->biname,"default"))
          {fprintf(Chanpointer,"   %s, \n",chanfilepointer->name);}
        else
          {fprintf(Chanpointer,"   %s, \n",chanfilepointer->biname);}
        chanfilepointer = chanfilepointer->next;
    } 
    fprintf(Chanpointer,"   End_of_Channellist\n}; \n\n");
    fprintf(Chanpointer,"#endif /* __SDLSystem_%s_Channel_h */", sysnm);
    fclose(Chanpointer);   
}/* End FileChannel */


void FileTimer(sysnm)
char *sysnm;
{
    blocklist *blocktimer;
    processlist *prsslsthelp;
    timerlist *timerlsthelp;
    char filename[80];
    blocktimer = blocklistbegin;
    strcpy(filename,"SDLSystem_");
    strcat(filename,sysnm);
    strcat(filename,"_Timers.h");
    Timerpointer = fopen(filename,"w");
    fprintf(Timerpointer,"/*--- timer declaration for SDL system %s ---*/\n\n",
            sysnm);
    fprintf(Timerpointer,"#ifndef __SDLSystem_%s_Timers_h\n", sysnm);
    fprintf(Timerpointer,"#define __SDLSystem_%s_Timers_h\n", sysnm);
    fprintf(Timerpointer,"#include\"SDLSystem_%s_Signals.h\"\n\n", sysnm);
    fprintf(Timerpointer,"enum System_%s_Timers\n{\n", sysnm);
    while(blocktimer)
    {
        prsslsthelp = blocktimer->prsslstbegin;
        while(prsslsthelp)
        {
            timerlsthelp = prsslsthelp->timerlstbegin;
            while(timerlsthelp)
            {
                if (firsttimer)
                {
                    fprintf(Timerpointer,"\t%s=End_of_Signallist+1,\n",
                    timerlsthelp->name);
                    firsttimer = FALSE;
                }
                else
                {
                    fprintf(Timerpointer,"\t%s,\n",timerlsthelp->name);
                }
                timerlsthelp = timerlsthelp->next;
            }
            prsslsthelp = prsslsthelp->next;
        }
        blocktimer = blocktimer->next;
    }
    fprintf(Timerpointer,"\tEnd_of_Timerlist\n};\n\n");
    fprintf(Timerpointer,"#endif /*__SDLSystem_%s_Timers_h */",sysnm);
    fclose(Timerpointer);
}/*End FileTimer*/


void FileSignal(sysnm)
char *sysnm;
{
    globalsignallist *globfilepointer;
    localsignallist *locfilepointer;
    blocklist *blockfilepointer;
    char signfilename[80];
    blockfilepointer = blocklistbegin; 
    globfilepointer = globalsignallistbegin;
    strcpy(signfilename,"SDLSystem_");
    strcat(signfilename,sysnm);
    strcat(signfilename,"_Signals.h");
    Signalpointer = fopen(signfilename,"w");
    fprintf(Signalpointer,"/*--- signal declaration for SDL system %s ---*/\n\n",
            sysnm);
    fprintf(Signalpointer,"#ifndef __SDLSystem_%s_Signals_h \n", sysnm);
    fprintf(Signalpointer,"#define __SDLSystem_%s_Signals_h\n\n", sysnm);
    fprintf(Signalpointer,"enum System_%s_Signals \n{ \n   INIT=0,\n",sysnm);
    number_of_signals = 0;
    while(globfilepointer)
    {
        number_of_signals = number_of_signals+1;
        fprintf(Signalpointer,"   %s, \n",globfilepointer->name);
        globfilepointer = globfilepointer->next;
    }
    while(blockfilepointer)
    {
        locfilepointer = blockfilepointer->loclstbegin;
        while(locfilepointer)
        {
            number_of_signals = number_of_signals+1;
            fprintf(Signalpointer,"   %s, \n",locfilepointer->name);
            locfilepointer = locfilepointer->next;
        }
        blockfilepointer = blockfilepointer->next;
    }
    fprintf(Signalpointer,"   End_of_Signallist\n}; \n\n");
    fprintf(Signalpointer,"#endif /* __SDLSystem_%s_Signals_h */",sysnm);
    fclose(Signalpointer);
}/* End FileSignal */ 


void FileType(sysnm)
char *sysnm;
{
    char typefilename[80];
    strcpy(typefilename,"SDLSystem_");
    strcat(typefilename,sysnm);
    strcat(typefilename,"_Types.h");
    Typedefipointer = fopen(typefilename,"w");
    fprintf(Typedefipointer,"#ifndef __SDLSystem_%s_Types_h \n",sysnm);
    fprintf(Typedefipointer,"#define __SDLSystem_%s_Types_h \n\n",sysnm);
}/* End FileType */


void FilePType(prcssnm)
char *prcssnm;
{
    char filename[80];
    strcpy(filename,"SDLProcess_");
    strcat(filename,prcssnm);
    strcat(filename,"_Types.h");
    TypedefiPpointer = fopen(filename,"w");
    fprintf(TypedefiPpointer,"#ifndef __SDLProcess_%s_Types_h\n",prcssnm);
    fprintf(TypedefiPpointer,"#define __SDLProcess_%s_Types_h\n\n",prcssnm);
}/* End FilePType */


void FilePTypeEnd(prcssnm)
char *prcssnm;
{
    fprintf(TypedefiPpointer,"\n#endif /* SDLProcess_%s_Types_h */\n",prcssnm);
    fclose(TypedefiPpointer);
}/* End FilePTypeEnd */


void FileTypeEnd(sysnm)
char *sysnm;
{
    fprintf(Typedefipointer,"\n#endif /* SDLSystem_%s_Types_h */\n",sysnm);
    fclose(Typedefipointer);
}/* End FileTypeEnd */


void FileSystemCStart(sysnm)
char *sysnm;
{
    char filename[80];
    processlist2 *processfind;
    globalsignallist *sigglob;
    blocklist *blockfind;
    int i,j;
    strcpy(filename,"SDLSystem_");
    strcat(filename,sysnm);
    strcat(filename,".c");
    SystemCpointer = fopen(filename,"w");
    fprintf(SystemCpointer,"#include \"SDLSystem_%s.h\"\n\n", sysnm);
    fprintf(SystemCpointer,"SDLSystem_%s::SDLSystem_%s(int system,",
            sysnm, sysnm);
    fprintf(SystemCpointer," CNEventScheduler *sched, CNRandom *ch_rnd):\n");        
    fprintf(SystemCpointer,"CNSDLManager(system,processes,%d,signal_receiver,",
            processall+2);
    fprintf(SystemCpointer,"End_of_Signallist,channels,sched)\n\n");
    fprintf(SystemCpointer,"{\n\tsignal_receiver[0] = 0;\n");
    sigglob = globalsignallistbegin;
    while(sigglob)
    {
        fprintf(SystemCpointer,"\tsignal_receiver[%s] = %d;\n",
                sigglob->name,sigglob->endroute->processpoint->processtype);
        sigglob = sigglob->next;
    }
    blockfind = blocklistbegin;
    while(blockfind)
    {
        while(blockfind->loclstbegin)
        {
            fprintf(SystemCpointer,"\tsignal_receiver[%s] = %d;\n",
                    blockfind->loclstbegin->name,
                    blockfind->loclstbegin->endprocess->processtype);
            blockfind->loclstbegin = blockfind->loclstbegin->next;
        }
        blockfind = blockfind->next;
    }
    fprintf(SystemCpointer,"\nif (!ch_rnd) {");
    fprintf(SystemCpointer,"\n\tbase_generator = new CNFiboG;\n");
    fprintf(SystemCpointer,"\tdefault_random_generator =\n\t\t");
    fprintf(SystemCpointer,"\tnew CNNormal(1.0, 1.0, base_generator);\n}\n");
    fprintf(SystemCpointer,"else\n\tdefault_random_generator = ch_rnd;\n\n");
    fprintf(SystemCpointer,"for (int i = 0; i < End_of_Channellist; i++)\n");
    fprintf(SystemCpointer,"{\n\tchannels[i] = new CNSDLChannel;\n");
    fprintf(SystemCpointer,"\tchannels[i]->rnd_delay = default_random_generator;");
    fprintf(SystemCpointer,"\n\tchannels[i]->last_arrival = 0.0;\n}\n");
    processfind = processlistbegin2;
    i=2;
    while(processfind)
    {
        j=1;
        if (!strcmp(processfind->name,"environment"))
        {
            fprintf(SystemCpointer,"\nprocesses[1] = CNSDLEnvironment");
            fprintf(SystemCpointer,"::pointer_to_environment_data;\n\n");
            processfind = processfind->next;
        }
        fprintf(SystemCpointer,"processes[%d] = new CNSDLProcessData",i);
        fprintf(SystemCpointer,"(%d,%d,%d,%s,%s);\n",i,
                processfind->processtype,processfind->processmaxnumber,
                processfind->saveexist,processfind->timerexist);
        if (processfind->atbeginnumber>0)
        {
            fprintf(SystemCpointer,
                    "create(new SDLProcess_%s", processfind->name);
            fprintf(SystemCpointer,"(\"%s\",this,%d),%d);\n",processfind->name,
                    processfind->processtype,i);
        }
        if (processfind->processmaxnumber > 1)
        {
            for (j=2;j<=processfind->processmaxnumber;j++)
            {
                i = i+1;
                fprintf(SystemCpointer,"\tprocesse[%d] =", i);
                fprintf(SystemCpointer,
                        " new CNSDLProcessData(%d,%d,%d,%s,%s);\n",
                        i,processfind->processtype,
                        processfind->processmaxnumber,processfind->saveexist,
                        processfind->timerexist);
                if (processfind->atbeginnumber>=j)
                {
                    fprintf(SystemCpointer,
                            "create(new SDLProcess_%s", processfind->name);
                    fprintf(SystemCpointer,"(\"%s\",this,%d),%d);\n",
                            processfind->name, processfind->processtype,i);
                }                                                        
            }
        }
        i = i+1;
        processfind = processfind->next;
    }

    fprintf(SystemCpointer,"\n}\n\n/***** Default I/O member function for");
    fprintf(SystemCpointer," CNCL classes **************************/\n\n");
    fprintf(SystemCpointer,"// Normal output\nvoid SDLSystem_%s", sysnm); 
    fprintf(SystemCpointer,"::print(ostream &strm) const\n{\n\tstrm");
    fprintf(SystemCpointer," << \"...\" << endl;\n}\n\n");
    fprintf(SystemCpointer,"// Debug output\nvoid SDLSystem_%s", sysnm);
    fprintf(SystemCpointer,"::dump(ostream &strm) const\n{\n\tstrm");
    fprintf(SystemCpointer," << \"SDLSystem_%s { $Revision$ ...\"\n\t<<", sysnm);
    fprintf(SystemCpointer," \" }\" << endl;\n}\n\n");
    fprintf(SystemCpointer,"/***** CNCL stuff for type information");
    fprintf(SystemCpointer," ***************************************/\n\n");
    fprintf(SystemCpointer,"// Describing object for class SDLSystem_%s\n",
            sysnm);
    fprintf(SystemCpointer,"static CNClass SDLSystem_%s_desc(\"SDLSystem_%s",
            sysnm, sysnm);
    fprintf(SystemCpointer,"\", \"$Revision$\",\n");
    fprintf(SystemCpointer,"\t\t\tSDLSystem_%s::new_object);\n\n", sysnm);
    fprintf(SystemCpointer,"// \"Type\" for type checking functions\n");
    fprintf(SystemCpointer,"CNClassDesc CN_SDLSYSTEM_%s = &SDLSystem_%s_desc;",
            sysnm,sysnm);
    fclose(SystemCpointer);
}/* End FileSystemCStart */


void FileProcessCStart(prcssnm)
char *prcssnm;
{
    char filename[80];
    strcpy(filename,"SDLProcess_");
    strcat(filename,prcssnm);
    strcat(filename,".c");
    ProcessCpointer = fopen(filename,"w");
    fprintf(ProcessCpointer,"#include \"SDLProcess_%s.h\"\n\nSDLProcess_%s",
            prcssnm, prcssnm);
    fprintf(ProcessCpointer,"::SDLProcess_%s(char *name,CNSDLManager *system,",
            prcssnm);
    fprintf(ProcessCpointer," int process_type):CNSDLProcess(name, system,");
    fprintf(ProcessCpointer," process_type)\n{}\n\n\nvirtual int");
    fprintf(ProcessCpointer," SDLProcess_%s::process(int signal)\n{", prcssnm);
    fclose(ProcessCpointer);
}/* End FileProcessCStart */


void FileProcessCEnd(prcssnm)
char *prcssnm;
{
    char filename[80];
    strcpy(filename,"SDLProcess_");
    strcat(filename,prcssnm);
    strcat(filename,".c");
    fclose(ProcessCpointer);
    ProcessCpointer = fopen(filename,"a");
    fprintf(ProcessCpointer,"\n\t\t\t\tdefault: return 0;\n\t\t\t}\n\n");
    fprintf(ProcessCpointer,"\tdefault: error(\"illegal state\");\n");
    fprintf(ProcessCpointer,"\t\t\treturn 0;\n\t}\n}\n\n\n");

    fprintf(ProcessCpointer,"/***** Default I/O member function for CNCL");
    fprintf(ProcessCpointer," classes **************************/\n\n");
    fprintf(ProcessCpointer,"// Normal output\nvoid SDLProcess_%s", prcssnm);
    fprintf(ProcessCpointer,"::print(ostream &strm) const\n{\n\tstrm <<");
    fprintf(ProcessCpointer," \"...\" << endl;\n}\n\n");
    fprintf(ProcessCpointer,"// Debug output\nvoid SDLProcess_%s", prcssnm);
    fprintf(ProcessCpointer,"::dump(ostream &strm) const\n{\n\tstrm <<");
    fprintf(ProcessCpointer," \"SDLProcess_%s { $Revision$ ...\"\n", prcssnm);
    fprintf(ProcessCpointer,"\t<< \" }\" << endl;\n}\n\n");
    fprintf(ProcessCpointer,"/***** CNCL stuff for type information");
    fprintf(ProcessCpointer," ***************************************/\n\n");
    fprintf(ProcessCpointer,"// Describing object for class SDLProcess_%s",
            prcssnm);
    fprintf(ProcessCpointer,"\nstatic CNClass SDLProcess_%s_desc", prcssnm);
    fprintf(ProcessCpointer,"(\"SDLProcess_%s\", \"$Revision$\",\n\t\t\t", 
            prcssnm);
    fprintf(ProcessCpointer,"SDLProcess_%s::new_object);\n\n", prcssnm);
    fprintf(ProcessCpointer,"// \"Type\" for type checking functions\n");
    fprintf(ProcessCpointer,"CNClassDesc CN_SDLPROCESS_%s =", prcssnm);
    fprintf(ProcessCpointer," &SDLProcess_%s_desc;", prcssnm);
    fclose(ProcessCpointer);
}


void FileSystemH(sysnm)
char *sysnm;
{
    char filename[80];
    abstractlist *abstracthelp;
    processlist2 *processfind;
    processfind = processlistbegin2;
    strcpy(filename,"SDLSystem_");
    strcat(filename,sysnm);
    strcat(filename,".h");
    Systempointer = fopen(filename,"w");
    fprintf(Systempointer,"#ifndef __SDLSystem_%s_h\n", sysnm);
    fprintf(Systempointer,"#define __SDLSystem_%s_h\n\n", sysnm);
    fprintf(Systempointer,"#include <CNCL/Class.h>\n#include <CNCL/Param.h>\n");
    fprintf(Systempointer,"\n#include <CNCL/SDLManager.h>\n");
    fprintf(Systempointer,"\n#include \"SDLSystem_%s_Signals.h\"\n", sysnm);
    fprintf(Systempointer,"#include \"SDLSystem_%s_Timers.h\"\n", sysnm);
    fprintf(Systempointer,"#include \"SDLSystem_%s_Channels.h\"\n", sysnm);
    fprintf(Systempointer,"#include \"SDLSystem_%s_ProcessTypes.h\"\n", sysnm);
    fprintf(Systempointer,"#include \"SDLSystem_%s_Types.h\"\n\n", sysnm);
    if (ProcessExist("environment"))
        fprintf(Systempointer,"#include <CNCL/SDLEnvironment.h>\n\n");
    if (includeflag)
    {
        abstracthelp = abstractlistbegin;
        while(abstracthelp)
        {
            fprintf(Systempointer,"#include \"%s\"\n",abstracthelp->name);
            abstracthelp = abstracthelp->next;
        }
    }
    while(processfind)
    {
        if (!strcmp(processfind->name,"environment"))
          {processfind = processfind->next;}
        fprintf(Systempointer,"#include \"SDLProcess_%s.h\"\n",
                processfind->name);
        processfind = processfind->next;
    } 
    fprintf(Systempointer,"\n#include <CNCL/FiboG.h>\n");
    fprintf(Systempointer,"#include <CNCL/Normal.h>\n\n");
    fprintf(Systempointer,"extern CNClassDesc CN_SDLSYSTEM_%s;\n\n", sysnm);
    fprintf(Systempointer,"/*\n * The class SDLSystem_%s\n */\n\n", sysnm);
    fprintf(Systempointer,"class SDLSystem_%s : public CNSDLManager\n", sysnm);
    fprintf(Systempointer,"{\npublic:\n\n // Private members\nprivate:");
    fprintf(Systempointer,"\nCNSDLProcessData *processes [%d];\n",
            number_of_processes+2);
    fprintf(Systempointer,"CNSDLChannel *channels [End_of_Channellist];\n");
    fprintf(Systempointer,"ProcessType signal_receiver[End_of_Signallist];");
    fprintf(Systempointer,"\nCNRNG *base_generator;\n");
    fprintf(Systempointer,"CNRandom *default_random_generator;");
    fprintf(Systempointer,"\n\n/*--------- Constructors ---------*/\n");
    fprintf(Systempointer,"public:\nSDLSystem_%s() {};\n", sysnm);
    fprintf(Systempointer,"SDLSystem_%s(CNParam *param) {}\n\n", sysnm);
    fprintf(Systempointer,"SDLSystem_%s(int, CNEventScheduler*, ", sysnm);
    fprintf(Systempointer,"CNRandom* = NIL);\n\n"); 
    fprintf(Systempointer,"/***** Member functions required by CNCL ");
    fprintf(Systempointer,"*********************************/\npublic:\n");
    fprintf(Systempointer,"virtual CNClassDesc class_desc() const\n{\n");
    fprintf(Systempointer,"return CN_SDLSYSTEM_%s;\n};\n", sysnm);
    fprintf(Systempointer,"\nvirtual bool is_a(CNClassDesc desc) const\n{\n\t");
    fprintf(Systempointer,"return desc == CN_SDLSYSTEM_%s ? TRUE : ", sysnm);
    fprintf(Systempointer,"CNSDLManager::is_a(desc);\n};\n");
    fprintf(Systempointer,"\nstatic SDLSystem_%s *cast_from_object(", sysnm);
    fprintf(Systempointer,"CNObject *obj)\n{\n#ifdef NO_TYPE_CHECK\n");
    fprintf(Systempointer,"\treturn (SDLSystem_%s *)obj;\n", sysnm);
    fprintf(Systempointer,"#else\n\treturn (SDLSystem_%s *)( !obj || ", sysnm);
    fprintf(Systempointer,"obj->is_a(CN_SDLSYSTEM_%s)\n\t? obj : ", sysnm);
    fprintf(Systempointer,"fatal_type(obj->class_desc(), CN_SDLSYSTEM_%s) );\n",
            sysnm);
    fprintf(Systempointer,"#endif\n}\n");
    fprintf(Systempointer,"static CNObject *new_object(CNParam *param = NIL)");
    fprintf(Systempointer,"\n{ return param ? new SDLSystem_%s", sysnm);
    fprintf(Systempointer,"(param) : new SDLSystem_%s; }\n\n", sysnm);
    fprintf(Systempointer,"virtual void print (ostream &strm = cout) const;\n");
    fprintf(Systempointer,"virtual void dump (ostream &strm = cout) const;\n");
    fprintf(Systempointer,"};\n\n#endif /**SDLSystem_%s_h**/", sysnm);
    fclose(Systempointer);
}/* End FileSystemH */


void FileProcessH(prcssnm,sysnm)
char *sysnm,*prcssnm;
{
    char prcssfilename[80];
    statelist *statepoint;
    variablelist *varpoint;
    procedurelist *procedurefilepointer;
    strcpy(prcssfilename,"SDLProcess_");
    strcat(prcssfilename,prcssnm);
    strcat(prcssfilename,".h");
    statepoint = processAKT->statelistbegin;
    varpoint = processAKT->varlstbegin;
    procedurefilepointer = processAKT->prcdlstbegin;
    Processpointer = fopen(prcssfilename,"w");
    fprintf(Processpointer,"#ifndef __SDLProcess_%s_h\n", prcssnm);
    fprintf(Processpointer,"#define __SDLProcess_%s_h\n\n", prcssnm);
    while (processAKT->createlistbegin)
    {
        if (strcmp(processAKT->createlistbegin->name,prcssnm))
        {
            fprintf(Processpointer,"#include \"SDLProcess_%s.h\"\n",
                    processAKT->createlistbegin->name);
        }
        processAKT->createlistbegin = processAKT->createlistbegin->next;
    }
    fprintf(Processpointer,"#include <CNCL/Class.h>\n");
    fprintf(Processpointer,"#include <CNCL/Param.h>\n\n#include");
    fprintf(Processpointer," <CNCL/SDLProcess.h>\n\n#include");
    fprintf(Processpointer," \"SDLSystem_%s_Signals.h\"\n#include", sysnm);
    fprintf(Processpointer," \"SDLSystem_%s_Timers.h\"\n#include", sysnm);
    fprintf(Processpointer," \"SDLSystem_%s_Channels.h\"\n\n", sysnm);
    fprintf(Processpointer,"extern CNClassDesc CN_SDLPROCESS_%s;\n\n", prcssnm);
    fprintf(Processpointer,"/*\n * The class SDLProcess_%s\n */\n\n", prcssnm);
    fprintf(Processpointer,"class SDLProcess_%s : public CNSDLProcess\n",
            prcssnm);
    fprintf(Processpointer,"{\n\n // Private members\nprivate:");
    fprintf(Processpointer,"\n\n/*---- procedure declaration ----*/\n");
    fprintf(Processpointer,"virtual int process(int);\n");
    while(procedurefilepointer)
    {
        fprintf(Processpointer,"\tint %s();\n",procedurefilepointer->name);
        procedurefilepointer = procedurefilepointer->next;
    }
    fprintf(Processpointer,"\n\n/*---- process state declaration ----*/\n");
    fprintf(Processpointer,"enum states\n{\n\tINIT=0");
    while(statepoint)
    {
        fprintf(Processpointer,",\n\t%s",statepoint->name);
        statepoint = statepoint->next;
    }
    fprintf(Processpointer,"\n};\n\n/*---- local variable declaration ----*/\n");
    while(varpoint)
    {
        fprintf(Processpointer,"%s %s;\n",varpoint->vartype,varpoint->name);
        varpoint = varpoint->next;
    }
    fprintf(Processpointer,"\n\n/*--------- Constructors ---------*/\n");
    fprintf(Processpointer,"public:\nSDLProcess_%s() {}\n", prcssnm);
    fprintf(Processpointer,"SDLProcess_%s(CNParam *param) {}\n\n", prcssnm);
    fprintf(Processpointer,"SDLProcess_%s(char*, CNSDLManager*, int);\n\n",
            prcssnm);
    fprintf(Processpointer,"/***** Member functions required by CNCL ");
    fprintf(Processpointer,"*********************************/\npublic:\n");
    fprintf(Processpointer,"virtual CNClassDesc class_desc() const\n{\n");
    fprintf(Processpointer,"return CN_SDLPROCESS_%s;\n};\n", prcssnm);
    fprintf(Processpointer,"\nvirtual bool is_a(CNClassDesc desc) const\n");
    fprintf(Processpointer,"{\n\treturn desc == CN_SDLPROCESS_%s ?", prcssnm);
    fprintf(Processpointer," TRUE : CNSDLProcess::is_a(desc);\n};\n\n");
    fprintf(Processpointer,"static SDLProcess_%s *cast_from_object", prcssnm);
    fprintf(Processpointer,"(CNObject *obj)\n{\n#ifdef NO_TYPE_CHECK\n\t");
    fprintf(Processpointer,"return (SDLProcess_%s *)obj;\n", prcssnm);
    fprintf(Processpointer,"#else\n\treturn (SDLProcess_%s *)", prcssnm);
    fprintf(Processpointer,"( !obj || obj->is_a(CN_SDLPROCESS_%s)\n", prcssnm);
    fprintf(Processpointer,"\t\t? obj : fatal_type(obj->class_desc(),");
    fprintf(Processpointer,"CN_SDLPROCESS_%s) );\n#endif\n}\n\n", prcssnm);
    fprintf(Processpointer,"static CNObject *new_object(CNParam *param = NIL)");
    fprintf(Processpointer,"\n{ return param ? new SDLProcess_%s(", prcssnm);
    fprintf(Processpointer,"param) : new SDLProcess_%s; }\n\n", prcssnm);
    fprintf(Processpointer,"\nvirtual void print(ostream &strm = cout)");
    fprintf(Processpointer," const;\nvirtual void dump (ostream &strm= cout)");    
    fprintf(Processpointer," const;\n};\n\n#endif /**SDLProcess_%s_h**/",
            prcssnm);
    fclose(Processpointer);
}/* End FileProcessH */


void TempInit(void)
{
    char filename[80];
    strcpy(filename,"SDLProcess_");
    strcat(filename,processAKT->name);
    strcat(filename,".c");
    StateCpointer = fopen("INIT","r");
    ProcessCpointer = fopen(filename,"a");
    chh = fgetc(StateCpointer);
    while(chh !=EOF)
    {   
         chh = fgetc(StateCpointer);
         if (chh !=EOF)
           fputc(chh,ProcessCpointer);
    }
    fclose(StateCpointer);
    fclose(ProcessCpointer);
}/* End TempInit */


void TempState(statenm)
char *statenm;
{
    char filename[80];
    strcpy(filename,"SDLProcess_");
    strcat(filename,processAKT->name);
    strcat(filename,".c");
    StateCpointer = fopen(statenm,"r");
    ProcessCpointer = fopen(filename,"a");
    chh = fgetc(StateCpointer);
    while(chh !=EOF)
    {
        chh = fgetc(StateCpointer);
        if (chh !=EOF)
          fputc(chh,ProcessCpointer);
    }
    fclose(ProcessCpointer);
    fclose(StateCpointer);
}/* End TempState */


void FileRemove(void)
{
    statelist *statelisthelp;
    statelisthelp = processAKT->statelistbegin;
    while(statelisthelp)
    {
        if (remove(statelisthelp->name) == -1 )
        {
            printf("---- File deleting error : Filename is %s\n",
                   statelisthelp->name);
        }
        statelisthelp=statelisthelp->next;
    }
    if (remove("INIT")==-1)
      {printf("---- File deleting error: Filename INIT");}
    if (processAKT->EveryStateExist)
      if (remove("EveryState")==-1)
      {
           printf("\n---- File deleting error in Process %s.\n----",
                  processAKT->name);
           printf(" Filename is EveryState.\n--- You can ignore this error if");
           printf(" you have not used the \"*\" in a state symbol.\n");
      }
}


void FileProcessType(sysnm)
char *sysnm;
{
    processlist2 *processhelppointer;
    char filename[80];
    processhelppointer = processlistbegin2->next; 
    strcpy(filename,"SDLSystem_");
    strcat(filename,sysnm);
    strcat(filename,"_ProcessTypes.h");
    ProcessTypepointer = fopen(filename,"w");
    fprintf(ProcessTypepointer,"/*--- process type declaration for SDL system");
    fprintf(ProcessTypepointer," %s ---*/\n\n#ifndef", sysnm);
    fprintf(ProcessTypepointer," __SDLSystem_%s_ProcessType_h \n", sysnm);
    fprintf(ProcessTypepointer,"#define __SDLSystem_%s_ProcessType_h", sysnm);
    fprintf(ProcessTypepointer,"\n\nenum System_%s_ProcessType \n{ \n", sysnm);
    while (processhelppointer)
    {
        fprintf(ProcessTypepointer,"\t%s = %d,\n",
                processhelppointer->name,processhelppointer->processtype);
        processhelppointer = processhelppointer->next;
    }
    fprintf(ProcessTypepointer,"\tEnd_of_ProcessTypelist\n}; \n\n");
    fprintf(ProcessTypepointer,"#endif /* __SDLSystem_%s_ProcessType_h */",
            sysnm);
    fclose(ProcessTypepointer);
}/* End FileProcessType */


void FileMake(sysnm)
char *sysnm;
{
    processlist2 *processhelp;
    Makefilepointer = fopen("Makefileq","w");
    fprintf(Makefilepointer,"#\n# Verzeichnisse fuer Include-Dateien und ");
    fprintf(Makefilepointer,"Libraries\n#\nSDLDIR = \n\n");
    fprintf(Makefilepointer,"#\n# C++ Compiler und Optionen\n#\n");
    fprintf(Makefilepointer,"CC     = g++\nCFLAGS = -Wall -O2\n\n");
    fprintf(Makefilepointer,"#\n# Linker, Optionen und Libraries\n#\n");
    fprintf(Makefilepointer,"LD     = g++\nLFLAGS = -Wall -O2 -L$(SDLDIR)\n");
    fprintf(Makefilepointer,"LIBS   = -lcncl -lm\n\n");
    fprintf(Makefilepointer,"#\n# Regel zur Erzeugung von *.o Dateien aus ");
    fprintf(Makefilepointer,"*.c Dateien\n#\n\n.c.o:\n\t$(CC) $(CFLAGS) -c $<");
    fprintf(Makefilepointer,"\n\n#\n# Die Objektdateien\n#\nOBJS = ");
    processhelp = processlistbegin2;
    while (processhelp)
    {
        fprintf(Makefilepointer,"SDLProcess_%s.o ",processhelp->name);
        processhelp = processhelp->next;
    }
    fprintf(Makefilepointer,"SDLSystem_%s.o\n",sysnm);
    fprintf(Makefilepointer,"#\n# Programme\n#\nall: $(OBJS)\n\n");
    fprintf(Makefilepointer,"#\n# Objektdateien\n#\n");
    processhelp = processlistbegin2;
    while (processhelp)
    {
        fprintf(Makefilepointer,"SDLProcess_%s.o: SDLProcess_%s.c ",
                processhelp->name,processhelp->name);
        fprintf(Makefilepointer,"SDLProcess_%s.h\n", processhelp->name);
        processhelp = processhelp->next;
    }
    fprintf(Makefilepointer,"SDLSystem_%s.o: SDLSystem_%s.c SDLSystem_%s.h\n",
            sysnm,sysnm,sysnm);
    fprintf(Makefilepointer,"\n#\n# Diverses\n#\n\nclean:\n\trm -f core *.o");
    fprintf(Makefilepointer," *.bak *~\n\nveryclean:\n\trm -f core *.bak *~");
    fprintf(Makefilepointer," *.o \n");
}/* End FileMake */

/*-----------------------------------------------------------------------*/
/*---------------------Testprocedures------------------------------------*/

void SignalTest(testpointer,testpointer2,sysnm)
globalsignallist *testpointer;
blocklist *testpointer2;
char *sysnm;
{
    char filename[80];
    localsignallist *loclsthelp;
    strcpy(filename,"CHL_");
    strcat(filename,sysnm);
    strcat(filename,".connect");
    Connectpointer = fopen(filename,"w");
    fprintf(Connectpointer,"\n********* Global Signals *************\n\n");
    while(testpointer)
    { 
        fprintf(Connectpointer,"\n--- Signal: %s --- \nChannel: %s",
                testpointer->name,testpointer->chanpoint->name);
        fprintf(Connectpointer,"\nStartblock: %s \nEndblock: %s ",
                testpointer->startblock->name, testpointer->endblock->name);
        fprintf(Connectpointer,"\nStartroute: %s \nEndroute: %s ",
                testpointer->startroute->name,testpointer->endroute->name);
        fprintf(Connectpointer,"\nStartprocess: %s = %d\nEndprocess: %s ",
                testpointer->startroute->processpoint->name,
                testpointer->startroute->processpoint->processtype,
                testpointer->endroute->processpoint->name);                
        fprintf(Connectpointer,"= %d\n",
                testpointer->endroute->processpoint->processtype);
        testpointer = testpointer->next;
    }
    fprintf(Connectpointer,"\n\n********* Local Signals *************\n\n");
    while(testpointer2)
    {
       loclsthelp = testpointer2->loclstbegin;
       while(loclsthelp)
       {
           fprintf(Connectpointer,"--- Signal: %s --- \nBlock: %s \n",
                   loclsthelp->name,testpointer2->name);
           fprintf(Connectpointer,"Startroute: %s \nStartprocess: %s = %d ",
                   loclsthelp->routepoint->name,loclsthelp->startprocess->name,
                   loclsthelp->startprocess->processtype);
           fprintf(Connectpointer,"\nEndprocess: %s = %d \n\n",
                   loclsthelp->endprocess->name,
                   loclsthelp->endprocess->processtype);
           loclsthelp = loclsthelp->next;
       }
       testpointer2 = testpointer2->next;
    }
    fclose(Connectpointer);
}/* End SignalTest */


void BlockProcessTest(testpointer)
blocklist *testpointer;
{
    while(testpointer)
    {
        printf("Block: %s %s",testpointer->name,"\n");
        while(testpointer->prsslstbegin)
        {
            printf("Process: %s %s",testpointer->prsslstbegin->name,"\n");
            while(testpointer->prsslstbegin->varlstbegin)
            {
                printf("Variable: %s %s",
                       testpointer->prsslstbegin->varlstbegin->name,"\n");
                printf("Type: %s %s",
                       testpointer->prsslstbegin->varlstbegin->vartype,"\n");
                testpointer->prsslstbegin->varlstbegin = 
                    testpointer->prsslstbegin->varlstbegin->next;
            }
            while(testpointer->prsslstbegin->statelistbegin)
            {
                printf("State: %s %s",
                       testpointer->prsslstbegin->statelistbegin->name,"\n");
                testpointer->prsslstbegin->statelistbegin = 
                    testpointer->prsslstbegin->statelistbegin->next;
            }
            while(testpointer->prsslstbegin->prcdlstbegin)
            {
                printf("Procedure: %s %s",
                       testpointer->prsslstbegin->prcdlstbegin->name,"\n");
                testpointer->prsslstbegin->prcdlstbegin = 
                    testpointer->prsslstbegin->prcdlstbegin->next;
            }
            testpointer->prsslstbegin = testpointer->prsslstbegin->next;
        }
        while(testpointer->loclstbegin)
        {
            printf("Local Signal: %s %s",testpointer->loclstbegin->name,"\n");
            testpointer->loclstbegin = testpointer->loclstbegin->next;
        }
        testpointer = testpointer->next;
    }
}/*End BlockProcessTest*/


