#!/usr/global/bin/perl
#
# $Id: CNgenclass.pl,v 0.22 1994/07/22 09:20:03 cncl-adm Exp cncl-adm $
#
# Perl script to generate CNCL class from template files
#
$TEMPL_DIR  = "<INCDIR>/CNCL";
$TEMPL_NAME = "Template";

$local = 0;

require "getopts.pl";

&Getopts("lt:");

if($opt_t) {
    $TEMPL_DIR = $opt_t;
}

if($opt_l) {
    $local = 1;
}

if($#ARGV < 1) {
    print STDERR "usage: CNgenclass [-l] [-t template-dir] class-name base-name\n";
    exit 1;
}



$class   = $ARGV[0];
$base    = $ARGV[1];

$basen   = $base;    $basen   =~ s/^CN//;
$classn  = $class;   $classn  =~ s/^CN//;
$ucclass = $classn;  $ucclass =~ tr/[a-z]/[A-Z]/;

$baseh   = $local ? "\"$basen.h\"" : "<CNCL/$basen.h>";
$classh  = "$classn.h";

open(INH, "$TEMPL_DIR/$TEMPL_NAME.hP" )
    || die "CNCLgenclass: can't access $TEMPL_NAME.hP\n";
open(INC, "$TEMPL_DIR/$TEMPL_NAME.cP" )
    || die "CNCLgenclass: can't access $TEMPL_NAME.cP\n";

open(OUTH, ">$classn.h")
    || die "CNCLgenclass: can't open $classn.h\n";
open(OUTC, ">$classn.c")
    || die "CNCLgenclass: can't open $classn.c\n";


while(<INH>) {
    s/%/$/g;
    s/<CLASS>/$class/g;
    s/<BASE>/$base/g;
    s/<UCCLASS>/$ucclass/g;
    s/<BASEH>/$baseh/g;
    s/<CLASSH>/$classh/g;

    print OUTH $_;
}

while(<INC>) {
    s/%/$/g;
    s/<CLASS>/$class/g;
    s/<BASE>/$base/g;
    s/<UCCLASS>/$ucclass/g;
    s/<BASEH>/$baseh/g;
    s/<CLASSH>/$classh/g;

    print OUTC $_;
}

close(INH);
close(INC);
close(OUTH);
close(OUTC);
