// GMD - SET - L. Peters Vers. 2.1 - 6.9.93 
#ifndef _membership_h_
#define _membership_h_

/* definition of a membership function
*/
const int FIFO = 6;
const double DELTA = 0.2;
const double DELTA_A = 0.2;

struct Regel {
	int Groesse ;
	float *Rule ;
};

class Mfc {
public: 
	 float Rule;
	 float Mu;


// Initialisierung
	Mfc(){Co=10; K =1.0; Rule = 0.; Nr = 0; Mu = 0.001;}
	void Mfc_init(int C=10, float k1=1.){Co=C; K = k1; }
	void Mfc_Rule( float, int t = 1);
	double Mfc_Mu (double );
	void Mfc_print (void);
	float Mfc_prk(void);
// Operatoren 
	Mfc& operator = (const Mfc&);
	Mfc& operator &(Mfc&); // UND
	Mfc& operator |(Mfc&); // OR
	
	Mfc& operator <(double); // CUT
	Mfc& operator <( Mfc&);
	
	Mfc& operator ()( double); // Mu + Zeiger zurueck
	

// Funktionen	
protected:
	double (Mfc::*Glocke)(double);
									
private:
	int Nr;
	int Co;
	float K;

	double Mfc_m(double ); //Glocke
	double Mfc_l(double ); // Glocke links abgeschnitten
	double Mfc_r(double ); // Glocke rechts abgeschnitten

};


class Mfc_Array: public Mfc
{
public: 
	Mfc_Array();
//	Mfc_Array() { Mfc_Array(1); }
	// Mfc_Array(const int);
	~Mfc_Array(){delete Mat;}
	virtual	void Mfc_Array_init ( int,int*, float *, int = 0);
	void Mfc_Array_rule (int, double*, int * = 0);	
	void Mfc_Array_defrule ( int =0);
	int Mfc_Array_gr (void);
	double* Mfc_Array_mat ();
	int Mfc_Array_dim(void){ return Dim_zg;}
	void Mfc_Array_dimset (int i) { Dim_zg = i;}
	double  Defuz(void) ;
// Funktionen fuer Fuzzy

	virtual void Mfc_Array_print (void);
	float*  Mfc_Array_prregel(void);
	float*  Mfc_Array_prk(void);
	void    Mfc_Array_prmu(float*);
	virtual void Mfc_Array_mu (double *, double *);
	Mfc_Array& Mfc_Array_out(void);
	double DefOut(void); 
	double DefMaxOut(void);


//operatoren
	Mfc_Array& operator = (Mfc_Array&);
	Mfc& operator [] (int);
	Mfc_Array& operator & (Mfc_Array&);
 	Mfc_Array& operator | (Mfc_Array&);
	Mfc_Array& operator <( double *);	
	Mfc_Array& operator <( Mfc_Array &);
	virtual Mfc_Array& operator ()(double);
	 
protected:
	Mfc * Mat;
	int Groesse;
	int Dim_zg;
	int Def_typ;
	double (Mfc_Array::*Defuzzy)(void);

public:  double Out;
	 double *Coef;
// Funktionen


};

class Mfc_Loop: public Mfc_Array{
 protected:
	double *Loop;
	double *Loop_coef;
	double *Fifo;
	double *Verfolge;
	Mfc_Array *Ein;
	double DefOut(void);
	double DefMaxOut(void);
private: int Dim;
	 double Delta, Delta_a;
	
 public:
	Mfc_Loop();
	~Mfc_Loop();
	void Mfc_Array_print();
	double Defuz();

     	
	Mfc_Array& operator ()(double);
// Neu
	void Mfc_Loop_schleife ( double, double, int = FIFO);
	void Mfc_Loop_conpin (Mfc_Array&, double *);
	void Mfc_Loop_conchip( Mfc_Array&, Mfc_Array& );
	void Mfc_Loop_transfer();

};


#endif











