/* MAC STDWIN -- BASIC ROUTINES. */

#include "macwin.h"
#ifdef MPW
#include <Fonts.h>
#include <Menus.h>
#include <TextEdit.h>
#include <Dialogs.h>
#include <OSUtils.h>
#include <SegLoad.h>
#endif


/* GLOBAL DATA. */

			/* XXX choose less obvious names */
GrafPtr screen;		/* The Mac Window Manager's GrafPort */
TEXTATTR wattr;		/* Current or default text attributes */

static int def_left= LEFT;
static int def_top= TOP;
static int def_width, def_height;


/* INITIALIZATION AND TERMINATION. */

/* Initialization */

int std_open_hook();
STATIC pascal resume _ARGS((void));

/* Initialize, using and updating argc/argv: */
void
winitargs(pargc, pargv)
	int *pargc;
	char ***pargv;
{
	wargs(pargc, pargv);
	winit();
}

/* Initialize without touching argc/argv */
void
winit()
{
#ifndef NO_STDIO
	/* Tell the THINK C stdio library we have initialized already */
	Stdio_MacInit(TRUE);
#endif

#ifdef THINK_C
#ifndef THINK_C_3_0
	/* 
	   THINK C 4.0 may have done these initializations for us when
	   the application has already used the console in any way.
	   Doing them again is not a good idea.
	   The THINK library avoids initializing the world if it appears
	   that it has already been initialized, but in that case it
	   will only allow output (all input requests return EOF).
	   Thus, the application has two options:
	   - call winit() or winitargs() first, then use the console
	     only for (debugging) output; or
	   - print at least one character to stdout first, then
	     stdwin menu bar may not function properly.
	   From inspection of the THINK library source it appears that
	   when the console is initialized, stdin->std is cleared,
	   so the test below suffices to skip initializations.
	*/
	if (stdin->std)
#endif
#endif
	{
		MaxApplZone();
		InitGraf(&QD(thePort));
		InitFonts();
		InitWindows();
		TEInit();
		InitDialogs(resume);
		InitMenus();
		InitCursor();
		setup_menus();
	}
	GetWMgrPort(&screen);
	initwattr();
#ifdef MPW
	set_open_hook(std_open_hook);
#endif
	wsetdefwinsize(0, 0);
	set_watch();
}

void
wdone()
{
}

void
wgetscrsize(pwidth, pheight)
	int *pwidth, *pheight;
{
	Rect r;
	r= screen->portRect;
	*pwidth= r.right - r.left;
	*pheight= r.bottom - r.top;
}

void
wgetscrmm(pmmwidth, pmmheight)
	int *pmmwidth, *pmmheight;
{
	Rect r;
	r= screen->portRect;
	/* XXX Three pixels/mm is an approximation of the truth at most */
	*pmmwidth= (r.right - r.left) / 3;
	*pmmheight= (r.bottom - r.top) / 3;
}

/* Routine called by "Resume" button in bomb box (passed to InitDialogs).
   I have yet to see a program crash where an attempted exit to the
   Finder caused any harm, so I think it's safe.
   Anyway, it's tremendously useful during debugging. */

static pascal
resume()
{
	ExitToShell();
}

/* WINDOWS. */

/* Find the WINDOW pointer corresponding to a WindowPtr. */

WINDOW *
whichwin(w)
	WindowPtr w;
{
	if (((WindowPeek)w)->windowKind < userKind)
		return NULL; /* Not an application-created window */
	else {
		WINDOW *win;
		
		win= (WINDOW *) GetWRefCon(w);
		if (win != NULL && win->w == w)
			return win;
		else
			return NULL;
	}
}

WINDOW *
wopen(title, drawproc)
	char *title;
	void (*drawproc)();
{
	WINDOW *win= ALLOC(WINDOW);
	Rect r;
	
	if (win == NULL) {
		dprintf("wopen: ALLOC failed"); /* XXX */
		return NULL;
	}

	/* Find a nice position for the window. */
	if (def_left + def_width + BAR + LSLOP + RSLOP
			> screen->portRect.right) {
		def_left= LEFT;
		CLIPMAX(def_left, screen->portRect.right -
			(def_width + BAR + LSLOP + RSLOP));
		CLIPMIN(def_left, 0);
	}
	if (def_top + def_height + BAR > screen->portRect.bottom) {
		def_top= TOP;
		CLIPMAX(def_top, screen->portRect.bottom -
			(def_height + BAR));
		CLIPMIN(def_top, MENUBARHEIGHT + TITLEBARHEIGHT);
	}
	
	SetRect(&r, def_left, def_top,
		def_left+def_width + BAR + LSLOP + RSLOP,
		def_top+def_height + BAR);
	def_left += HINCR;
	def_top += VINCR;
	
	win->w= NewWindow((Ptr)NULL, &r, PSTRING(title), TRUE, zoomDocProc,
		(WindowPtr)(-1), TRUE, 0L);
	SetWRefCon(win->w, (long)win);
	
	win->tag= 0;
	win->drawproc= drawproc;
	win->hcaret= win->vcaret= -1;
	win->caret_on= FALSE;
	win->attr= wattr;
	win->hbar= win->vbar= NULL;
	win->docwidth= 0;
	win->docheight= 0;
	win->orgh= -LSLOP;
	win->orgv= 0;
	win->timer= 0;
	win->cursor = NULL;
	
	initmbar(&win->mbar);
	makescrollbars(win);
	
	return win;
}

void
wclose(win)
	WINDOW *win;
{
	if (win == active) {
		rmlocalmenus(win);
		active= NULL;
	}
	killmbar(&win->mbar);
	DisposeWindow(win->w);
	FREE(win);
}

void
wgetwinsize(win, pwidth, pheight)
	WINDOW *win;
	int *pwidth, *pheight;
{
	Rect r;
	
	getwinrect(win, &r);
	*pwidth= r.right - r.left - LSLOP - RSLOP;
	*pheight= r.bottom - r.top;
}

void
wsettitle(win, title)
	WINDOW *win;
	char *title;
{
	SetWTitle(win->w, PSTRING(title));
}

char *
wgettitle(win)
	WINDOW *win;
{
	static char title[256];
	GetWTitle(win->w, title);
#ifndef CLEVERGLUE
	PtoCstr(title);
#endif
	return title;
}

void
wfleep()
{
	SysBeep(5);
}

void
wsetmaxwinsize(width, height)
	int width, height;
{
	/* Not supported yet (should be stored in the window struct
	   and used by do_grow). */
	/* XXX This procedure should disappear completely, it was
	   only invented for the Whitechapel which allocates bitmap
	   memory to the window when it is first created! */
	/* XXX Well, maybe it has some use.  In fact both min and max
	   window size are sometimes useful... */
}

void
wsetdefwinpos(h, v)
	int h, v;
{
	/* XXX Sanity checks? Change interaction with wopen()? */
	if (h > 0)
		def_left = h;
	if (v > 0)
		def_top = v;
}

void
wgetdefwinpos(ph, pv)
	int *ph, *pv;
{
	*ph = def_left;
	*pv = def_top;
}

void
wsetdefwinsize(width, height)
	int width, height;
{
	/* XXX Shouldn't this be done by wopen() instead? */
	if (width <= 0) {
		width= screen->portRect.right * 2/3;
		CLIPMAX(width, 512);
	}
	CLIPMAX(width, screen->portRect.right - BAR - LSLOP - RSLOP);
	CLIPMIN(width, MIN_WIDTH);
	
	if (height <= 0) {
		height= screen->portRect.bottom * 2/3;
		CLIPMAX(height, 342);
	}
	CLIPMAX(height, screen->portRect.bottom
		- MENUBARHEIGHT - TITLEBARHEIGHT - BAR);
	CLIPMIN(height, MIN_HEIGHT);
	
	def_width= width;
	def_height= height;
}

void
wgetdefwinsize(pwidth, pheight)
	int *pwidth, *pheight;
{
	*pwidth = def_width;
	*pheight = def_height;
}

void
wsetactive(win)
	WINDOW *win;
{
	SelectWindow(win->w);
}
