
/*  *************************************************************************
    macqd2.c -- The Macintosh QuickDraw functions (part 2 of 2) code for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macqd.h"
#include "version.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";


/*  ************************************************************************/


#define PTH(p) ((p).h)
#define PTV(p) ((p).v)
#define RECTLEFT(r) ((r).left)
#define RECTTOP(r) ((r).top)
#define RECTRIGHT(r) ((r).right)
#define RECTBOTTOM(r) ((r).bottom)


/*  ************************************************************************/


#define SUBRS(x)							    \
x("pt-new",		pt_new,	    SPECIAL_FUNC,	SPECIAL_FUNC)	    \
x("rect-new",		r_new,	    SPECIAL_FUNC,	SPECIAL_FUNC)	    \
x("rect-equal?",	r_equal,    SPECIAL_FUNC,	SPECIAL_FUNC)	    \
x("rect-empty?",	r_empty,    SPECIAL_FUNC,	SPECIAL_FUNC)	    \
x("rect-sect",		r_sect,	    SPECIAL_FUNC,	SPECIAL_FUNC)	    \
x("rect-union",		r_union,    SPECIAL_FUNC,	SPECIAL_FUNC)	    \


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS, init_mac_qd2)


/*  ************************************************************************/


SCM mac_pt_new(SCM s_args)
{
  Point p;

  GET_NEXT_INT(p.h, s_args, ARG1, s_mac_pt_new);
  GET_NEXT_INT(p.v, s_args, ARG2, s_mac_pt_new);

  return (make_macpt(&p));
}


SCM mac_r_new(SCM s_args)
{
  Rect r;

  GET_NEXT_INT(r.left, s_args, ARG1, s_mac_r_new);
  GET_NEXT_INT(r.top, s_args, ARG2, s_mac_r_new);
  GET_NEXT_INT(r.right, s_args, ARG3, s_mac_r_new);
  GET_NEXT_INT(r.bottom, s_args, ARG4, s_mac_r_new);

  return make_macrect(&r);
}


SCM mac_r_empty(SCM s_args)
{
  Rect r;

  GET_NEXT_MACRECT(r, s_args, ARG1, s_mac_r_empty);

  return EmptyRect(&r) ? BOOL_T : BOOL_F;
}


SCM mac_r_equal(SCM s_args)
{
  Rect r1, r2;

  GET_NEXT_MACRECT(r1, s_args, ARG1, s_mac_r_equal);
  GET_NEXT_MACRECT(r2, s_args, ARG2, s_mac_r_equal);

  return EqualRect(&r1, &r2) ? BOOL_T : BOOL_F;
}


SCM mac_r_sect(SCM s_args)
{
  Rect r1, r2, r;

  GET_NEXT_MACRECT(r1, s_args, ARG1, s_mac_r_sect);
  GET_NEXT_MACRECT(r2, s_args, ARG2, s_mac_r_sect);

  if (SectRect(&r1, &r2, &r))
    return make_macrect(&r);
  else
    return BOOL_F;
}


SCM mac_r_union(SCM s_args)
{
  Rect r1, r2, r;

  GET_NEXT_MACRECT(r1, s_args, ARG1, s_mac_r_union);
  GET_NEXT_MACRECT(r2, s_args, ARG2, s_mac_r_union);
  UnionRect(&r1, &r2, &r);

  return make_macrect(&r);
}


/*  ************************************************************************/
