#ifndef __macmenu_h__
#define __macmenu_h__

/*  *************************************************************************
    macmenu.h -- The Macintosh menu functions header for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#define MENU_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  call(m);						\
							\
  return UNSPECIFIED;					\
}

#define MBAR_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  Handle mb;						\
							\
  GET_NEXT_MACMBAR(mb, s_args, ARG1, S_MAC_(name));	\
  call(mb);						\
							\
  return UNSPECIFIED;					\
}

#define MENUINT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  long n;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG2, S_MAC_(name));		\
  call(m,n);						\
							\
  return UNSPECIFIED;					\
}

#define MENU_INT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
							\
  return MAKINUM((long) call(m));			\
}

#define MENU_STRING_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  char *pc;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  call(m, &GStr255);					\
  pc = p2cstr((char *) GStr255);			\
							\
  return makfromstr(pc, strlen(pc));			\
}

#define MENUINT2_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  long n1, n2;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n1, s_args, ARG2, S_MAC_(name));		\
  GET_NEXT_INT(n2, s_args, ARG3, S_MAC_(name));		\
  call(m,n1,n2);					\
							\
  return UNSPECIFIED;					\
}

#define MENUINT3_INT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  long n1, n2, n3;					\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n1, s_args, ARG2, S_MAC_(name));		\
  GET_NEXT_INT(n2, s_args, ARG3, S_MAC_(name));		\
  GET_NEXT_INT(n3, s_args, ARG4, S_MAC_(name));		\
							\
  return MAKINUM((long) call(m,n1,n2, n3));		\
}

#define MENUINT_INT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  long n;						\
  short r;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG2, S_MAC_(name));		\
  call(m,n,&r);						\
							\
  return MAKINUM((long) r);				\
}

#define INTSTRING_MENU_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  char *pc;						\
  long n;						\
							\
  GET_NEXT_INT(n, s_args, ARG1, S_MAC_(name));		\
  GET_NEXT_STRING(pc, s_args, ARG2, S_MAC_(name));	\
  c2pstr (strncpy((char *) GStr255, pc, 255));		\
  m = call(n, &GStr255);				\
							\
  if (m)						\
    return make_macmenu (m);				\
  else							\
    return BOOL_F;					\
}

#define INT_MENU_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  long n;						\
							\
  GET_NEXT_INT(n, s_args, ARG1, S_MAC_(name));		\
  m = call(n);						\
							\
  if (m)						\
    return make_macmenu (m);				\
  else							\
    return BOOL_F;					\
}

#define _MBAR_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  Handle mb;						\
  long n;						\
							\
  CHECK_NULL(s_args, ARG1, S_MAC_(name));		\
  mb = call();						\
							\
  if (mb)						\
    return make_macmbar (mb);				\
  else							\
    return BOOL_F;					\
}

#define MENUSTRINGINT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  char *pc;						\
  long n;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_STRING(pc, s_args, ARG2, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG3, S_MAC_(name));		\
  c2pstr (strncpy((char *) GStr255, pc, 255));		\
  call(m, &GStr255, n);					\
							\
  return UNSPECIFIED;					\
}

#define MENUSTRING_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  char *pc;						\
  long n;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_STRING(pc, s_args, ARG2, S_MAC_(name));	\
  c2pstr (strncpy((char *) GStr255, pc, 255));		\
  call(m, &GStr255);					\
							\
  return UNSPECIFIED;					\
}

#define MENUINTSTRING_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  char *pc;						\
  long n;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG2, S_MAC_(name));		\
  GET_NEXT_STRING(pc, s_args, ARG3, S_MAC_(name));	\
  c2pstr (strncpy((char *) GStr255, pc, 255));		\
  call(m, n, &GStr255);					\
							\
  return UNSPECIFIED;					\
}

#define MENUINT_STRING_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  char *pc;						\
  long n;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG2, S_MAC_(name));		\
  call(m, n, &GStr255);					\
  pc = p2cstr((char *) GStr255);			\
							\
  return makfromstr(pc, strlen(pc));			\
}

#define MENUINTBOOL_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  MenuHandle m;						\
  char b;						\
  long n;						\
							\
  GET_NEXT_MACMENU(m, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG2, S_MAC_(name));		\
  GET_NEXT_BOOL(b, s_args, ARG3, S_MAC_(name));		\
  call(m, n, b);					\
							\
  return UNSPECIFIED;					\
}


/*  ************************************************************************/

#endif /* __macmenu_h__ */
