
/*  *************************************************************************
    macmenu.c -- The Macintosh menu functions code (part 1 of 2) for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Desk.h>
#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macqd.h"
#include "macmenu.h"
#include "version.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";


/*  ************************************************************************/


#define MENU_TITLE(m,s) (memcpy((s), (**(m)).menuData, 256))
#define IRM_DRVR(m,i)	InsertResMenu((m),'DRVR',(i))
#define IRM_FONT(m,i)	InsertResMenu((m),'FONT',(i))
#define IRM_FOND(m,i)	InsertResMenu((m),'FOND',(i))
#define ARM_DRVR(m)	AddResMenu((m),'DRVR')
#define ARM_FONT(m)	AddResMenu((m),'FONT')
#define ARM_FOND(m)	AddResMenu((m),'FOND')

#define OPEN_DESK_ACC(m,i,j)	\
    (*(j) = (GetItem((m),(i), &GStr255), OpenDeskAcc(GStr255)))


/*  ************************************************************************/


#define SUBRS(x)								\
x("init-menus",		m_init,	    _UNSPEC_FUNC,	    InitMenus())	\
x("init-proc-menu",	m_i_p,	    INT_FUNC,		    InitProcMenu)	\
x("set-menu-flash",	m_s_f,	    INT_FUNC,		    SetMenuFlash)	\
x("menu-bar-get",	m_b_get,    _MBAR_FUNC,		    GetMenuBar)		\
x("menu-bar-set",	m_b_set,    MBAR_FUNC,		    SetMenuBar)		\
x("menu-bar-draw",	m_b_draw,   _UNSPEC_FUNC,	    DrawMenuBar())	\
x("menu-bar-inval",	m_b_inval,  _UNSPEC_FUNC,	    InvalMenuBar())	\
x("menu-bar-clear",	m_b_clear,  _UNSPEC_FUNC,	    ClearMenuBar())	\
x("menu-bar-flash",	m_b_flash,  INT_FUNC,		    FlashMenuBar)	\
x("get-menu",		m_g,	    INT_MENU_FUNC,	    GetMenu)		\
x("get-menu-handle",	m_g_h,	    INT_MENU_FUNC,	    GetMHandle)		\
x("menu-new",		m_new,	    INTSTRING_MENU_FUNC,    NewMenu)		\
x("menu-choice",	m_choice,   _INT_FUNC,		    MenuChoice)		\
x("menu-key",		m_key,	    INT_INT_FUNC,	    MenuKey)		\
x("menu-hilite",	m_hilite,   INT_FUNC,		    HiliteMenu)		\
x("menu-dispose",	m_dispose,  MENU_FUNC,		    DisposeMenu)	\
x("menu-insert",	m_insert,   MENUINT_FUNC,	    InsertMenu)		\
x("menu-delete",	m_delete,   INT_FUNC,		    DeleteMenu)		\
x("menu-append",	m_append,   MENUSTRING_FUNC,	    AppendMenu)		\
x("menu-get-title",	m_g_title,  MENU_STRING_FUNC,	    MENU_TITLE)		\
x("menu-select",	m_select,   PT_INT_FUNC,	    MenuSelect)		\
x("menu-ins-res-drvr",	m_irdrvr,   MENUINT_FUNC,	    IRM_DRVR)		\
x("menu-ins-res-font",	m_irfont,   MENUINT_FUNC,	    IRM_FONT)		\
x("menu-ins-res-fond",	m_irfond,   MENUINT_FUNC,	    IRM_FOND)		\
x("menu-app-res-drvr",	m_ardrvr,   MENU_FUNC,		    ARM_DRVR)		\
x("menu-app-res-font",	m_arfont,   MENU_FUNC,		    ARM_FONT)		\
x("menu-app-res-fond",	m_arfond,   MENU_FUNC,		    ARM_FOND)		\
x("menu-calc-size",	m_c_size,   MENU_FUNC,		    CalcMenuSize)	\
x("menu-count-items",	m_c_items,  MENU_INT_FUNC,	    CountMItems)	\
x("pop-up-menu-select", m_p_u_sel,  MENUINT3_INT_FUNC,	    PopUpMenuSelect)	\
x("menu-open-desk-acc", m_o_d_a,    MENUINT_INT_FUNC,	    OPEN_DESK_ACC)	\


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS, init_mac_menu)


/*  ************************************************************************/
