
/*  *************************************************************************
    macfonts.c -- The Macintosh font functions code for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>
#include <Fonts.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macqd.h"
#include "version.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";


/*  ************************************************************************/


#define SUBRS(x)								\
x("init-fonts",		    fi,	    _UNSPEC_FUNC,	InitFonts())		\
x("get-font-name",	    fgna,   INT_STRING_FUNC,	GetFontName)		\
x("get-font-num",	    fgnu,   STRING_INT_FUNC2,	GetFNum)		\
x("real-font",		    fr,	    INT2_BOOL_FUNC,	RealFont)		\
x("set-font-lock",	    fsl,    PT2_BOOL_FUNC,	IsOutline)		\
x("set-font-scale-disable", fssd,   BOOL_FUNC,		SetFontLock)		\
x("set-fract-enable",	    fsfe,   BOOL_FUNC,		SetFScaleDisable)	\
x("is-outline?",	    fio,    BOOL_FUNC,		SetFractEnable)		\
x("set-outline-preferred",  fsop,   BOOL_FUNC,		SetOutlinePreferred)	\
x("get-outline-preferred?", fgop,   _BOOL_FUNC,		GetOutlinePreferred)	\
x("set-preserve-glyph",	    fspg,   BOOL_FUNC,		SetPreserveGlyph)	\
x("get-preserve-glyph",	    fgpg,   _BOOL_FUNC,		GetPreserveGlyph)	\


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS, init_mac_font)


/*  ************************************************************************/
