#ifndef __macevt_h__
#define __macevt_h__

/*  *************************************************************************
    macevt.h -- The Macintosh Event (and miscellaneous) functions header for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#define _EVT_FUNC(name, call)				    \
SCM MAC_(name)(SCM s_args)				    \
{							    \
  EventRecord theEvent;					    \
  short eventMask;					    \
							    \
  GET_NEXT_INT(eventMask, s_args, ARG1, S_MAC_(name));	    \
  if (call(eventMask, &theEvent))			    \
    return (make_macevt(&theEvent));			    \
  else							    \
    return BOOL_F;					    \
}

#define EVT_BOOL_FUNC(name, call)			    \
SCM MAC_(name)(SCM s_args)				    \
{							    \
  EventRecord e;					    \
							    \
  GET_NEXT_MACEVT(e, s_args, ARG1, S_MAC_(name));	    \
							    \
  return call(e) ? BOOL_T : BOOL_F;			    \
}

#define EVT_INT_FUNC(name, call)			    \
SCM MAC_(name)(SCM s_args)				    \
{							    \
  EventRecord e;					    \
							    \
  GET_NEXT_MACEVT(e, s_args, ARG1, S_MAC_(name));	    \
							    \
  return MAKINUM(call(e));				    \
}

#define EVT_PT_FUNC(name, call)				    \
SCM MAC_(name)(SCM s_args)				    \
{							    \
  EventRecord e;					    \
  Point p;						    \
							    \
  GET_NEXT_MACEVT(e, s_args, ARG1, S_MAC_(name));	    \
  p = call(e);						    \
							    \
  return make_macpt(&p);				    \
}

#define EVT_WIND_FUNC(name, call)			    \
SCM MAC_(name)(SCM s_args)				    \
{							    \
  EventRecord e;					    \
  WindowPtr w;						    \
							    \
  GET_NEXT_MACEVT(e, s_args, ARG1, S_MAC_(name));	    \
  w = (WindowPtr) call(e);				    \
							    \
  return make_macwind(w);				    \
}

#define EVTWIND_FUNC(name, call)			    \
SCM MAC_(name)(SCM s_args)				    \
{							    \
  EventRecord e;					    \
  WindowPtr w;						    \
							    \
  GET_NEXT_MACEVT(e, s_args, ARG1, S_MAC_(name));	    \
  GET_NEXT_MACWIND(w, s_args, ARG2, S_MAC_(name));	    \
  call(&e,w);						    \
							    \
  return UNSPECIFIED;					    \
}


/*  ************************************************************************/

#endif /* __macevt_h__ */
