;    scmhob.scm defines several procedures recognized
;    by the hobbit compiler as primitives, but not defined in scm or slib.
;
;    Use scmhob when running code (meant for compilation by
;    hobbit) under interpreter. Never compile scmhob.h!
;
;    Copyright (C) 1992, 1993, 1994 Tanel Tammet
;    tammet@cs.chalmers.se
;
;    version 3c
;
;====================================================================

; bitwise operations: logical shift left and logical shift right

(define (logsleft x y) (ash x y))
(define (logsright x y) (ash x (- 0 y)))

; immediate-integer (30-bit signed int) versions of arithmetic primitives:

(define %= =)
(define %< <)
(define %> >)
(define %< <)
(define %> >)
(define %+ +)
(define %- -)
(define %* *)
(define %/ /)
