; -*- Scheme -*-
;
; $Id: mawk02.scm,v 1.4 1993/10/31 15:54:36 bevan Exp $

(require 'mawk:for-all)
(require 'mawk:for-all!)

;+doc
; procedure: mawk:awk
; arguments: action[line line-number]
; signature: (string x int -> unspecified) -> unspecified
; arguments: action[line line-number] port
; signature: (string x int -> unspecified) x port -> unspecified
; arguments: action[line line-number state] port state
; signature: forall a => (string x int x a -> a) x port x a -> a
; pre:       (input-port? port)
;
; Applies ACTION to each line read from PORT or from (CURRENT-INPUT-PORT)
; if PORT is not defined.  If a third arguments is defined, then this
; is taken to be the initial value for a STATE that is to be threaded
; through the iteration over each line.  Note in this case that ACTION
; also takes the STATE as a second argument.
;-doc

(define mawk:awk
  (lambda (action . opt)
    (if (null? opt)
	(mawk:for-all! action)
	(let ((port/state (car opt)) (opt (cdr opt)))
	  (if (null? opt)
	      (mawk:for-all! action port/state)
	      (mawk:for-all action (car opt) port/state))))))

; eof
