;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1992 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

;;; The SECT: functions deal with strings which are ordered like
;;; chapters in a book.  For instance, a.9 < a.10 and 4c < 4aa.  Each
;;; section of the string consists of consecutive numeric on
;;; consecutive aphabetic characters.

;(define (sect:string<? s1 s2)
;  (let ((l1 (string-length s1))
;	(l2 (string-length s2)))
;    (let loop ((i 0) (oc #\ ) (cmp #f))
;      (cond ((>= i l1)
;	     (if (>= i l2) (and cmp (positive? cmp)) #t))
;	    ((>= i l2) #f)
;	    (else
;	     (let ((c1 (string-ref s1 i))
;		   (c2 (string-ref s2 i)))
;	       (cond ((char=? c1 c2)
;		      (loop (+ 1 i) c1 cmp))
;		     ((or (and (char-upper-case? c1)
;			       (char-upper-case? c2))
;			  (and (char-lower-case? c1)
;			       (char-lower-case? c2))
;			  (and (char-numeric? c1)
;			       (char-numeric? c2)))
;		      (loop (+ 1 i) c1
;			    (or cmp (if (char<? c1 c2) 1 -1))))
;		     ((char-upper-case? oc) (or (char-upper-case? c2)
;						(char<? c1 c2)))
;		     ((char-lower-case? oc) (or (char-lower-case? c2)
;						(char<? c1 c2)))
;		     ((char-numeric? oc) (or (char-numeric? c2)
;					     (char<? c1 c2)))
;		     (else		;Mismatched field
;		      (char<? c1 c2)))))))))

(define sect:char-incr (- (char->integer #\2) (char->integer #\1)))

(define (sect:inc-string s p)
  (let ((c (string-ref s p)))
    (cond ((char=? c #\z)
	   (string-set! s p #\a)
	   (cond ((zero? p) (string-append "a" s))
		 ((char-lower-case? (string-ref s (+ -1 p)))
		  (sect:inc-string s (+ -1 p)))
		 (else
		  (string-append 
		   (substring s 0 p)
		   "a"
		   (substring s p (string-length s))))))
	  ((char=? c #\Z)
	   (string-set! s p #\A)
	   (cond ((zero? p) (string-append "A" s))
		 ((char-upper-case? (string-ref s (+ -1 p)))
		  (sect:inc-string s (+ -1 p)))
		 (else
		  (string-append 
		   (substring s 0 p)
		   "A"
		   (substring s p (string-length s))))))
	  ((char=? c #\9)
	   (string-set! s p #\0)
	   (cond ((zero? p) (string-append "1" s))
		 ((char-numeric? (string-ref s (+ -1 p)))
		  (sect:inc-string s (+ -1 p)))
		 (else
		  (string-append 
		   (substring s 0 p)
		   "1"
		   (substring s p (string-length s))))))
	  ((or (char-alphabetic? c) (char-numeric? c))
	   (string-set! s p (integer->char
			     (+ sect:char-incr
				(char->integer (string-ref s p)))))
	   s)
	  (else (error "inc-string shouldn't get here" s p)))))

(define (sect:next-string s)
  (do ((i (+ -1 (string-length s)) (+ -1 i)))
      ((or (negative? i)
	   (char-numeric? (string-ref s i))
	   (char-alphabetic? (string-ref s i)))
       (if (negative? i) (string-append s "0")
	   (sect:inc-string (string-copy s) i)))))

(define (ns s1) (sect:next-string s1))

(define (ts s1 s2)
  (let ((s< (sect:string<? s1 s2))
	(s> (sect:string<? s2 s1)))
    (cond (s<
	   (display s1)
	   (display " < ")
	   (display s2)
	   (newline)))
    (cond (s>
	   (display s1)
	   (display " > ")
	   (display s2)
	   (newline)))))
