;;; Bug fixes to Chez Scheme
;;;
;;; Karl O. Pinc
;;;
;;; July 29, 1991
;;;
;;; This file contains work arounds for bugs in the Sybase interface routines which
;;; are due to underlying bugs in Chez Scheme.
;;;
;;; These routines must be loaded after all the Sybase interface routines because
;;; they replace some of them.

(define peek.integer-32
  (let* ((2**31 (expt 2 31))
         (2**32 (* 2**31 2)))
    (lambda (ptr)
      (let ((number (peek.unsigned-32 ptr)))
        (if (>= number 2**31)
            ; The number is really negative.
            (- number 2**32)
            number)))))