;; -*- Scheme -*-
;;
;; $Id: stringt12.scm,v 1.1 1993/10/22 13:14:39 bevan Exp $

(require 'string:test:equal)
(require 'string:split-by-string)
(require 'string:find-by-substring)
(require 'string:find-by-knuth-morris-pratt)

;;----------

(define string:test:split-by-string
  (lambda args

    (if (not (null? args)) (display "Testing string:split-by-string ... "))

    (string:test:equal
     'string:test:split-by-string-knp-a
     ((string:split-by-string
       substring:find-by-knuth-morris-pratt
       "foo")
      "abcfoodeffooghi")
     '("abc" "def" "ghi"))

    (string:test:equal
     'string:test:split-by-string-kmp-b
     ((string:split-by-string
       substring:find-by-knuth-morris-pratt
       "foo")
      "foodeffooghi")
     '("" "def" "ghi"))

    (string:test:equal
     'string:test:split-by-string-kmp-c
     ((string:split-by-string
       substring:find-by-knuth-morris-pratt
      "ff")
      "abcfffdefffghi")
     '("abc" "fde" "fghi"))

    (string:test:equal
     'string:test:split-by-string-kmp-d
     ((string:split-by-string
       substring:find-by-knuth-morris-pratt
       "ff")
      "abcfffdeffffghi")
     '("abc" "fde" "" "ghi"))

    (string:test:equal
     'string:test:split-by-string-kmp-d
     ((string:split-by-string
       substring:find-by-knuth-morris-pratt
       "ff")
      "")
     '(""))

    (string:test:equal
     'string:test:split-by-string-kmp-e
     ((string:split-by-string
       substring:find-by-knuth-morris-pratt
       "")
      "abcfffdeffffghi")
     '("" "a" "b" "c" "f" "f" "f" "d" "e" "f" "f" "f" "f" "g" "h" "i" ""))


;    (string:test:equal
;     'string:test:split-by-string-s-a
;     ((string:split-by-string
;       string:find-by-sunday
;       "foo")
;      "abcfoodeffooghi")
;     '("abc" "def" "ghi"))
;
;    (string:test:equal
;     'string:test:split-by-string-s-b
;     ((string:split-by-string
;       string:find-by-sunday
;       "foo")
;      "foodeffooghi")
;     '("" "def" "ghi"))
;
;    (string:test:equal
;     'string:test:split-by-string-s-c
;     ((string:split-by-string
;       string:find-by-sunday
;      "ff")
;      "abcfffdefffghi")
;     '("abc" "fde" "fghi"))
;
;    (string:test:equal
;     'string:test:split-by-string-s-d
;     ((string:split-by-string
;       string:find-by-sunday
;       "ff")
;      "abcfffdeffffghi")
;     '("abc" "fde" "" "ghi"))
;
;    (string:test:equal
;     'string:test:split-by-string-s-d
;     ((string:split-by-string
;       string:find-by-sunday
;       "ff")
;      "")
;     '(""))
;
;    (string:test:equal
;     'string:test:split-by-string-s-e
;     ((string:split-by-string
;       string:find-by-sunday
;       "")
;      "abcfffdeffffghi")
;     '("" "a" "b" "c" "f" "f" "f" "d" "e" "f" "f" "f" "f" "g" "h" "i" ""))

    (string:test:equal
     'string:test:split-by-string-ss-a
     ((string:split-by-string
       substring:find-by-substring
       "foo")
      "abcfoodeffooghi")
     '("abc" "def" "ghi"))

    (string:test:equal
     'string:test:split-by-string-ss-b
     ((string:split-by-string
       substring:find-by-substring
       "foo")
      "foodeffooghi")
     '("" "def" "ghi"))

    (string:test:equal
     'string:test:split-by-string-ss-c
     ((string:split-by-string
       substring:find-by-substring
      "ff")
      "abcfffdefffghi")
     '("abc" "fde" "fghi"))

    (string:test:equal
     'string:test:split-by-string-ss-d
     ((string:split-by-string
       substring:find-by-substring
       "ff")
      "abcfffdeffffghi")
     '("abc" "fde" "" "ghi"))

    (string:test:equal
     'string:test:split-by-string-ss-d
     ((string:split-by-string
       substring:find-by-substring
       "ff")
      "")
     '(""))

    (string:test:equal
     'string:test:split-by-string-ss-e
     ((string:split-by-string
       substring:find-by-substring
       "")
      "abcfffdeffffghi")
     '("" "a" "b" "c" "f" "f" "f" "d" "e" "f" "f" "f" "f" "g" "h" "i" ""))

    (if (not (null? args)) (begin (display "done") (newline)))
  ))

;; eof
