;; -*- Scheme -*-
;;
;; $Id: string56.scm,v 1.1 1993/10/21 12:58:10 bevan Exp $

(require 'char-set:member?)

;;+doc
;; procedure: substring:find-not-chars
;; arguments: string start end chars if-found if-not-found state
;; signature: 
;;   forall a => string x int x int char-set x (int x (a -> a) x a) x a -> a
;; pre:       (<= 0 start end (string-length string))
;;
;; Searches STRING in order from START (inclusive) to END (exclusive)
;; looking for any characters that are not in CHARS.  If a character is
;; found, IF-FOUND is called with the position of the character, a
;; continuation which if called will find the position of the next
;; matching character and the STATE of the system.  If the search extends
;; past END, then IF-NOT-FOUND is called with the STATE at that point.
;;-doc

(define substring:find-not-chars
  (lambda (source start end chars yes no state)
    (let loop ((cp start) (r state))
      (cond
        ((>= cp end) (no r))
	((char-set:member? chars (string-ref source cp)) (loop (+ 1 cp) r))
	(else (let ((np (lambda (r) (loop (+ 1 cp) r)))) (yes cp np r)))))))

;;-------------

;;+doc
;; procedure: string:find-not-chars
;; arguments: string chars if-found if-not-found state
;; signature: forall a => string char-set x (int x (a -> a) x a) x (a -> a)-> a
;;
;; Searches STRING in order looking for any characters that are not in
;; CHARS.  If a character not in CHARS is found, IF-FOUND is called with the
;; position of the character, a continuation which if called will find
;; the position of the next matching character and the STATE of the
;; system.  If the search attempts to extend past the end of STRING, 
;; IF-NOT-FOUND is called with STATE.
;;-doc

(define string:find-not-chars
  (lambda (s cs yes no st)
    (substring:find-not-chars s 0 (string-length s) cs yes no st)))


;; eof
