; -*- Scheme -*-
;
; $Id: string29.scm,v 1.1 1993/08/28 12:24:28 bevan Exp $

(require 'substring:pad-left!)

;+doc
; procedure: string:pad-left
; arguments: source size padding
; signature: string x int x string -> string
; pre:       (and (<= 0 size) (< 0 (string-length padding)))
;
; Returns a new string which is SIZE characters long containing SOURCE
; at its right end and the left padded with copies of PADDING.
;
; Achieves the same effect as "right(s1, i, s2)" in Icon.
;
; > (string:pad-left "Detroit" 10 "+")
; "+++Detroit"
;
; > (string:pad-left "Detroit" 20 "+*+")
; "+*++*++*++*++Detroit"
;
; > (string:pad-left "Detroit" 4 "+*+")
; "roit"
;-doc

(define string:pad-left
  (lambda (s sz p)
    (let ((sl (string-length s)))
      (if (<= sz sl)
	  (substring s (- sl sz) sl)
	  (let ((r (make-string sz)))
	    (substring:pad-left! s 0 sl p 0 (string-length p) r 0 sz)
	    r)))))

; eof
