;; -*- Scheme -*-
;;
;; $Id: avl-trie03.scm,v 1.1 1993/12/04 16:50:06 bevan Exp $

;;-----------

(require 'avl-trie::node:key)
(require 'avl-trie::node:kids)
(require 'avl-trie::node:value)
(require 'avl-tree:for-all-in-order)

;;-----------

;;+doc
;; procedure: avl-trie:for-all-in-order
;; arguments: trie before[key value state] after[key value state] state
;; signature: 
;;
;; Apply BEFORE and AFTER to each node in TRIE.
;;-doc

(define avl-trie:for-all-in-order
  (let ((after (lambda (s _) s)))
    (lambda (t b a s)
      (let loop ((t t) (s s))
	(let ((before
	       (lambda (s n)
		 (let ((k (avl-trie::node:key n)) (v (avl-trie::node:value n)))
		   (a k v (loop (avl-trie::node:kids n) (b k v s)))))))
	  (avl-tree:for-all-in-order t before after s))))))

;; eof
