/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*
*		<< syspred1.c >>
*		(system predicates 1)
*
* 90.4.1 ver3.0
* 90.7.1 ver3.10
*/

#include "include.h"
/* for LtoC(), CtoL() pred  */
#define FROM_NAME 1
#define FROM_CONC 0

#ifdef MAC
#define NextTRUE	3		/* for Reader control */
#endif

int memb_pred(t,e,n,status)	/* system 'member' pred */
struct term *t;
struct pair *e;
struct node *n;
int status;
{
  	register struct term *tt;
	struct ustack *usave;
	long int *hsave;
	struct pair *esave;
	register struct pair *p,*pp,*ee;

	if (status != BACKTRACK)
	  {
	    pp = Nenv(1);
	    n->n_hp = hp;
	    n->n_ep = ep;
	    n->n_usp = usp;
	    tt = Arg2(t);
	    ee = e;
	    }
	else
	  {
	    pp = (struct pair *)n->n_set;
	    tt = pp->p_body;
	    ee = pp->p_env;
	  }
	down(p,tt,ee);

	usave = usp;
	hsave = hp;
	esave = ep;
	while(tt != NIL)
	{
		if (! is_list(tt)) return(SYSFAIL);
		if (tunify(Arg1(t),e,head_of_list(tt),ee,0) == FALSE)
		{
			undo(usave);
			hp = hsave;
			ep = esave;
			tt = tail_of_list(tt);
			down(p,tt,ee);
			continue;
		}
		pp->p_body = tail_of_list(tt);
		pp->p_env = ee;
		n->n_set = (struct set *)pp;
		return(SYSTRUE);
	}
	return(SYSFAIL);
} 

int or_pred(t,e,n,m,status)
struct term *t;
register struct pair *e;
struct node *n, *m;
int status;
{
  register struct term *tt;
  register struct pair *e0;
  struct pair *p;
  struct clause *c0;
  int arity, next = 0;
  char *emesg = "or/%d: %d-th argument is %s";
  struct clause *convert_list_to_clause();

  if (status == BACKTRACK)
    next = (int)n->n_set;

  tt = Arg(t,next++);
  e0 = e; down(p,tt,e0);

  if ((arity = (int)t->t_arity) < 0) arity = -arity;
  n->n_set = (next < arity) ? (struct set *)next : NULL;

  if (p != NULL) {
	sprintf(nbuf,emesg,arity,(next-1),"real VAR");
	error_detail(t,e,nbuf);
   }
  else if ((tt == NIL) || (tt==NULL)) return(SYSTRUE);

  if (is_list(tt)) {
	sprintf(nbuf,emesg,arity, (next-1),"not List");
	c0 = convert_list_to_clause(t,e,tt,e0,&p,nbuf);
	}
  else {
    p = e0;
    if (! is_clause(tt))
      c0 = Nclause(tt,(struct clause *)NULL,TEMPORAL);
    else  c0 = (struct clause *)tt; 
    }

  m->n_clause = c0;
  m->n_env = p;
  m->n_usp = usp;
  m->n_hp = hp;
  m->n_ep = ep;
  m->n_set = init_set(m);
  return(SYSTRUE);
}

struct clause *convert_list_to_clause(t,e,tt,ee,p,emsg)
struct term *t, *tt;
struct pair *e, *ee, **p;
char *emsg;
{
    struct clause *c, *cc;
    register struct pair *pp;

    v_number = 0;  v_list = NULL;
    *p = Nenv(0);
    cc = c = Nclause((struct term *)NULL,(struct clause *)NULL,TEMPORAL);

    while(1) {
      if (! is_list(tt)) error_detail(t,e,emsg);
      if (isconst(head_of_list(tt))) cc->c_form = head_of_list(tt);
      else {
	pp = Nenv(1);
	cc->c_form = Nvar(Anonymous_VarName,TEMPORAL);
	pp->p_body = head_of_list(tt);
	pp->p_env = ee;
      }

      tt = tail_of_list(tt);
      down(pp,tt,ee);
      if ((tt == NIL) || (tt == NULL)) break;
      cc->c_link = Nclause((struct term *)NULL,(struct clause *)NULL,TEMPORAL);
      cc = cc->c_link;
    }
   return(c);
}

struct clause *convertlc_sub(c,e,flag)
register struct term *c;
struct pair *e;
int flag;	/* TRUE: clause -> list, FALSE: list -> clause */
{
  struct clause *lc_sub_sub();

  if (flag){
    if (c == NULL) return((struct clause *)NIL);
  }
  else if (c == NIL) return(NULL);

  if (flag) {
    if (! is_clause(c))	/* a ->[a] */
	return(Nlist(c,NIL,TEMPORAL));
	}
  else if (((struct clause *)c)->c_link == (struct clause *)NIL)
	/* [a] -> a */
	return((struct clause *)((struct clause *)c)->c_form);

  return(lc_sub_sub(c,e,flag));
}

struct clause *lc_sub_sub(c,e,flag)
register struct term *c;
struct pair *e;
int flag;
{
  struct clause *cc;
  struct pair *p;

  if (flag) {
    if (c == NULL) return((struct clause *)NIL);
  }
  down(p,c,e);
  if (! flag) {
	if(c == NIL) return(NULL);
	if (! is_list(c))
		return(Nclause(c,NULL,TEMPORAL));
      }

  cc = lc_sub_sub((struct term *)((struct clause *)c)->c_link,e,flag);

  if (flag)
	return(Nlist(((struct clause *)c)->c_form,cc,TEMPORAL));
  else
	return(Nclause(((struct clause *)c)->c_form, cc, TEMPORAL));
}


int convertlc_pred(t,e)	/* clause <-> list */
struct term *t;
struct pair *e;
{
  struct term *ls, *cl;
  register struct pair *p, *el, *ec;
  struct clause *c, *convertlc_sub();
  char *emsg = "clause_list/2: %s";

  cl = Arg1(t);
  ls = Arg2(t);
  el = ec = e;
  down(p, ls, el);
  down(p, cl, ec);

  if (isvar(ls)) {
    if (isvar(cl)) {
      sprintf(nbuf,emsg,"Both arguments are Variables");
      error_detail(t,e,nbuf);
    }
    c = convertlc_sub(cl,ec,TRUE);
    return(equalpred(ls,el,(struct term *)c,ec));
  }

  if (! is_list(ls)) {
       sprintf(nbuf,emsg,"2nd argument should be List");
       error_detail(t,e,nbuf);
    }

    c = convertlc_sub(ls,el,FALSE);
    return(equalpred(cl,ec,(struct term *)c,el));
}

int read_pred(t,e,n,arity)
struct term *t;
struct pair *e;
struct node *n;
int arity;	/* representing STATUS in original use */
{
  register struct term *tt, *target;
  register struct pair *p, *ee;
  FILE *filep = fp;
  char *emsg = "read/2: %s";
#ifdef MAC
	char openmode;
#endif

  n->n_set = DUMMY_DEF;	/* do again in backtrack */
  if ((arity = (int)t->t_arity) < 0) arity = -arity;
  if (arity == 2) {
    tt = Arg2(t);
    ee = e;
    down(p,tt,ee);
    if ((! is_file(tt)) || (filep_value(tt) == (FILE *)NULL)) {
	sprintf(nbuf,emsg,"Illegal file pointer");
	error(nbuf);
      }
    fp = filep_value(tt);
#ifndef MAC
    if (! is_readable(fp))
#else
    openmode = OPEN_FILE_MODE[(int)fnum_value(tt)];
    if (! (openmode == 'r'))
#endif
      {
	fp = filep;
	sprintf(nbuf,emsg,"File not open for reading");
	error_detail(t,e,nbuf);
      }
  }
  else fp = READ_FILE;

  if (fp == (FILE *)NULL) {
	fp = stdin;
	if (arity == 1) READ_FILE = stdin;
	error("readfing over END OF FILE");
	}
  v_number = 0;  v_list = NULL;
  p_number = 0;
  reread = FALSE;
  is_user_input = TRUE;

  if (fp == stdin) putcursor();		/* print cursor */
#ifdef MAC
	else KEYIN=FALSE;
#endif
  advance;
  if (check(EOF)){
    if (arity == 2) filep_value(tt)=(FILE *)NULL;
    else {
		strcpy(SEEING_FILE, STANDARD_INPUT);
	}
	target = END_OF_FILE;
	fclose(fp);
	filep_value(tt)=(FILE *)NULL;
    }
  else {
  	if (setjmp(read_eof)) {
  		fp = filep;
#ifdef MAC
		KEYIN = TRUE;
#endif
  		return(equalpred(Arg1(t),e,END_OF_FILE,(struct pair *)NULL));
  		}
    target = Rterm(1200,TEMPORAL);
    if (tokentype == EOF_MARK) {
  		fp = filep;
#ifdef MAC
		KEYIN = TRUE;
#endif
  		return(equalpred(Arg1(t),e,END_OF_FILE,(struct pair *)NULL));
    }
    if (tokentype!=FULLSTOP) {
	error_detail(target,(struct pair *)NULL,"Syntax error --- . expected");
	}
    SKIPLINE;
  }
  fp = filep;
#ifdef MAC
  KEYIN = TRUE;
#endif
  ee = Nenv(v_number+p_number);
  return(equalpred(Arg1(t),e,target,ee));
}

int prompt_pred(t,e)
struct term *t;
struct pair *e;
{
  struct pair *p;
  char *emesg ="prompt/1: Argument is %s";

  t = Arg1(t);
  down(p,t,e);

  if (! is_string(t)) {
    sprintf(nbuf,emesg,"not string");
    error(nbuf);
  }
  if (strlen(str_value(t)) >= NAME_MAX) {
	sprintf(nbuf,emesg,"too long");
	error(nbuf);
  }

  strcpy(user_prompt, str_value(t));
  return(SYSTRUE);
}

#define GET_mode	0
#define GET0_mode	1
#define GET1_mode	2

int get_pred(t,e,n,status)
struct term *t;
struct pair *e;
struct node *n;
int status;
{
	return(get_general_pred(t,e,n,GET_mode));
}

int get0_pred(t,e,n,status)
struct term *t;
struct pair *e;
struct node *n;
int status;
{
	return(get_general_pred(t,e,n,GET0_mode));
}

int get1_pred(t,e,n,status)
struct term *t;
struct pair *e;
struct node *n;
int status;
{
	return(get_general_pred(t,e,n,GET1_mode));
}

int get_general_pred(t,e,n,mode)
struct term *t;
struct pair *e;
struct node *n;
int mode;
{
	struct pair *p, *ee = e;
    struct term *tt;
	FILE *filep = fp;
	char *emsg = "get/%d: %s";
	int arity;
#ifdef MAC
	char openmode;
#endif

  if ((arity = (int)t->t_arity) < 0) arity = -arity;
  if (arity == 2) {
    tt = Arg2(t);
    down(p,tt,ee);
    if ((! is_file(tt)) || (filep_value(tt) == (FILE *)NULL)) {
	sprintf(nbuf,emsg,2,"Illegal file pointer");
	error_detail(t,e,nbuf);
      }
    fp = filep_value(tt);
#ifndef MAC
    if (! is_readable(fp))
#else
    openmode = OPEN_FILE_MODE[(int)fnum_value(tt)];
    if (! (openmode == 'r'))
#endif
      {
	fp = filep;
	sprintf(nbuf,emsg,2,"File not open for reading");
	error_detail(t,e,nbuf);
      }
  }
  else fp = READ_FILE;

	tt = Arg1(t); ee = e;
	down(p,tt,ee);
	if ((! is_int(tt)) && (p == (struct pair *)NULL)) {
		fp = filep;
		sprintf(nbuf,emsg,arity,"Illegal 1st argument");
		error_detail(t,e,nbuf);
	}

	n->n_set = DUMMY_DEF;	/* do agin in backgrack */
#ifdef MAC
	if (fp != stdin) KEYIN = FALSE;
#endif
	if (fp == (FILE *)NULL) {
		if (arity == 1) {
			READ_FILE = stdin;
			strcpy(SEEING_FILE, STANDARD_INPUT);
		}
		fp = stdin;
		sprintf(nbuf,emsg,arity,"Reading over END OF FILE");
		error(nbuf);
	}
	switch (mode) {
	case GET_mode:	/* get*/
		do {
			advance;
			if (check(EOF)) {
				fclose(fp);
				if (arity == 1) READ_FILE = (FILE *)NULL;
				else filep_value(tt) = (FILE *)NULL;
				cbuf = 255;
			}
			if (cbuf < 0) cbuf = 256+cbuf;
		}
		while (cbuf < 33);
		break;
	default:	/* get0, get1 */
		next();
		if (check(EOF)) {
			fclose(fp);
			if (arity == 1) READ_FILE = (FILE *)NULL;
			else filep_value(tt) = (FILE *)NULL;
			cbuf = 255;
		}
		else if (cbuf < 0) cbuf = 256+cbuf;
		if ((mode == GET0_mode) && ((cbuf == '\r') || (cbuf == '\n')))
			 cbuf=31;	/* '\x1f' */
	};
	t = Nnum_val((float)cbuf,TEMPORAL);
	fp = filep;
#ifdef MAC
	KEYIN = TRUE;
#endif
	return(equalpred(t,(struct pair *)NULL,tt,ee));
}

#define SPECIFIED 0
#define INPUT     1
#define OUTPUT    2
#define APPEND	  3	

int open_pred(t,e)
struct term *t;
struct pair *e;
{
  return(file_open_pred(t,e,SPECIFIED));
       }

int see_pred(t,e)
struct term *t;
struct pair *e;
{
  return(file_open_pred(t,e,INPUT));
       }

int tell_pred(t,e)
struct term *t;
struct pair *e;
{
    return(file_open_pred(t,e,OUTPUT));
	 }

int tella_pred(t,e)
struct term *t;
struct pair *e;
{
    return(file_open_pred(t,e,APPEND));
	 }


int file_open_pred(t,e,openmode)
register struct term *t;
register struct pair *e;
int openmode;
{
  static char *emsg = "open/3: %s";
  register struct pair *p, *ee;
  register struct term *tt;
  char *mode, *fname;
  int i;
  FILE *filep, *fopen();

  tt = Arg1(t);
  ee = e;
  down(p,tt,ee);
  if (p != NULL) {
		sprintf(nbuf,emsg,"Invalid argument");
		error_detail(t,e,nbuf);
	}
  if (is_string(tt)) fname=str_value(tt);
  else if (!is_atomic(tt)) fname=tt->type.t_func->f_name;
  else {
	sprintf(nbuf,emsg,"Illegal file name");
	error_detail(t,e,nbuf);
	}

  switch (openmode) {
  case INPUT:
    mode = "r";
    break;
  case OUTPUT:
    mode = "w";
    break;
  case APPEND:
	mode = "a";
	break;
  case SPECIFIED:
    tt = Arg2(t);
    ee = e;
    down(p,tt,ee);
    if (p != NULL) error_detail(t,e, emsg);

    mode = (is_string(tt)) ? str_value(tt) : tt->type.t_func->f_name;
    if (((mode[0] != 'r') && (mode[0] != 'w') && (mode[0] != 'a'))
	|| mode[1] != '\0') {
     sprintf(nbuf,emsg,"Illegal mode");
     error_detail(t,e,nbuf);
	}
 
 	for (i=0; i< FOPEN_MAX; i++)
		if (OPEN_FILES[i] == (FILE *)NULL) break;
	if (i >= FOPEN_MAX) {
		sprintf(nbuf,emsg,"Too many open files");
		error_detail(t,e,nbuf);
	}
  }

  if (strcmp(fname,"user")==0) {
	if (mode[0] == 'r') filep = stdin;
	else filep = stdout;
  }
  else {
	if ((filep = fopen(fname, mode)) == NULL) {
		sprintf(nbuf,emsg,"Cannot open file");
		error_detail(t,e,nbuf);
	}
  }

  switch (openmode) {
	case INPUT:
		if (READ_FILE != stdin) fclose(READ_FILE);
		READ_FILE = filep;
		strcpy(SEEING_FILE,fname);
		return(SYSTRUE);
	case APPEND:
	case OUTPUT:
		if (WRITE_FILE != stdout) fclose(WRITE_FILE);
		WRITE_FILE = filep;
		strcpy(TELLING_FILE,fname);
		return(SYSTRUE);
	}

  tt = Nterm(0,TEMPORAL);
  tt->type.ident = (long int)ATOMIC_TYPE;
  tt->t_arity = (long int)FILE_POINTER;
  fnum_value(tt) = (long int)i;
  OPEN_FILES[i]=filep;
  strcpy(OPEN_FILE_NAMES[i],fname);
  OPEN_FILE_MODE[i]=mode[0];
  return(equalpred(Arg3(t),e,tt,(struct pair *)NULL));
}

int openfiles_pred(t,e,n,status)
struct term *t;
struct pair *e;
struct node *n;
int status;
{
  struct term *tt;
  struct ustack *usave = usp;
  long int *hsave = hp;
  struct pair *esave = ep;
  char mode[2];

  if (status == BACKTRACK)
    status = (int)n->n_set;
  else status = 0;

  while (status < FOPEN_MAX) {
	while (status < FOPEN_MAX) {
		if (OPEN_FILES[status] == (FILE *)NULL) status++;
		else break;
	}
	if (status >= FOPEN_MAX) return(SYSFAIL);
	tt = Nstr(OPEN_FILE_NAMES[status],TEMPORAL);
	if (tunify(Arg1(t),e,tt,(struct pair *)NULL,0) == FALSE) {
		undo(usave); hp = hsave; ep = esave;
		status++;
		continue;
		}
	if (((int)t->t_arity > 1) || ((int)t->t_arity < -1)) {
		tt = Nterm(0,TEMPORAL);
		tt->type.ident = (long int)ATOMIC_TYPE;
		tt->t_arity = (long int)FILE_POINTER;
		fnum_value(tt) = (long int)status;
		if (tunify(Arg2(t),e,tt,(struct pair *)NULL,0) == FALSE) {
			undo(usave); hp = hsave; ep = esave;
			status++;
			continue;
		}
	}
	if (((int)t->t_arity > 2) || ((int)t->t_arity < -2)) {
		mode[0]=OPEN_FILE_MODE[status];
		mode[1]='\0';
		tt = Nstr(mode,TEMPORAL);
		if (tunify(Arg3(t),e,tt,(struct pair *)NULL,0) == FALSE) {
			undo(usave); hp = hsave; ep = esave;
			status++;
			continue;
		}
	}
	n->n_set = (struct set *)(status+1);
    return(SYSTRUE);
	}
  return(SYSFAIL);
}

int seeing_pred(t,e)
struct term *t;
struct pair *e;
{
	struct term *tt;
	tt = Nstr(SEEING_FILE,TEMPORAL);
	return(equalpred(Arg1(t),e,tt,(struct pair *)NULL));
}

int telling_pred(t,e)
struct term *t;
struct pair *e;
{
	struct term *tt;
	tt = Nstr(TELLING_FILE,TEMPORAL);
	return(equalpred(Arg1(t),e,tt,(struct pair *)NULL));
}

int seen_pred(t,e)
struct term *t;
struct pair *e;
{
  if (READ_FILE != stdin) fclose(READ_FILE);
  READ_FILE = fp = stdin;
  strcpy(SEEING_FILE,STANDARD_INPUT);
  return(SYSTRUE);
}

int told_pred(t,e)
struct term *t;
struct pair *e;
{
    if (WRITE_FILE != stdout) fclose(WRITE_FILE);
    WRITE_FILE = wfp = stdout;
    strcpy(TELLING_FILE,STANDARD_OUTPUT);
    return(SYSTRUE);
}

int close_pred(t,e)
register struct term *t;
register struct pair *e;
{
  FILE *filep;
  struct term *tt = Arg1(t);
  struct pair *ee = e;
  register struct pair *p;

  down(p,tt,ee);
  if (! is_file(tt)) {
	error_detail(t,e,"close/1: Invalid File argument");
      }
  filep = filep_value(tt);
  if ((filep != stdin) && (filep != stdout)
	&& (filep_value(tt) != (FILE *)NULL) ) /* cause core dump */
	fclose(filep);
  filep_value(tt)=(FILE *)NULL;
  return(SYSTRUE);
}

int closes_pred(t,e)
struct term *t;
struct pair *e;
{
	FILE *filep;
	int i;
	for(i = 0; i < FOPEN_MAX; i++) {
		filep = OPEN_FILES[i];
		if (filep != (FILE *)NULL) {
			if ((filep != stdin) && (filep != stdout))
				fclose(filep);
			OPEN_FILES[i] = (FILE *)NULL;
		}
	}
	return(SYSTRUE);
}


struct clause *new_pred_def2(vl,vnum) /* <-- project_pred */
struct term *vl;
int vnum;
{
	register struct term *v,*tmp,*t;
	register struct func *newfunc;
	struct clause *c;
	int i,arity=0;

	tmp = Nterm(vnum,TEMPORAL);
	for (v = vl; v != NULL; v = vlink(v))
	    if (((struct var *)v)->v_type == (long int)VAR_GLOBAL_TYPE)
		Arg(tmp,arity++) = v;
	if (arity == 0) return((struct clause *)NULL);
	t = Nterm(arity,ETERNAL);
	for (arity--, i=0; arity >= 0 ; arity--, i++)
	    Arg(t,i) = Arg(tmp,arity);
	while (1) {		/* new predicate name */
	  sprintf(nbuf, "%s%d", genname, GENSYM++);
	  if (exist_fname(nbuf) == NULL) break;
	}
	newfunc = Nfunc(ETERNAL, nbuf, vnum);
	newpred(newfunc);
	index_func(newfunc);
	t->type.t_func = newfunc;
	c = Nclause(t,(struct clause *)NULL,ETERNAL);
	recalc_voccurrence(c, vl);
	return(c);
}


int project_pred(t,e,n)	/* print constraint */
struct term *t;
struct pair *e;
register struct node *n;
{
    struct term *tt, *tnew;
    struct clause *nclause, *body;
    struct set *s;
    struct pair *e0;

    e0 = Nenv(0);
    up_init();
    EVAL_PST_FLAG = TRUE;
    tt = Arg1(t);
    tnew = termset(tt,&tt,e,ETERNAL);	/* should be ETERNAL! */
    EVAL_PST_FLAG = FALSE;
    nclause = new_pred_def2(v_list,v_number);
    if (nclause == NULL) {
	tprint0("no constraint");
	return(SYSTRUE); /* need not print */
    }
    body = up_eclause(n->n_constraint, ETERNAL);
    up_restore(NULL, ETERNAL);
    nclause->c_link = body;	/* Head:-Body. */

#ifdef MAC
	s = (struct set *)salloc(5);	/* sizeof(set) = 5 */
#else
    s = snew(set);
#endif
    s->s_clause = nclause;
    s->s_anumber = (unsigned short int)(v_number + p_number);
    s->s_vlist = v_list;
    s->s_link = NULL;
    s->s_constraint = NULL;
    s->s_bodynumber = 0;	/* set in add_set */
    if (p_number != 0) {
	renum_pvars((struct pstvar *)pv_list,v_number);
    }
    add_set(s,ASSERT_TOP);

    Pterm(nclause->c_form,e0);
    return(SYSTRUE);
}

int pcon_pred(t,e,n)	/* print constraint */
struct term *t;
struct pair *e;
register struct node *n;
{
	Peclause(n->n_constraint);
	return(SYSTRUE);
}

int attach_pred(t,e,n,m,status)	/* attach constraints */
struct term *t;
struct pair *e;
struct node *n,*m;
int status;
{
	struct pair *p, *ee;
	struct term *tt;
	register struct clause *c;
	struct eclause *ec;
	static char *emesg = "attach_constraint/1: Illegal Argument";
	struct clause *convert_list_to_clause();

	tt = Arg1(t);
	ee = e;
	down(p,tt,ee);
	if (is_list(tt)) {
		c = convert_list_to_clause(t,e,tt,ee,&p,emesg);
	}
	else if (is_clause(tt)) {
		c = (struct clause *)tt;
		p = ee;
	}
	else if (tt == NIL) return(SYSTRUE);
	else if (is_functor(tt)) {
		c = Nclause(tt, (struct clause *)NULL, TEMPORAL);
		p = ee;
	}
	else error_detail(t,e,emesg);

	ec = transform(n->n_constraint, c, p);
	if (ec == (struct eclause *)MFAIL)
		return(SYSFAIL);
	upush(&(m->n_constraint));
	m->n_constraint = ec;
	return(SYSTRUE);
}

int cunify_pred(t,e) /*  c.u.  unify() */
register struct term *t;
register struct pair *e;
{ 
	if (cu(t,e) != FALSE )
		return(SYSTRUE);	/* success */
	else
		return(SYSFAIL);	/* fail */
}

int write_pred(t,e)
struct term *t;
struct pair *e;
{
  register struct pair *p, *ee = e;
  register struct term *tt;
  FILE *filep = wfp;
  char *emsg = "write/2: %s";
  int arity;
#ifdef MAC
	char openmode;
#endif

  if ((arity = (int)t->t_arity) < 0) arity = -arity;
  if (arity == 2) {
    tt = Arg2(t);
    down(p,tt,ee);
    if ((! is_file(tt)) || (filep_value(tt) == (FILE *)NULL)) {
	sprintf(nbuf,emsg,"Illegal file pointer");
	error_detail(t,e,nbuf);
      }
    wfp = filep_value(tt);
#ifndef MAC
    if (! is_writable(wfp))
#else
    openmode = OPEN_FILE_MODE[(int)fnum_value(tt)];
    if (! (openmode == 'w') || (openmode =='a'))
#endif
      {
	wfp = filep;
	sprintf(nbuf,emsg,"File not open for writing");
	error_detail(t,e,nbuf);
      }
  }
  else wfp = WRITE_FILE;

#ifdef MAC
	if (wfp != stdout) KEYOUT=FALSE;
#endif
  tt = Arg1(t);
  down(p,tt,e);
  if (is_string(tt)) { tprint1("%s",str_value(tt)); }
  else Pterm(tt, e);
  wfp = filep;
#ifdef MAC
	KEYOUT=TRUE;
#endif
  return(SYSTRUE);
}

int put_pred(t,e)
struct term *t;
struct pair *e;
{
  register struct pair *p, *ee = e;
  register struct term *tt;
  FILE *filep = wfp;
  char *emsg = "put/%d: %s";
  int arity;
  char c;

  if ((arity = (int)t->t_arity) < 0) arity = -arity;
  if (arity != 1) {
    tt = Arg2(t);
    down(p,tt,ee);
    if ((! is_file(tt)) || (filep_value(tt) == (FILE *)NULL)) {
	sprintf(nbuf,emsg,2,"Illegal file pointer");
	error_detail(t,e,nbuf);
	}
    wfp = filep_value(tt);
#ifndef MAC
    if (! is_writable(wfp))
#else
    c =OPEN_FILE_MODE[(int)fnum_value(tt)];
    if (! (c == 'w') || (c =='a'))
#endif
      {
	wfp = filep;
	sprintf(nbuf,emsg,2,"File not open for writing");
	error_detail(t,e,nbuf);
      }
  }
  else wfp = WRITE_FILE;
#ifdef MAC
	if (wfp != stdout) KEYOUT=FALSE;
#endif
  tt = Arg1(t);
  down(p,tt,e);
  if (! is_int(tt)) {
	wfp = filep;
	sprintf(nbuf,emsg,arity,"Argument is not number");
	error_detail(t,e,nbuf);
  }

  c = (char)num_value(tt);
  tputc(c);
  wfp = filep;
#ifdef MAC
	KEYOUT=TRUE;
#endif
  return(SYSTRUE);
}

int nl_pred(t,e)
register struct term *t;
register struct pair *e;
{
  register struct pair *p;
  FILE *filep = wfp;
  char *emsg = "nl/1: %s";
  int arity;
#ifdef MAC
	char openmode;
#endif

  if ((arity = (int)t->t_arity) < 0) arity = -arity;
  if (arity != 0) {
    t = Arg1(t);
    down(p,t,e);
    if ((! is_file(t)) || (filep_value(t) == (FILE *)NULL)) {
	sprintf(nbuf,emsg,"Illegal file pointer");
	error(nbuf);
	}
    wfp = filep_value(t);
#ifndef MAC
    if (! is_writable(wfp))
#else
    openmode = OPEN_FILE_MODE[(int)fnum_value(t)];
    if (! (openmode == 'w') || (openmode =='a'))
#endif
      {
	wfp = filep;
	sprintf(nbuf,emsg,"File not open for writing");
	error_detail(t,e,nbuf);
      }
  }
 else wfp = WRITE_FILE;

#ifdef MAC
	if (wfp != stdout) KEYOUT=FALSE;
#endif
  NL;
#ifdef MAC
	KEYOUT=TRUE;
#endif
  wfp = filep;
  return(SYSTRUE);
}

int tab_pred(t,e)
register struct term *t;
register struct pair *e;
{
  register struct pair *p;
  FILE *filep = wfp;
  char *emsg = "tab/1: %s";
  int arity;
#ifdef MAC
	char openmode;
#endif

  if ((arity = (int)t->t_arity) < 0) arity = -arity;
  if (arity != 0) {
    t = Arg1(t);
    down(p,t,e);
    if ((! is_file(t)) || (filep_value(t) == (FILE *)NULL)) {
	sprintf(nbuf,emsg,"Illegal file pointer");
	error_detail(t,e,nbuf);
      }
    wfp = filep_value(t);
#ifndef MAC
    if (! is_writable(wfp))
#else
    openmode = OPEN_FILE_MODE[(int)fnum_value(t)];
    if (! (openmode == 'w') || (openmode =='a'))
#endif
      {
	wfp = filep;
	sprintf(nbuf,emsg,"File not open for writing");
	error_detail(t,e,nbuf);
      }
  }
  else wfp = WRITE_FILE;

#ifdef MAC
	if (wfp != stdout) KEYOUT=FALSE;
#endif
  tprint0("\t");
  wfp = filep;
#ifdef MAC
	KEYOUT=TRUE;
#endif
  return(SYSTRUE);
}

int var_pred(t,e)
struct term *t;
register struct pair *e;
{
	register struct pair *p;
	register struct term *tt;

        tt = Arg(t,0);
	down(p,tt,e);
	if (p != NULL) return(SYSTRUE);		/* (t,e) is var */
	else return(SYSFAIL);			/* (t,e) is not var */
}

/* equal ( = ) predicate :
	equal(t1,t2) = SYSTRUE : if t1/e = t2/e
	else SYSFAIL
*/

int equal_pred(t,e)
register struct term *t;
struct pair *e;
{
	return(equalpred(Arg(t,0),e,Arg(t,1),e));
}

int eq_pred(t,e)
register struct term *t;
struct pair *e;
{
	return(eq_pred_sub(Arg(t,0),Arg(t,1),e,e));
}

int eq_pred_sub(x,y,ex,ey)
register struct term *x, *y;
register struct pair *ex, *ey;
{
	register struct pair *p;

	down(p,x,ex);
	down(p,y,ey);

	if ((x == y) && (ex == ey)) return(SYSTRUE);
	if (isvar(x) || (p != NULL)) return(SYSFAIL);

	if (x->type.ident != y->type.ident) return(SYSFAIL);
	if (is_atomic(x)) {
	  if (atomic_equal(x,y)) return(SYSTRUE);
	  else return(SYSFAIL);
	}
	if (is_pst(x))
	  return(eq_pred_sub(((struct pst *)x)->p_var,((struct pst *)y)->p_var,
			     ex,ey));

	if (is_clause(x) || is_list(x)) {
	  do {
	    if (eq_pred_sub(head_of_list(x),head_of_list(y),ex,ey) == SYSFAIL)
	      return(SYSFAIL);
	    x = tail_of_list(x);
	    y = tail_of_list(y);
	  } while ((x != NULL) && (x != NIL) && (y != NULL) && (y != NIL));
	  return(SYSTRUE);
	}
	if (is_functor(x) && is_functor(y)) {
	    register int i, a = (int)x->t_arity;
	    if (a != (int)y->t_arity) return(SYSFAIL);
	    if (a < 0) a = -a;
	    for(i=0;i < a; i++) {
	      if (eq_pred_sub(Arg(x,i),Arg(y,i),ex,ey) == SYSFAIL)
		return(SYSFAIL);
	  }
	}
	return(SYSTRUE);
}


int equalpred(t1,e1,t2,e2)
register struct term *t1, *t2;
register struct pair *e1, *e2;
{
	long int *hsave;
	struct pair *esave;
	struct ustack *usave;

	esave = ep;
	hsave = hp;
	usave = usp;

	if (tunify(t1,e1,t2,e2,0) == FALSE)
	{
		undo(usave);
		hp = hsave;
		ep = esave;
		return(SYSFAIL);
        }
	return(SYSTRUE);
}

int assertz_pred(t,e)
struct term *t;
struct pair *e;
{ 
  general_assert(t,e,ASSERT_LAST);
  return(SYSTRUE);
}

int assert_pred(t,e)
struct term *t;
struct pair *e;
{ 
  general_assert(t,e,ASSERT_TOP);
  return(SYSTRUE);
}

void general_assert(t,e,flag)
struct term *t;
struct pair *e;
int flag;			/* 'a'(first) or 'z'(last) */
{
    struct term *pred, *defs, *con;
    register struct pair *p, *ee;
    struct clause *c_head, *c_con;
    int arity;
    char *emsg = "assert/1: %s";

    pred = Arg(t,0);
    ee = e;
    down(p,pred,ee);
    if ((p != NULL) || is_atomic(pred)) {
	sprintf(nbuf,emsg,"Illegal argument");
	error_detail(t,e,nbuf);
	}
    if (issystem(pred->type.t_func)) {
	sprintf(nbuf,emsg,"system function cannot be asserted");
	error_detail(t,e,nbuf);
	}

    up_init();
    if ((arity = (int)t->t_arity) < 0) arity = -arity;
            /* make first clause (head) */
    con = (arity == 3) ? Arg(t,2) : NULL;
    defs = (arity > 1) ? Arg(t,1) : NULL;
    c_head = Nclause(termset(pred,&c_head,ee,ETERNAL),
		     list_to_clause(defs,e), ETERNAL);
    c_con = list_to_clause(con,e);
    c_con=up_restore(c_con,ETERNAL);
    if (p_number != 0) renum_pvars((struct pstvar *)pv_list,v_number);
    index_set(c_head,c_con,flag);
}

struct clause *list_to_clause(t,e)
register struct term *t;
register struct pair *e;
{
  struct clause *croot, *cbefore, *cc;
  register struct pair *p;
  long int *ssave = shp;

  if (t != NULL) down(p,t,e);
  if ((t == NULL) || (t == NIL)) return(NULL);

#ifdef MAC
  croot = (struct clause *)salloc(3);	/* sizeof(clause) = 3 */
#else
  croot = snew(clause);
#endif
  croot->c_type = CLAUSE_TYPE;
  cbefore = cc = croot;
  while(1)
    {
      if ((! is_list(t)) && (! is_clause(t))) {
	shp = ssave;
	error_detail(t,e,
		"In assert or execute: Illegal argument ... should be LIST");
	}
      cc->c_form = termset(head_of_list(t),&cc->c_form,e,ETERNAL);
      t = tail_of_list(t);
      down(p,t,e);
      if (t == NIL) break;
      cbefore = cc;

#ifdef MAC
	cc = (struct clause *)salloc(3);	/* sizeof(clause) = 3 */
#else
      cc = snew(clause);
#endif
      cc->c_type = CLAUSE_TYPE;
      cbefore->c_link = cc;
    }
  cc->c_link = NULL;
  return(croot);
}


int retract_pred(t,e,n,status)
struct term *t;
struct pair *e;
struct node *n;
int status;
{
	register struct set *ss, *foreset;
	register struct pair *p, *et;
	register struct ustack *usave;
	struct term *tt;
	struct term *c_defs, *c_con;
	struct term *defs, *con;
	struct pair *newenv;
	int arity;

	if ((arity = (int)t->t_arity) < 0) arity = -arity;	
	tt = Arg(t,0);
	et = e;
	down(p,tt,et);
	if (isvar(tt) || is_atomic(tt))
	  error("retract*/1: Illegal argument");
	if (!isuser(tt->type.t_func)) return(SYSFAIL);
	if ((status == BACKTRACK) && (n->n_set != DUMMY_DEF))
		{
		  foreset = n->n_set;
		  ss = foreset->s_link;
		}
	else
	  {
	    foreset = NULL;
	    ss = Pred(tt)->def.f_set;
	  }
	
	usave = usp;

	con = (arity == 3) ? Arg3(t) : NIL;
	defs = (arity >= 2) ? Arg2(t) : NIL;
	while(ss != NULL)
	  {
	    newenv = Nenv((int)ss->s_anumber);
	    if (tunify(tt,et,ss->s_clause->c_form,newenv,0)==FALSE)
	    {
	      undo(usave); foreset = ss; ss = ss->s_link;
	      continue;
	    }
	    c_defs = tolist(ss->s_clause->c_link,TEMPORAL);
	    if (tunify(defs,e,c_defs,newenv,0) == FALSE)
	    {
	      undo(usave); foreset = ss; ss = ss->s_link;
	      continue;
	    }
	    c_con = tolist(ss->s_constraint,TEMPORAL);
	    if (tunify(con,e,c_con,newenv,0) == FALSE)
	    {
	      undo(usave); foreset = ss; ss = ss->s_link;
	      continue;
	    }
	    if (foreset == NULL)	/* set the next goal */
	      {
		Pred(tt)->def.f_set = ss->s_link;
		n->n_set = DUMMY_DEF;
	      }
	    else
	      {
		foreset->s_link = ss->s_link;
		n->n_set = foreset;
	      }
	    ((struct func *)tt->type.t_func)->f_setcount--;
	    if is_unitclause(ss) 
	      ((struct func *)tt->type.t_func)->f_unitcount--;
	    ((struct func *)tt->type.t_func)->f_mark |= VACUITY_NOCHECK;
	    Def_Modified = 1;
	    return(SYSTRUE);
	  }
	return(SYSFAIL);
}

void clear_predicate(f)		/* clear user predicate */
register struct func *f;
{  
	f->def.f_set = NULL;
	f->f_setcount = 0;
	f->f_unitcount = 0L;
	f->f_roles[0] = 0;
}

int abolish_pred(t,e)
struct term *t;
struct pair *e;
{
  register struct term *f, *a;
  register struct pair *ef, *ea, *p;
  struct func *fun;
  char *emsg = "abolish/2: %s";

  f = Arg(t,0);
  a = Arg(t,1);
  ef = ea = e;
  down(p,f,ef); down(p,a,ea);
  
  if ((f->type.ident < (long int)CONST_LIST_TYPE) || (! is_int(a))) {
	sprintf(nbuf,emsg,"Illegal argument.");
	error_detail(t,e,nbuf);
	}

  fun = funcsearch(Predname(f),(int)(num_value(a)));
  if (fun != NULL) 
    {
      if (issystem(fun)) {
	sprintf(nbuf,emsg,"System predicates cannot be abolished");
	error_detail(t,e,nbuf);
	}
      clear_predicate(fun);
      Def_Modified = 1;		/* def modified ! */
    }
  return(SYSTRUE);
}

int atomname_pred(t,e)
struct term *t;
struct pair *e;
{
  struct term *a,*n, *r;
  register struct pair *ea, *en, *p;
  char *emsg = "atomname/2: %s";

  a = Arg1(t); n = Arg2(t);
  ea = en = e;
  down(p,a,ea);
  down(p,n,en);

  if (isvar(a)) {
    if (isvar(n)) { /* both arguments are VAR */
	r = Nstr(((struct var *)a)->v_name,TEMPORAL);
	return(equalpred(n,en,r,NULL));
    }
    if (! is_string(n)) {
	sprintf(nbuf,emsg,"2nd argument should be STRING");
	error_detail(t,e,nbuf);
    }

    r = Nterm(0,TEMPORAL);
    r->type.t_func = Predicate(str_value(n),0);
    return(equalpred(a,ea,r,NULL));
  }

  if (! is_functor(a)) {
	if (! is_atomic(a)) {
	sprintf(nbuf,emsg,"1st argument should be FUNCTOR");
	error_detail(t,e,nbuf);
      }
	switch (a->t_arity) {
	case FLOAT_NUM:	sprintf(nbuf,"%f",num_value(a));
			break;
	case INT_NUM:	sprintf(nbuf,"%ld",(long int)(num_value(a)));
			break;
	case FILE_POINTER: sprintf(nbuf,"#%x",(int)fnum_value(a));
			break;
	default: /* string */
		return(equalpred(n,en,a,ea));
        }
	r = Nstr(nbuf,TEMPORAL);
	return(equalpred(n,en,r,NULL));
      }
  if (! (isvar(n) || is_string(n))) {
	sprintf(nbuf,emsg,"2nd argument is illegal");
	error_detail(t,e,nbuf);
      }
  r = Nstr(Predname(a),TEMPORAL);
  return(equalpred(n,en,r,NULL));
}


int makelist_pred(t,e)   /* for predicate ' ml(Pred,List)  (=..) ' */
struct term *t;
struct pair *e;
{
        struct term *t0, *t1, *tt, *tfun;
	register struct pair *e0, *e1, *efun, *p;
        int nvars, depth = 0;
	char *emsg = "ml/2: Illegal argument for %s";

	 t0 = Arg(t,0);
	 t1 = Arg(t,1);
	 e0 = e1 = e;
	 down(p,t0,e0);
	 down(p,t1,e1);

	 /* 1st arg is var */
	 if( isvar(t0) ){
	    if (isvar(t1)) return(SYSFAIL);
	    if (! is_list(t1)) {
		sprintf(nbuf,emsg,"2nd one");
		error_detail(t,e,nbuf);
		}

	tfun = head_of_list(t1);  /* tfun : functor name */
	    efun = e1;
	    down(p,tfun,efun);
	    if (isvar(tfun) || (! is_functor(tfun))) {
		sprintf(nbuf,emsg,"functor");
		error_detail(t,e,nbuf);
		}

	    t1 = tail_of_list(t1);
	    depth=Llevel(t1,e1,&nvars);
	    if (Pred(tfun) == LIST) {
	      if (depth != 2) {
		sprintf(nbuf,emsg,"LIST");
		error_detail(t,e,nbuf);
		}
	      tt = (struct term *)
		Nlist(head_of_list(t1),
		      (struct clause *)tail_of_list(t1),TEMPORAL);
	      return(equalpred(t0,e0,tt,efun));
	    }
	    tt = Nterm(depth,TEMPORAL);
	    Pred(tt) = Predicate(Predname(tfun), depth);
	    if (t1 != NIL )
	      {
		efun = Nenv(0);
		LtoP(t1,e1,tt,depth);
	      }
	    return(equalpred(t0,e0,tt,efun));
	  }

	 /* 1st arg is term */
	 if (is_atomic(t0)) tfun=t0;
	 else if (is_list(t0)) {
	   Pred(tfun)=LIST;
	   tt = (struct term *)Nlist(tfun,(struct clause *)t0,TEMPORAL);
	   return(equalpred(t1,e1,tt,e0));
	 }
	 else if (is_functor(t0))
	   {
	     tfun = Nterm(0,TEMPORAL);
	     tfun->type.t_func = Predicate(Predname(t0),0);
	   }
	 else {
		sprintf(nbuf,emsg,"1st");
		error_detail(t,e,nbuf);
	}
	 tt = (struct term *)Nlist(tfun,PtoL(t0),TEMPORAL);
	 return(equalpred(t1,e1,tt,e0));
}

int Llevel(t,e,nv)   /* from makelist() : Listlevel -> Depth (int) */
register struct term *t;
register struct pair *e;
int *nv;
{
  register struct pair *pp;
  int depth=0;

  *nv = 0;

  if (isvar(t)) down(pp,t,e);
  while( t != NIL )
    {
      if (! is_list(t)) error("ml/2: cdr is real var");
      if (! isconst(head_of_list(t))) (*nv)++;
      t = tail_of_list(t);
      depth++;
      if (isvar(t)) down(pp,t,e);
    };
  return(depth);
}


void LtoP(t,e,tt,depth) /* from makelist() : List -> Predicate */
register struct term *t, *tt;
register struct pair *e;
int depth;
{
	  register struct pair *p;
          register int i;

	  v_list = NULL; v_number = 0;
	  for(i = 0; i < depth ; i++)
	    {
	      if (isvar(t)) down(p,t,e);
	      if (isconst(head_of_list(t))) Arg(tt,i)=head_of_list(t);
	      else {
		Nvar(Anonymous_VarName,TEMPORAL);
		p = Nenv(1);
		p->p_body = head_of_list(t);
		p->p_env = e;
		Arg(tt,i)=(struct term *)v_list;
	      }
	      t = tail_of_list(t);
	    }
          return;
}


struct clause *PtoL(t)    /* from makelist() : Predicate -> List */
struct term *t;
{
  struct clause *root;
  register struct term *tt;
          int pos = 0, arity;

	  if (is_atomic(t)) return((struct clause *)NIL);
          if ((arity = (int)t->t_arity)==0) return((struct clause *)NIL);
	  if (arity < 0) arity = -arity;

          root = Nlist(NIL,(struct clause *)NIL,TEMPORAL);
          tt = (struct term *)root;
	  while(1) {
	    head_of_list(tt) = Arg(t,pos);
	    pos++;
            if (pos >= arity) break;
	    ((struct clause *)tt) ->c_link = Nlist(NIL,(struct clause *)NIL,TEMPORAL);
	    tt = tail_of_list(tt);
	  }
	  return(root);
	}

int name_pred(t,e)      /* for predicate  ' name(String,List) ' */
struct term *t;
struct pair *e;
{
        register struct term *tt,*arg0,*arg1;
	register struct pair *p,*e0,*e1;

	arg0 = Arg(t,0);
	arg1 = Arg(t,1);
	e0 = e1 = e;
        *nbuf = '\0';
	down(p,arg0,e0);
	down(p,arg1,e1);

	/* 1st arg is var */
        if (isvar(arg0)){
	       if (isvar(arg1)) return(SYSFAIL);
               LtoC(arg1,e1,0,FROM_NAME);    /* List -> (char)nbuf[] */
	       if (alldigit((int *)nbuf)) tt = Nnum(nbuf,TEMPORAL);
	       else {
		 tt = Nterm(0,TEMPORAL);
		 Pred(tt) = Predicate(nbuf,0);
	       }
     return(equalpred(arg0,e0,tt,(struct pair *)NULL));
	}

    /* 1st arg is constant */
	if (is_num(arg0)) 
          { 
	    sprintf(nbuf,"%d",(int)num_value(arg0));
            tt = CtoL(nbuf, FROM_NAME);
          }
        else if (is_string(arg0))
	  tt = CtoL( str_value(arg0), FROM_NAME );
	else tt = CtoL(Predname(arg0), FROM_NAME);
        return(equalpred(arg1,e1,tt,(struct pair *)NULL));
}


void LtoC(t,e,pos, flag)       /* from name_pred() : List -> Charactar */
struct term *t;
struct pair *e;
int pos, flag;   /* flag = 0(FROM_CONC) /char, 1(FROM_NAME) /int */
{
    register struct pair *e0, *e1, *p;
    register struct term *arg0, *arg1;

    if (is_string(t)) 
      { strcpy(nbuf, str_value(t)); return; }
    if (! is_list(t)) error("name/2: 2nd arg is illegal term.");
    arg0 = head_of_list(t);
    arg1 = tail_of_list(t);
    e0 = e1 = e;
    down(p,arg0,e0);
    down(p,arg1,e1);

    if (isvar(arg0) || (! isatom(arg0)) || isvar(arg1)) {
      sprintf(nbuf,"%s/2: 2nd arg is real VAR",
		((flag) ?  "name" : "concat2"));
      error_detail(t,e,nbuf);
   }
    if (flag) {
      if (! is_int(arg0))
	error("name/2: 2nd arg contains illegal term.");
      else nbuf[pos++] = (int)num_value(arg0);
    }
    else 
      {
	if (is_string(arg0))
	  strcat(nbuf, str_value(arg0));
	else if ((is_functor(arg0)) && (isatom(arg0)))
	  strcat(nbuf,Predname(arg0));
	else if (is_int(arg0)) {
		int len = strlen(nbuf);
		nbuf[len++] = (int)num_value(arg0);
		nbuf[len] = '\0';
		}
	else {
	  error_detail(arg0,e0,"concat2/2: illegal arg");
	}
      }
    if (arg1 != NIL) LtoC(arg1,e1,pos,flag);
    else if (flag) nbuf[pos] = '\0';
    return;
}

struct term *CtoL(nbuf, flag)
          /* from name_pred() : Charactar -> List */
char *nbuf;
int flag;  /* 0(FROM_CONC) -> char, 1(FROM_NAME) -> int */
{
  struct term *root, *t;
  char s[2];
  register int pos = 0;

  root = t = (struct term *)Nlist(NIL,(struct clause *)NIL,TEMPORAL);
  while (1)
    {
      if (flag) {
	head_of_list(t)=Nnum_val((float)nbuf[pos++],TEMPORAL);
      }
      else {
	*s = nbuf[pos++];
	*(s+1) = '\0';
	head_of_list(t) = Nstr(s, TEMPORAL);
      }
      if (nbuf[pos] == '\0') return(root);
	    ((struct clause *)t) ->c_link = 
	    	Nlist(NIL,(struct clause *)NIL,TEMPORAL);
	    t = tail_of_list(t);
    }
}

int arg_pred(t,e)
struct term *t;
struct pair *e;
{
  register struct term *pos, *tt, *var;
  register struct pair *p, *ep, *et, *ev;
  int i, arity;
  char *emsg = "arg/3: Illegal Argument for %s";

  pos = Arg(t,0);
  tt = Arg(t,1);
  var = Arg(t,2);

  ep = et = ev = e;
  down(p,pos,ep); down(p,tt,et); down(p,var,ev);

  if (isvar(pos) || isvar(tt)) return(SYSFAIL);
  if (! is_int(pos)) {
	sprintf(nbuf,emsg,"1st one");
	error_detail(t,e,nbuf);
	}
  i = num_value(pos);
  if (is_list(tt))
    switch (i) {
      case 1: return(equalpred(head_of_list(tt),et,var,ev));
      case 2: return(equalpred(tail_of_list(tt),et,var,ev));
      default:
	sprintf(nbuf,emsg,"position");
	error_detail(t,e,nbuf);
      }
  else if (! is_functor(tt)) {
	sprintf(nbuf,emsg,"functor");
	error_detail(t,e,nbuf);
	}

  if((arity = (int)tt->t_arity) < 0) arity = -arity;
  if ((i <= 0) || (tt->type.ident == 0L) || i > arity) {
	sprintf(nbuf,emsg,"2nd");
	error_detail(t,e,nbuf);
	}
  return(equalpred(Arg(tt,i-1),et,var,ev));
}


int functor_pred(t,e)
struct term *t;
struct pair *e;
{
  register struct term *tt, *fun, *ari;
  register struct pair *p, *et, *ef, *ea;

  tt = Arg(t,0); fun = Arg(t,1); ari = Arg(t,2);
  ea = ef = et = e;
  
  down(p,tt,et); down(p,fun,ef); down(p,ari, ea);

  if (isvar(tt)) return(make_func(fun,ari,tt,et));
  if ((! is_functor(tt)) && (! is_list(tt)))
	error_detail(t,e,"functor/3: 1st argument is not appropriate");
  return(match_func(tt,fun,ef,ari,ea));
}

int make_func(f,a,t,e)
struct term *f, *a, *t;
struct pair *e;
{
  struct term *temp;
  struct pair *env;
  int i,arity;
  char *emsg = "functor/3: %s arg is %s";

  if (isvar(f) || isvar(a)) return(SYSFAIL);
  if (! (isatom(f))) {
	sprintf(nbuf,emsg,"2nd","not atom");
	error_detail(t,e,nbuf);
	}
  if (! (is_int(a))) {
	sprintf(nbuf,emsg,"3rd","not integer");
	error_detail(t,e,nbuf);
	}
  if ((arity = (int)(num_value(a))) < 0) {
	sprintf(nbuf,emsg,"3rd","unappropriate number");
	error_detail(t,e,nbuf);
	}

  if (arity==0)  return(equalpred(t,e,f,e));

  v_list = NULL;  v_number = 0;
  env = Nenv(arity);
  if ((arity == 2) && (Pred(f)==LIST))
	temp = (struct term *)
		Nlist(Nvar(Anonymous_VarName,TEMPORAL),
	      (struct clause *)Nvar(Anonymous_VarName,TEMPORAL),TEMPORAL);
  else {
   temp = Nterm(arity,TEMPORAL);
   Pred(temp) = Predicate(Predname(f), arity);
   for (i=0; i < arity; i++)
	Arg(temp,i)=Nvar(Anonymous_VarName,TEMPORAL);
    }
  return(equalpred(t,e,temp,env));
}

int match_func(t,f,ef,a,ea)
struct term *t, *f, *a;
struct pair *ef, *ea;
{
  struct term *temp;
  int arity;
  long int *hsave;
  struct pair *esave;
  struct ustack *usave;

	hsave = hp;
	esave = ep;
	usave = usp;

  arity = (int)t->t_arity;
  if (arity < 0) arity = -arity;

  if (is_list(t)) 
	temp = Nnum_val(2.0, TEMPORAL);
  else temp = Nnum_val((float)arity,TEMPORAL);

  if (tunify(a,ea,temp,(struct pair *)NULL,0) == FALSE) {
	  undo(usave);	  hp = hsave;	  ep = esave;
	  return(SYSFAIL);
  }

  temp = Nterm(0,TEMPORAL);
  if (is_list(t)) Pred(temp)=LIST;
  else Pred(temp) = Predicate(Predname(t), 0);

  if (tunify(f,ef,temp,(struct pair *)NULL,0) == FALSE) {
	undo(usave);	  hp = hsave;	  ep = esave;
	return(SYSFAIL);
  }
  return(SYSTRUE);
}

int clause_pred(t,e,n,status)	/* clause(P,B,C) P:nonvar*/
struct term *t;
struct pair *e;
struct node *n;
int status;
{
	register struct pair *ee, *p, *newenv;
	register struct term *tt;
	struct term *t_body, *t_con;
	struct ustack *usave;
	struct set *s;
	long int *hsave;
	struct pair *esave;

	ee = e;
	tt = Arg(t,0);   /* head */
	down(p,tt,ee);

	if (isvar(tt)) return(SYSFAIL);
    else if (! is_functor(tt))
         error_detail(t,e,"Argument is illegal");

    if (tt->type.t_func->f_mark & SYSFUN) /* system function */
        return(SYSFAIL);
    if (status != BACKTRACK)
        n->n_set = tt->type.t_func->def.f_set;
    if (n->n_set == NULL)
        return(SYSFAIL);

	usave = usp;
	hsave = hp;
	esave = ep;
	for (s = n->n_set; s != NULL; s = s->s_link)
	{
		newenv = Nenv((int)s->s_anumber);
		if (tunify(tt,ee,s->s_clause->c_form,newenv,0) == FALSE)
		{
			undo(usave);hp = hsave;	ep = esave;continue;
		}
		
		t_body = tolist(s->s_clause->c_link,TEMPORAL);
		tt = Arg(t,1);
		ee = e;
		down(p,tt,ee);
		if (tunify(tt, ee, t_body, newenv,0)==FALSE)
		{
			undo(usave);hp = hsave;	ep = esave;continue;
		}

		t_con = tolist(s->s_constraint,TEMPORAL);
		tt = Arg(t,2);
		ee = e;
		down(p,tt,ee);
		if (tunify(tt, ee, t_con, newenv,0) == FALSE)
		{
			undo(usave);hp = hsave;	ep = esave;continue;
		}

		n->n_set = s->s_link; /* next goal */
		return(SYSTRUE);
	}
	return(SYSFAIL);
}

int consult_pred(t,e)
struct term *t;
struct pair *e;
{
  int consult_general();

  return(consult_general(t,e,ASSERT_LAST));
}

int reconsult_pred(t,e)
struct term *t;
struct pair *e;
{
  int consult_general();

  return(consult_general(t,e,ASSERT_NEW));
}

int consult_general(t,e,flag)
struct term *t;
struct pair *e;
int flag;	/* reconsult -> ASSERT_NEW */
{
  register struct pair *p, *ee;
  register struct term *tt;
  char  *fname;
  int echoback_save = ECHO_BACK;
  struct ustack *uspsave = usp;
  FILE *fopen();
#ifdef MAC
  int KEYINsave = KEYIN;
#endif

  tt = Arg1(t);
  ee = e;
  down(p,tt,ee);
  if (p != NULL) {
		error_detail(t,e,": Invalid Argument");
	}
  if (is_string(tt)) fname=str_value(tt);
  else if (!is_atomic(tt)) fname=tt->type.t_func->f_name;
  else {
	error_detail(t,e,": Illegal filename");
	}

  upush(&fp);
  utop = usp;

	if (strcmp(fname,"user")==0) {
		fp = stdin;
		is_user_input=TRUE;
#ifdef MAC
		KEYIN = TRUE;
#endif
	}
  else {
#ifdef MAC
	 KEYIN = FALSE; SetCursor(&waitCursor);
#endif
	fp = fopen(fname, "r");
	if (fp == NULL) {
		undo(uspsave);
		error_detail(t,e,": No File");
	}
  }

	if (flag == ASSERT_NEW) set_oldpred_flag();
	line_counter=1;
		
	while (uspsave < usp) {
		prolog_execution();
	}

	if (flag == ASSERT_NEW) reset_oldpred_flag();
	ECHO_BACK = echoback_save;
	is_user_input=FALSE;
	line_counter=0;
#ifdef MAC
	KEYIN = KEYINsave;
#endif
	return(SYSTRUE);
}

