/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 19893
*
*		<<<< refute.c >>>>
*			normal prolog
*
* 90.4.1 ver.3.00
* 90.7.1 ver.3.10
*/

#include "include.h"
#include <signal.h>
#ifdef MAC
#include "macconst.h"
#endif

#define is_dead(n) (n->n_set == NULL)
#define is_tip(n)  (n->n_clause == NULL)
#define is_root(n) (n->n_link == NULL)


/* struct node *Last_SKIP = NULL;  used in Trace_() in steptrace mode*/

/* refutation status flag --> defined in include.h*/
/* #define DOWN 1 
   #define UP   2
   #define BACKTRACK 3
*/

struct node *Psolution(), *proceed_node(), *refute_extend();
void Trace_True(),Trace_False(),Trace_Unification(),Trace_Answer();
void Trace_True2(), Trace_False2();
int Trace_Goal();
void Pbinding();
#ifndef MAC
void on_interrupt_refute();
#endif
void load_files();

struct node *Newnode(goal, icons, env, nlink, nlast)
struct clause *goal;
struct eclause *icons;
struct pair *env;
struct node *nlink, *nlast;
{
	struct node *n;

#ifdef MAC
	n = (struct node *)alloc(11);	/* sizeof(node) = 11 */
#else
	n = new(node);
#endif
	n->n_last = nlast;	/* backtrack node */
	n->n_link = nlink;	/* mother node */
	n->n_clause = goal;	/* goal */
	n->n_env = env;
	n->n_hp = hp;
	n->n_ep = ep;
	n->n_usp = usp;
	if (nlink == NULL) n->n_count = 0;
	else n->n_count = nlink->n_count + 1;
	n->n_spy = 0;
	n->n_tmp = 0;		
	n->n_scount = 0;
	n->n_constraint = icons;
	if (goal != NULL) n->n_set = init_set(n);
	else n->n_set = NULL;
	return(n);
}

struct set *init_set(n)
register struct node *n;
{
	register struct term *t;
	register struct pair *e,*p;
	struct set *s;	

	if (n->n_clause == NULL) return(NULL);
        t = n->n_clause->c_form;
	e = n->n_env;
	down(p,t,e);
	if (p != NULL) return(NULL); /* goal is var */
	if (! is_functor(t)) {
		if (! is_list(t)) /* load files */
			error_detail(t,e,"Illegal program code");
	}
	else {
	  n->n_spy = Is_Steptrace || (Is_Trace && isspy(t->type.t_func));
	  if (isuser(t->type.t_func)) {
		if (((s = t->type.t_func->def.f_set)== (struct set *)NULL)
		      && (Handle_Undefined == TRUE)) {
			sprintf(nbuf,">>> %s <<< is UNDEFINED!",
					t->type.t_func->f_name);
			error(nbuf);
		  }
		else return(s);
		}
	}
	return(NULL);
}


struct node *backtrack_node(n)	/* restore stack, heap */
struct node *n;
{
  while (n != NULL)
    {
      Trace_False2(n);
      if(! is_dead(n)) {
	undo(n->n_usp);
	hp = n->n_hp;
	ep = n->n_ep;
	return(n);
      }
      n = n->n_last;
    }
  return(NULL);
}

int have_nextgoal(n)
struct node *n;
{
	if (n->n_clause == NULL) return(FALSE);
	if (n->n_clause->c_link != NULL) return(TRUE);
	return(FALSE);
}

struct node *next_goal(m,oldnode,btnode)
struct node *m, *oldnode,*btnode;
{
	struct node *n;
	
	n = Newnode(m->n_clause->c_link, oldnode->n_constraint, 
		    m->n_env, m->n_link, btnode);
	n->n_count = oldnode->n_count +1;
	return(n);
}
	
struct node *proceed_node(n,btnode)
struct node *n,*btnode;
{
	register struct node *m;
	
	for (m = n; m != NULL; m = m->n_link)
	{
	  Trace_True2(m);
	  if (have_nextgoal(m)) 
	    return(next_goal(m,n,btnode));
	}
	return(NULL);
}

#ifdef MAC
void interrupt_question()
{
	DialogPtr	myDialog;
	int itemType, itemNo;
	Rect box;

	myDialog = GetNewDialog(InterruptDialog,0,(WindowPtr)-1);
	GetDItem(myDialog,ContinueItem,&itemType,&GoOnHandle,&box);
	GetDItem(myDialog,StepTraceItem,&itemType,&OtherHandle,&box);
	GetDItem(myDialog,AbortItem,&itemType,&QuitHandle,&box);
	while (1) {
		ModalDialog(0, &itemNo);
		switch (itemNo) {
		case StepTraceItem:
			Steptrace_mode;
			if (! isspy(MODULAR_P)) spychange(MODULAR_P);
		case ContinueItem:
			DisposDialog(myDialog);
			return;
		case AbortItem:
			DisposDialog(myDialog);
			longjmp(reset,1);
		}
	}
}
#else
void on_interrupt_refute()
{
	allspy(1);
    Steptrace_mode;
}
#endif

int refute(Root,n,Status)
struct node *Root, *n;
int Status;
{
	struct node *m;
#ifdef MAC
	EventRecord		myEvent;
	void interrupt_question();
#else
	signal(SIGINT, on_interrupt_refute);
#endif

  while(1) {
#ifdef MAC
	MaintainCursor();
	SystemTask();
	TEIdle(TEH);
	if (GetNextEvent(everyEvent, &myEvent)) {
	    switch (myEvent.what) {
   		case autoKey:
	    case keyDown: {
			register char	theChar;
			theChar = myEvent.message & charCodeMask;
			if ((myEvent.modifiers & cmdKey) != 0)
				if (theChar == '.') {
					SysBeep(10);
					interrupt_question();
					break;
				}
			}
		}
	}
#endif

      if (Trace_Goal(n)==FALSE) return(FALSE);
      m = refute_extend(n, Status);
      if (!is_dead(n)) Last_BT = n;
      if (m == NULL)	/* fail */
	{
	  Trace_False(n);
	  if (n == Root) return(FALSE);
	  Status = BACKTRACK;
	  Last_BT = n = backtrack_node(n->n_last);
	}
      else if (is_tip(m)) /* nil clause */
	{
	  Trace_True(n);
	  Status = UP;
	  n = proceed_node(m,Last_BT);
	  if (n == NULL) {
/* 1992-03-18 */ /* the following may cause a trouble */
		Root->n_constraint=m->n_constraint;
		return(TRUE);
		}
	}
      else {
	Status = DOWN; 
	n = m;
      }
    }
}

struct node *refute_extend(n, status) /* extend goal */
struct node *n;
int status;
{
	register struct term *sliteral;	/* selected literal */
	struct node *m;
	register struct pair *p,*env;

	if (n->n_count > Refcount) {
		ttyprint1("  <<%d] fail! (over refute counter)",n->n_count);
		ttynl;
		return(NULL); /* counter over = fail */
	}
	if (is_tip(n)) return(n); /* no goal */
	sliteral = n->n_clause->c_form;
	env = n->n_env;
	down(p,sliteral,env);
	if (p != NULL) return(NULL); /* goal is real var */
	m = Newnode((struct clause *)NULL,n->n_constraint,
		    (struct pair *)NULL,n,n);
	if (! is_functor(sliteral)) {
		if (is_list(sliteral)) { /* load files */
			load_files(sliteral,env);
			n->n_set = NULL;
			return(m);
		}
		else error_detail(sliteral,env,"Illegal program code");
	}
	if (is_funcsys(sliteral->type.t_func)) /* functional syspred */
	{
		if (system_function(sliteral, env, n) == SYSFAIL)
			return(NULL);
		else {
		  n->n_set = NULL;
		  return(m);
		}
	}
	if (is_nofuncsys(sliteral->type.t_func)) /* sys pred.  */
	{
		if (system_pred(sliteral, env, n, m, status) == SYSFAIL) 
			return(NULL);
		else {
		  return(m);
		}
		/* n->n_set may be DUMMY_DEF */
	}
	if (is_dead(n)) return(NULL);
	if (resolve(n, m, sliteral, env) == FALSE) 
		return(NULL); /* user pred.: resolution */
	m->n_usp = usp;
	m->n_hp = hp;
	m->n_ep = ep;
	m->n_set = init_set(m);
	return(m);
}


int resolve(n0, n, sliteral, env) /* resolution */
struct node *n0,*n;
struct term *sliteral;
struct pair *env;
{
  struct ustack *usave;
  long int *hsave;
  struct pair *esave;
  register struct set *s;
  register struct eclause *ec;

  usave = usp;hsave = hp;esave = ep;
  for (s = n0->n_set; s != NULL; s = s->s_link)
    {
      n->n_env = Nenv((int)s->s_anumber);
      if (tunify(sliteral, env, s->s_clause->c_form, n->n_env,0) == FALSE){
	undo(usave);hp = hsave;	ep = esave;
	continue;
      }
      ec = transform(n0->n_constraint, s->s_constraint, n->n_env);
      if (ec == (struct eclause *)MFAIL) {
	/* constraint transformation failure */
	undo(usave);hp = hsave;	ep = esave;
	continue;
      }
      n->n_constraint = ec;
      Trace_Unification(n0,s);
      n0->n_set = s->s_link;
      n->n_clause = s->s_clause->c_link;
      return(TRUE);
    }
  return(FALSE);
}

int Panswer(root, vlist)	/* print solution */
struct node *root;
struct term *vlist;
{
  Trace_Answer(root);
  Pbinding(vlist, root->n_env);
  if (root->n_constraint != (struct eclause *)NULL) {
	ttynl;
	ttyprint0(" where ");
	Peclause(root->n_constraint);
  }

  if (Last_BT == NULL) {
	ttynl;
	return(FALSE); /* no backtrack point */
  }
#ifdef MAC
  if (KEYIN != TRUE)
#else
  if ((fp != stdin) || (!keyread(';')))
#endif
	return(FALSE);
#ifdef MAC
  else {
  	ShowSelect();
  	next(); *ibufpt='\0';
  	if (cbuf != ';') return(FALSE);	
  	return(TRUE);	/* more solution */
  }
#else
	return(TRUE);
#endif
}

void Pbinding(vlist, env)	/* print var binding */
struct term *vlist;
struct pair *env;
{
	FILE *filep = wfp;
	char *vn;
	if (vlist == NULL) return;
	Pbinding(vlink(vlist),env);
	vn=vname(vlist);
	if ((vn[0]=='_') ||
	    ((int)vlist->type.ident != VAR_GLOBAL_TYPE)) return;
	wfp = stdout;
	ttyprint1("  %s = ",vn);
	Pterm(vlist,env);
	wfp = filep;
}
		
int Trace_Goal(n)
	struct node *n;
{
   void print_ancestors();
   FILE *filep = wfp;

   if (n == NULL) return(FALSE);
   if (Is_Notrace) return(TRUE);
   if (Last_SKIP == n) Last_SKIP = NULL;
   if (Last_SKIP != NULL) return(TRUE);
   if (Is_Normaltrace && (! n->n_spy)) return(TRUE);
   wfp = stdout;
   ttyprint1(" [%d>>",n->n_count);
   Pgoal(n); ttynl;
   wfp = filep;
   if ((Is_Steptrace) || (Is_Leap && (n->n_spy))) {
	Steptrace_mode;
	while(1) {
		ttyprint0("  #<trace ?>");
#ifdef MAC
		next();
		switch (cbuf) {
#else
		switch (getchar()) {
#endif
		  case 'a' :
		  case 'A' : print_ancestors(n);
#ifdef MAC
			SKIPLINE;
#else
			getchar();
#endif
			break;
		  case 'b' :
		  case 'B' : {
			long int  *hsave;
			struct pair *esave;
			struct ustack *usave = utop;
			struct func *flistsave = f_list;
			struct itrace *newflistsave = newflist_save;
			struct pst_item *psttable_save = psttable->p_link;
			struct node *LBT = Last_BT, *LSK = Last_SKIP;
#ifdef MAC
			SKIPLINE;
#else
			getchar();
#endif
			hsave = hp; esave = ep;
			utop = usp; f_list = NULL; newflist_save = newf_list; 
			psttable->p_link = (struct pst_item *)NULL;
			if (setjmp(unbreak_reset)) {
				Last_BT = LBT; Last_SKIP = LSK;
				utop = usave; hp = hsave; ep = esave;
				f_list = flistsave; newf_list = newflist_save;
				newflist_save = newflistsave;
				psttable->p_link = psttable_save;
				break;
			  }
			while(1) {
				f_list = NULL;
				usp = utop;
				newflist_save = newf_list;
				psttable->p_link = (struct pst_item *)NULL;
				prolog_execution();
			}
		     }
		  case 'z' :
		  case 'Z' :
		  case 'q' :
		  case 'Q' :
#ifdef MAC
			SKIPLINE;
#else
			getchar();
#endif
			ttynl; ttyprint0("Execution Aborted"); ttynl;
#ifdef MAC
			ShowSelect();
#endif
			longjmp(reset,0);
		  case '?' :
		  case 'h' :
		  case 'H' :
#ifdef MAC
			SKIPLINE;
   			Alert( RefuteHelp, 0L); ttynl  break;
#else
			getchar();
	ttyprint0("\na: ancestors\tb: break\th : help\tl: leap\t\ts: skip\n");
	ttyprint0("<cr>: next\tn: normal trace\tx: trace off \tq: abort\t");
	ttyprint0("f: fail\nd: show definition\n");
	break;
#endif
		  case 'f' :
		  case 'F' :
#ifdef MAC
			SKIPLINE;
#else
			getchar();
#endif
			return(FALSE);
		  case 'n' :
		  case 'N' :
#ifdef MAC
			SKIPLINE;
#else
			getchar();
#endif
			Normaltrace_mode; return(TRUE);
		  case 'l' :
		  case 'L' :
#ifdef MAC
			SKIPLINE;
#else
			getchar();
#endif
			tflag = 3; return(TRUE);
		  case 's' :
		  case 'S' :
#ifdef MAC
			SKIPLINE;
#else
			getchar();
#endif
			Last_SKIP = n; return(TRUE);
		  case 'x' :
		  case 'X' :
#ifdef MAC
			SKIPLINE;
#else
			getchar();
#endif
			Notrace_mode; return(TRUE);
		  case 'D' :	 		/*  list definition */
		  case 'd' :
			readword(nbuf);
			showdef(nbuf);
			ttynl;
			break;
#ifndef MAC
		  case '\n' :  Last_SKIP = NULL; return(TRUE);
#endif
		  default : SKIPLINE; Last_SKIP = NULL; return(TRUE);
		  }
		}
	}
	else ttynl;
	return(TRUE);
 }

void Trace_False(n)
struct node *n;
{
	struct func *f;
	struct pair *p, *e;
	struct term *t;

	if (!(n->n_spy)) return;
	if (Last_SKIP == n) Last_SKIP = NULL;
	if (Last_SKIP != NULL) return;
	t = n->n_clause->c_form;
	if (isvar(t)) {
	  e = n->n_env;
	  down(p,t,e);
	}
	f = t->type.t_func;
	if (is_funcsys(f))
	{
		ttyprint2("  <<%d] false (%s)",n->n_count,f->f_name); ttynl;
	}
	else if (is_nofuncsys(f))
	{
		ttyprint2("  <<%d] fail (%s)",n->n_count,f->f_name); ttynl;
	}
	else			/* user pred */
	{
		ttyprint2("   <=%d-no= fail %s.",n->n_count,f->f_name); ttynl;
	}
}

void Trace_True(n)
struct node *n;
{
	struct func *f;
	struct term *t;
	struct pair *p, *e;

	if (!(n->n_spy)) return;
	if (Last_SKIP == n) Last_SKIP = NULL;
	if (Last_SKIP != NULL) return;
	t = n->n_clause->c_form;
	e = n->n_env;
	down(p,t,e);
	f = t->type.t_func;
	if (isuser(f)) return;
	ttyprint1("  <<%d] ",n->n_count);	
	if (is_funcsys(f))
	{
		ttyprint1("true (%s)",f->f_name); ttynl;
	}
	else 
	{
		ttyprint1("success (%s)",f->f_name); ttynl;
	}
}

void Trace_False2(n)
struct node *n;
{
	if (!(n->n_spy)) return;
	if (Last_SKIP == n){
		ttyprint1("  <<%d] fail",n->n_count); ttynl;
		Last_SKIP = NULL;
	}
}

void Trace_True2(n)
struct node *n;
{
	if (!(n->n_spy)) return;
	if (Last_SKIP == n){
		/* ttyprint1("  <<%d] true",n->n_count); */
		Last_SKIP = NULL;
	}
}

void Trace_Unification(n,s)
struct node *n;
struct set *s;
{
	FILE *filep = wfp;
	n->n_scount++;
	if (!(n->n_spy)) return;
	if (Last_SKIP != NULL) return;
	wfp = stdout;
	ttyprint2("   <=%d-%d=",n->n_count, n->n_scount);
	Showhorn(s->s_clause, s->s_constraint, (struct pair *)NULL);
	ttynl;
	wfp = filep;
}

void Trace_Answer(root)
struct node *root;
{
	FILE *filep = wfp;
	if (Is_Notrace) return;
	wfp = stdout;
	Last_SKIP = NULL;
	ttyprint0("success."); ttynl;
	Psequence(root->n_clause, root->n_env, Print_Depth);
	if (root->n_constraint != (struct eclause *)NULL) {
		ttyprint0(" ; ");
		Peclause(root->n_constraint);
	}
	ttynl;
	wfp = filep;
}

void print_ancestors(n)
struct node *n;
{
   FILE *filep = wfp;
   wfp = stdout;
   while (n != NULL) {
     ttyprint1(" [%d>>",n->n_count); Pgoal(n); ttynl;
     n = n->n_link;
     }
   wfp = filep;
 }

void load_files(t,e)
struct term *t;
struct pair *e;
{
   struct term *tt, *tnext;
   struct pair *p, *ee, *enext;
   struct ustack *uspsave = usp;
   int echoback_save = ECHO_BACK;
   char *fname;
#ifdef MAC
	int KEYINsave = KEYIN;
#endif
   void set_oldpred_flag(), reset_oldpred_flag();

   tnext = t; enext = e; ECHO_BACK = FALSE;

   while (tnext != NIL) {
	tt = head_of_list(tnext);
	ee = enext;
    down(p,tt,ee);

	if (is_string(tt)) fname=str_value(tt);
	else if (is_functor(tt)) {
		if (Pred(tt)==MINUSSIGN_P) {
			if (is_string(Arg1(tt))) fname=str_value(Arg1(tt));
			else fname=Predname(Arg1(tt));
			set_oldpred_flag();
		}
		else fname=Predname(tt);
	}
	else error_detail(t,e,"Illegal file name");

	upush(&fp);
	utop = usp;

	if (strcmp(fname,"user")==0) {
		fp = stdin;
		is_user_input=TRUE;
#ifdef MAC
		KEYIN = TRUE;
#endif
	}
	else	{
#ifdef MAC
	 KEYIN = FALSE; SetCursor(&waitCursor);
#endif
	fp = fopen(fname,"r");
	if (fp == NULL) {
		undo(uspsave);
		error_detail(tt,ee,"Empty File");
		}
	}

	while (uspsave < usp) {
		prolog_execution();
	}

	tnext = tail_of_list(tnext);
	down(p,tnext,enext);
	if (Pred(tt)==MINUSSIGN_P) reset_oldpred_flag();
	}
	ECHO_BACK = echoback_save;
	is_user_input=FALSE;
#ifdef MAC
	KEYIN = KEYINsave;
#endif
}

void set_oldpred_flag()
{
	register int i;
	register struct func *f;

	for (i=0; i < HASH_SIZE; i++) {
		for (f=hash_list[i]; f != (struct func *)NULL; f=f->f_link)
			if (isuser(f) && (f->def.f_set != (struct set *)NULL))
				set_oldpred(f);
	}
}

void reset_oldpred_flag()
{
	register int i;
	register struct func *f;

	for (i=0; i < HASH_SIZE; i++) {
		for (f=hash_list[i]; f != (struct func *)NULL; f=f->f_link)
			if (isuser(f) && (f->def.f_set != (struct set *)NULL))
				reset_oldpred(f);
	}
}
