/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*		<<<< mainsub.c >>>>
*
*		system command etc.
*
*88/6/13
*90.6.13 ver3.02
* 90.7.1 ver3.10
*/

#include "include.h"

#ifdef MAC

#include "macconst.h"
#define SAVEAREA_SIZE 7

void loghandle ()
{
	int refNum, vRef;

	if (lfp != 0) {
		ParamText("\pLog file closed!","\p","\p","\p");
		Alert( ErrorAlert, 0L );
		FSClose(lfp);
		lfp = 0;
		}
	nbuf[0] = '\0';
	if (NewFile(nbuf, &vRef)) 
		if (CreateFile(nbuf, &vRef, &refNum)) {
			lfp = refNum;
		}
		else {
			FileError("\pError creating file ", nbuf);
	}
}

void save_program ()
{
    int i, vRef,refNum, lfpsave, ksave;
    register struct func *f;

	nbuf[0] = 0;
	if (NewFile(nbuf, &vRef)) 
		if (CreateFile(nbuf, &vRef, &refNum)) {
			lfpsave = lfp; ksave = KEYOUT;
			lfp = refNum;
			PleaseWait();
			KEYOUT = UP;
		    tprint0("%%%%%% cu-Prolog predicates  %%%%%%%% \r");
    		writenewfunc(); NL;
    		for (i = 0; i< HASH_SIZE; i++)
	    		for (f = hash_list[i]; f != NULL; f = f->f_link)
		    		if (isuser(f) && isnoreduced(f))
			    		Showfunc(f);
 			FSClose( refNum );
 			KEYOUT = ksave;
			SetCursor(&editCursor);
 			lfp = lfpsave;
		}
		else {
			FileError("\pError creating file ", nbuf);
		}
}

void quit_prolog () {		/* system quit */
	if (lfp !=0) FSClose(lfp);
/*		CloseMyDialogs(); */
		CloseMyWindow();
		ClosePointers();
	    ExitToShell();			/* end */
}

#else

/* ------------------------------------------------------------ */

#define SAVEAREA_SIZE 3

void loghandle (fname)		/* log file	(%l command) */
char   *fname;
{
	if (strcmp (fname, "no") == 0) {
		ttyprint0 ("===  log stop  ===\n");
		if (lfp != NULL) fclose (lfp);
		lfp = NULL;
		strcpy (logfile, "no");
	}
	else if ((fopen (fname, "r")) != NULL) {
		ttyprint1 ("'%s' : already exist\n", fname);
	}
	else if ((fopen (fname, "w")) == NULL) {
		ttyprint1 (" '%s' : can't open\n", fname);
	}
	else {
		if (lfp != NULL) {
		    fclose (lfp);
		    ttyprint1 (" == %s : close ==\n", logfile);
		}
		lfp = fopen (fname, "w");
		ttyprint1 (" log file '%s'\n", fname);
		strcpy (logfile, fname);
	    }
}

void save_program ()
{
	readword(nbuf);
	filewrite(nbuf); /* save program */
}

void filewrite (n) /* write program to file */
char   *n;
{
    FILE * lfpsave;
    int i;
    register struct func *f;

    if ((wfp = fopen (n, "r")) != NULL) {
	fclose (wfp);
	wfp = stdout;
	ttyprint1 (" %s : already exist\n", n);
	return;
    }

    if ((wfp = fopen (n, "w")) == NULL) {
	wfp = stdout;
	ttyprint1 (" %s : can't open\n", n);
	return;
    }

    fprintf(wfp,"%%%%%% cu-Prolog predicates  %%%%%%%%\n");
    lfpsave = lfp;
    lfp = NULL;
    writenewfunc();
    tputc('\n');
    for (i = 0; i< HASH_SIZE; i++)
	    for (f = hash_list[i]; f != NULL; f = f->f_link)
		    if (isuser(f) && isnoreduced(f))
			    Showfunc(f);
    fclose (wfp);
    wfp = stdout;
    lfp = lfpsave;
    ttyprint1 ("=== write to: %s ===\n", n);
    return;
}

void oscommand () {		/* os command interpreter */
    int     i;

    for (i = 0; (cbuf != '\n'); next ())
	nbuf[i++] = cbuf;
    nbuf[i] = '\0';
    if (system (nbuf) != 0) {
	ttyprint0 ("== OS command error ==");
	ttynl;
	}
}

void delete_tmp ()		/* delete temp file */
{
	FILE *fptmp;

	if ((fptmp = fopen("TEMPF.###","r")) != NULL) {
		fclose(fptmp);
		system ("rm -f TEMPF.###");
	}
}

void free_memory()
{
	cfree((char *)heap);
	cfree((char *)eheap);
	cfree((char *)ustack);
	cfree((char *)cheap);
	cfree((char *)sheap);
	free(nheap);
}

void quit_prolog () {		/* system quit */
    ttynl; ttyprint0("---- Quit cu-Prolog ? (y/n) ----");
    SKIPLINE;
    if (keyread('y')) {
	if (lfp != NULL) fclose (lfp);	/* close log file */
	delete_tmp ();		/* delete temp file */
	free_memory();
	exit(0);		/* end */
	}
    ttynl; ttyprint0(".... Return to Prolog ...."); ttynl; /* cansel */
    return;
}
/* ------------------------------------------------------------ */
#endif

void putcursor()
{
#ifdef MAC
	if (*ibufpt == '\0') {
#endif
	   if (is_user_input == FALSE) {
		if (Is_Notrace) {	/* trace off */
			ttyputc ('_');
		}
		else
		if (Is_Normaltrace) {	/*  trace on */
			ttyputc ('$');
		}
		else ttyputc ('>');	/*  step trace on */
	    }
	    else
		ttyprint0(user_prompt);
#ifdef MAC
	ShowSelect();
 	}
#endif
}

int REC_to_FINITE = 1;
void check_all_unit(),rec_to_finite(),check_unitpred();
int is_body_finite();

void check_recursion()		/* check recursive user predicates */
{
	int i;

	if (Def_Modified == 0) return;
	for (i = 0; i < HASH_SIZE; i++)
		check_all_unit(hash_list[i]);
	REC_to_FINITE = 1;
	while(REC_to_FINITE != 0)
	{
		REC_to_FINITE = 0; /* global flag */
		rec_to_finite(); /* traverse predicates */
	}
	Def_Modified = 0;	/* def modified flag off */
}

void check_unitpred(f)
struct func *f;
{
	if (issystem(f)) return;
	if ((f->f_setcount == 0) || (f->f_setcount == (int)f->f_unitcount))
	{
		finitefun(f);
		return;
	}
	recursivefun(f);
}

void check_all_unit(fl)
struct func *fl;
{
	register struct func *f;
	
	if (fl == NULL) return;
	for (f = fl; f != NULL; f = f->f_link) {
		check_unitpred(f);
		if (f->f_mark & VACUITY_NOCHECK) recalc_f_roles(f);
	      }
}
	
void rec_to_finite()		/* recursive pred -> finite pred */
{
	register int i;
	register struct func *f;

	for (i = 0; i < HASH_SIZE; i++)
		for(f = hash_list[i]; f != NULL; f = f->f_link)
		{
			if (issystem(f)) continue;
			if (isfinite(f)) continue;
			if (is_body_finite(f) != 0) 
			{
				REC_to_FINITE = 1;
				finitefun(f);
			}
		}
}

int is_body_finite(f)		/* if all the body is finite  */
struct func *f;
{
	register struct set *s;
	register struct clause *c;
	
	for (s = f->def.f_set; s != NULL; s = s->s_link)
		for (c = s->s_clause->c_link; c != NULL; c = c->c_link)
			if (isvar(c->c_form) || 
			    isrecursive(c->c_form->type.t_func))
			  return(FALSE);
	return(TRUE);
}

int check_not_vacuous(cl,i)
struct clause *cl;
int i;
{
	struct term *t = Arg(cl->c_form,i);

	if (! isvar(t)) return(TRUE);
	if (((struct var *)t)->v_occurrence == 0) return(FALSE);
	while ((cl = cl->c_link) != (struct clause *)NULL) {
          if (is_functor(cl->c_form))
		switch (occurr_and_not_vacuous(t,cl->c_form))
		  {
		   case TRUE: return(TRUE);
		   case SUSPEND: return(SUSPEND);
		   default: break;
		   }
	}
        return(FALSE);
      }

int occurr_and_not_vacuous(v,t)
struct term *v, *t;
{
	int a = (int)t->t_arity - 1;
	struct func *f = t->type.t_func;

	while (a >= 0) {
	  if (v == Arg(t,a)) {
	    if (f->f_mark & VACUITY_NOCHECK) {
	      recalc_f_roles(f);
	      if (f->f_mark & VACUITY_NOCHECK) 
		return(SUSPEND);
	    }
	    if (not_vacuous(f,a)) return(TRUE);
	  }
	  a--;
	}
	return(FALSE);
}

int not_vacuous(f,i)
struct func *f;
int i;
{
	int j = i / INTEGER_SIZE;
	return(f->f_roles[j] & (1 << (i-(j*INTEGER_SIZE))));
}

void set_f_roles(f,i)
struct func *f;
int i;
{
	int j = i / INTEGER_SIZE;
	f->f_roles[j] |= (1 << (i-(j*INTEGER_SIZE)));
}

void recalc_f_roles(f)
struct func *f;
{
  register int i,j;
  int arity = (int)f->f_arity;
/* we assume the maximum number of variables is 128 */	
  unsigned int save_froles[SAVEAREA_SIZE];
  register struct set *s;

  f->f_mark &= (~ VACUITY_NOCHECK);
  if (issystem(f)) return;

  while (1) {
    for (i = (arity / INTEGER_SIZE); i >= 0; i--)
      save_froles[i] = f->f_roles[i];
    for (i = 0; i < arity; i++) {
      if (j = not_vacuous(f,i)) continue;
      if ((s = f->def.f_set) == NULL) {
	f->f_mark |= VACUITY_NOCHECK;
	return;
      }
      while ((j == FALSE) && (s != (struct set *)NULL)) {
	j = check_not_vacuous(s->s_clause,i);
	s = s->s_link;
      }
      if (j == TRUE) set_f_roles(f,i);
      else if (j == SUSPEND) {
	f->f_mark |= VACUITY_NOCHECK;
	return;
      }
    }
    for (i = (arity / INTEGER_SIZE); i >= 0; i--)
      if (save_froles[i] != f->f_roles[i]) break;
    if (i < 0) return;
  }

}

void preprocess_constraints(fn)
char *fn;
{
	struct func *f;
	int arity;
	void preprocess_constr_sub(), preprocess_unit();

	if (strcmp(fn,"*") == 0) {
		ttyprint0("--- preprocess all predicates ---"); ttynl;
		preprocess_constr_sub(TRUE);
		ttyprint0("Done"); ttynl;
		return;
		}
	if (strcmp(fn,"?") == 0) {
	  ttyprint0("--- showing predicates with nonmodular constraints ---");
	ttynl;
	  preprocess_constr_sub(FALSE);
	  ttynl;
	  return;
	  }
	arity = decode_pname(fn);
	if (! exist_fname(fn)) {
		ttyprint1("'%s' does not exist",fn); ttynl;
		return;
	}
	if (arity == -1) { /* any arity */
	  for (f =  hash_list[hash(fn)]; f != NULL; f = f->f_link)
	    if (streq(f->f_name,fn))
	      preprocess_unit(f,TRUE);
	}
	else {
	  f = funcsearch(fn,arity);
	  if (f == NULL) {
	    ttyprint2("'%s/%d' does not exist.",fn,arity); ttynl;
	    return;
	  }
	  preprocess_unit(f,TRUE);
	}
	ttyprint0("Done");
	ttynl;
}

void preprocess_constr_sub(flag)
int flag;	/* preproces control flag */
{
	register int i;
	void preprocess_all_unit();

	for (i = 0; i < HASH_SIZE; i++)
		preprocess_all_unit(hash_list[i],flag);
}

void preprocess_all_unit(fl,flag)
struct func *fl;
int flag;
{
	register struct func *f;
	void preprocess_unit();

	if (fl == NULL) return;
	for (f = fl; f != NULL; f = f->f_link)
		preprocess_unit(f,flag);
}

void preprocess_unit(f,flag)
struct func *f;
int flag;
{
	register struct set *s;
	struct clause *c, *sol;
	struct pair *env;
        int sflagsave=sflag;

	if (issystem(f)) return;
	for (s = f->def.f_set; s != (struct set *)NULL; s = s->s_link) {
	  c = s->s_constraint;
	  if (c == (struct clause *)NULL) continue;
	  if (is_modular_clause(c) == TRUE) continue;
	  if (flag == FALSE) { 
	    Showhorn(s->s_clause,c,(struct pair *)NULL);
	    ttynl;
	    continue;
	  }

	  ttyprint2("%s/%d\t", f->f_name,f->f_arity);
          Modular_mode;
	  sol = startmodular(c,s->s_vlist);
	  if (sol == MFAIL) { /* failing transformation */
#ifndef MAC
	    wfp = stderr;
#endif
	    ttyprint1("Warning: Failing transformation in %s",
		    f->f_name);	ttynl
	    Showhorn(s->s_clause,c,(struct pair *)NULL);
	    ttynl;
#ifndef MAC
	    wfp = stdout;
#endif
	    continue;
	  }

	  env = Nenv((int)s->s_anumber);
	up_init();
	  s->s_constraint = (struct clause *)
		termset((struct term *)sol,NULL,env,ETERNAL);
	  (s->s_clause) = (struct clause *)
		termset((struct term *)s->s_clause,NULL,env,ETERNAL);
          s->s_clause->c_link = up_restore(s->s_clause->c_link,ETERNAL);
	  if (p_number != 0) {
	    renum_pvars((struct pstvar *)pv_list,v_number);
	  }
	  s->s_anumber = (unsigned short int)(v_number+p_number);
	  s->s_vlist = v_list;
	}
        sflag=sflagsave;
      }

/************* print CPU time ******************************/
#if SUN4 == 1 /* print CPU time */
#include <sys/time.h>
long    TIMESAVE;		/* system time saver (time_t = long) */

void printtime () {		/* print CPU time from the previous settime()*/
  long clock();
  ttyprint2 ("CPU time = %.3lf sec (Constraints Handling = %.3lf sec)",
	   ((double)(clock() - TIMESAVE))/ 1000000.0,
	   ((double)CONSTRAINT_HANDLING_TIME/1000000.0));
  ttynl;
}

void settimer () {		/* set clock	 */
  long clock();
  TIMESAVE = clock();
  CONSTRAINT_HANDLING_TIME = 0L;
}
#elif MAC == 1
#include <time.h>
unsigned long int TIMESAVE;
void printtime() {
  long int t = TIMESAVE;
  TIMESAVE = TickCount();
  ttyprint2("Elapsed Total time = %6.2f sec (Constraints Handling  = %6.2f sec)\r",
  		((float)(TIMESAVE-t)/60.0),
  		((float)CONSTRAINT_HANDLING_TIME/60.0));
}
void settimer() {
  TIMESAVE = TickCount();
  CONSTRAINT_HANDLING_TIME = 0L;
}
#elif CPUTIME == 0		/* do not print CPU-time */
void printtime () {
}
void settimer () {
}

#else  /* BSD */
#include <sys/types.h>
#include <sys/times.h>
time_t    TIMESAVE;		/* system time saver (time_t = long) */
struct tms TIMES;		/* cf. times() */

/*
* Structure returned by old times() interface
*     struct tms {
*          time_t    tms_utime;           user time 
*          time_t    tms_stime;           system time 
*          time_t    tms_cutime;          user time, children 
*          time_t    tms_cstime;          system time, children
*     };
*/

void printtime () {		/* print CPU time from the previous settime()*/
	time_t  ttemp;

	times(&TIMES);		/* get time */
	ttemp = TIMES.tms_stime + TIMES.tms_utime;
	ttyprint2 ("CPU time = %.3lf sec (Constraints Handling = %.3lf sec)", 
	     (ttemp - TIMESAVE) / CPUTIME.0,
	     (CONSTRAINT_HANDLING_TIME / CPUTIME.0));
	ttynl;
}

void settimer () {		/* set clock	 */
	times(&TIMES);
	TIMESAVE = TIMES.tms_stime + TIMES.tms_utime;
	CONSTRAINT_HANDLING_TIME = 0L;
}

#endif
