/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*		<<<< menu.c >>>>
*
*		menu command
*
*	92.02.28 ver 3.61
*/

#include "include.h"

void helpmenu () {		/* on-line help */
  ttyprint0 ("\t%%h\t: help\t\t\t%%Q : quit"); ttynl;
#ifndef MAC
  ttyprint0 ("\t# <OS command>: OS command interpreter\n");
#endif
  ttyprint0 ("\t%%d <predicate name>: list definition"); ttynl;
  ttyprint0 ("\t\t%%d* %%d/: list all\t%%d?: list all defined names"); ttynl;
  ttyprint0 ("\t\t%%d-: list user predicates"); ttynl;
  ttyprint2 ("\t%c <file name> %c: consult file (no echo)", '"', '"'); ttynl;
  ttyprint1 ("\t%c <file name> ?: consult file (with echo)", '"'); ttynl;
#ifdef MAC
  ttyprint0 ("\t%%l : set log file \r");
  ttyprint0 ("\t%%w : save program\r");
#else
  ttyprint1 ("\t%%l <file name>: set log file ['%s']\n", logfile);
  ttyprint0 ("\t%%w <file name>: save program\n");
#endif
  ttyprint0 ("\t%%p <predicate name>: spy switch"); ttynl;
  ttyprint0 ("\t\t%%p*:spy all\t%%p.:nospy all\t%%p>:unfoldfold"); ttynl;
  ttyprint0 ("\t\t%%p?:list spyed preds"); ttynl;
  ttyprint1 ("\t%%t\t: normal trace switch [%s]",
	((Is_Normaltrace) ? "on" : "off")); ttynl;
  ttyprint1 ("\t%%s\t: step trace switch [%s]",
	((Is_Steptrace) ? "on" : "off")); ttynl;
  ttyprint0 ("\t%%a\t: all modular mode ");
	if (Is_Modular) ttyprint0(" <=now");
	ttynl;
  ttyprint0 ("\t%%o\t: M-Solvable mode ");
	if (Is_Msolvable) ttyprint0(" <=now");
	ttynl;
  ttyprint1 ("\t%%c <number>: max number of refutation node [%u]",
	     Refcount); ttynl;
  ttyprint0 ("\t%%n <name>\t: new predicate name ");
    ttyprint1 ("['%s']", genname); ttynl;
  ttyprint0 ("\t%%L\t: list new predicate definitions"); ttynl;
  ttyprint0 ("\t%%f\t: show the system heap size"); ttynl;
  ttyprint0 ("\t%%C [Feature,type,... ]. : set cat() functor"); ttynl;
  ttyprint0 ("\t\t ==> ");show_category();ttynl;
#ifndef MAC
  ttyprint0 ("\t%%G\t: Garbage Collection\n");
  ttyprint0 ("\t%%I {c,h,u,e}/<number> : Increase the working area\n");
#endif
  ttyprint1 ("\t%%D <number> : Max Depth of Printing, now is %d", Print_Depth);
  ttynl;
  ttyprint1 ("\t%%u\t: Undefined Predicate Handling Switch [%s]",
	((Handle_Undefined == TRUE) ? "ERROR" : "FAIL"));
  ttynl;
  ttyprint1("\t%%M <number> : Max number of Variables in Transformation[%u]",
	MODULARMAX);
  ttynl;
  ttyprint0 ("\t%%P <predicate name>: Preprocess Constraints"); ttynl;
  ttyprint0 ("\t\t%%P*: preprocess all\t%%P?: predicates with nonmodular");
  ttynl;
  ttyprint1("\t%%S\t: Toggle Switch of Simplifier [%s]",
	((simplify_flag) ? "ON" : "OFF")); ttynl;
  ttyprint1("\t%%T\t: Toggle Switch of Timer [%s]",
	((timer_switch) ? "ON" : "OFF")); ttynl;
  ttyprint0 ("\t%%R\t: system Reset"); ttynl;
}

void freeheap () {		/* print shp status */
	ttynl; ttyprint0("permanent data area:"); ttynl;
    ttyprint2 ("\tProgram : %d K/%d K,",
	     (int)((long)(shp-sheap)/1000L),
	     (int)((long)(SHEAPTOP - sheap)/1000L));
    ttyprint2 ("String : %d K/%d K",
	     (int)((long)(nhp-nheap)/1000L),
	     (int)((long)(NHEAPTOP - nheap)/1000L));
	ttynl;

    ttyprint0("temporal data area"); ttynl;
    ttyprint2 ("\tCUwork : %dK/%dK, ",
    	 (int)((long)(Cheap_Max - cheap)/1000L),
    	 (int)((long)(CHEAPTOP - cheap)/1000L));
	ttyprint2("Heap : %dK/%dK, ",
		 (int)((long)(Heap_Max - heap)/1000L),
		 (int)((long)(HEAPTOP - heap)/1000L));
	ttyprint2 ("Ustack : %dK/%dK, ", 
		(int)((long)(Stack_Max - ustack)/1000L),
		(int)((long)(STACKTOP - ustack)/1000L));
	ttyprint2 ("Env : %dK/%dK", 
		(int)((long)(Esp_Max - eheap)/1000L),
		(int)((long)(ESPTOP - eheap)/1000L));
	ttynl;
}

void init_heap_max()
{
	Cheap_Max = cheap;
	Stack_Max = ustack;
	Esp_Max = eheap;
	Heap_Max = heap;
}

