try(X) :- abolish(memo,3),abolish(memo,1),
	abolish(new,1),
	satisfiable(X).

satisfiable(X) :-
	not clause(X,_,_),!,	 /* check system-defined function */
	X.
satisfiable(X) :-
	write(X),nl,
	memo(X),
	write("found  "),write(X),nl.
satisfiable(X) :-
	probe_new(X),
	!,
	write("fail   "),write(X),nl,fail.
satisfiable(X) :-
	memo(Y,processing,_),
	subsume(Y,X),!,
	write("loop   "),write(X),nl,
	fail.
satisfiable(X) :-
	count(N),
	asserta(memo(X,processing,N)),
	write("   "),write(N),tab,write(X),nl,
	clause(X,Y,_),
	all_satisfiable(Y,X,N).

satisfiable(X) :-
	new(_),
	count(N),
	asserta(memo(X,processing,N)),
	write("       "),write(N),tab,write(X),nl,!,
	clause(X,Y,_),
	Y=[Z|W],
	retract(new(Z)),
	all_satisfiable(W,X,N).

probe_new(X) :-
	new(Y),subsume(Y,X).

memorize(X,_) :-
        memo(Y),
	subsume(Y,X),!,fail.
memorize(X,N) :-
	or((retract(memo(_,processing,N)),
		asserta(memo(X))),
	    asserta(memo(X))),
	tab,write(N),write("  finished  "),	write(X),nl,!,
	asserta(new(X)).

all_satisfiable(_,X,N) :-
	memo(Z),
	subsume(Z,X),!,
	retract(memo(_,processing,N)).
all_satisfiable([],X,N) :-!,
	memorize(X,N).
all_satisfiable([A|B],X,N) :-
	write([A|B]),nl,
	satisfiable(A),
	all_satisfiable(B,X,N).

p(a,b).
p(c,b).
p(X,Z):-p(X,Y),p(Y,Z).
p(X,Y):-p(Y,X).

reach(X,Y):-reach(X,Z),edge(Z,Y).
reach(X,X).

edge(a,b).
edge(a,c).
edge(b,a).
edge(b,d).

q(X,Z):-q1(X,Y),q(Y,Z).
q(X,X).
q1(a,b).

r(a).
r(X):-r(f(X)),s.
s.

v(X,Y,c):-v(Z,X,Y).
v(a,b,c).

feb(0,1).
feb(1,1).
feb(N,M) :- sum(X,1,N), sum(Y,2,N), feb(X,A), feb(Y,B),sum(A,B,M).

/*
:-try( p(a,c)).
Answer = yes
:-try( reach(a,X)).
Answer = { X = a, b, c, d }
:-try( q(X,b)).
Answer = { X = a, b }
:-try( r(U)).
Answer = { U = a }
:-try( v(c,c,c)).
Answer = yes

*/
